/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.ejb.EJBAccessException;
import javax.security.jacc.PolicyContext;
import org.jboss.as.ejb3.security.SecurityContextInterceptorHolder;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.security.SecurityRolesAssociation;

public class SecurityContextInterceptor
implements Interceptor {
    private final PrivilegedAction<Void> pushAction;
    private final PrivilegedAction<Void> popAction;
    private final String policyContextID;

    public SecurityContextInterceptor(final SecurityContextInterceptorHolder holder) {
        this.pushAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                try {
                    holder.securityManager.push(holder.securityDomain, holder.runAs, holder.runAsPrincipal, holder.extraRoles);
                    if (holder.principalVsRolesMap != null) {
                        SecurityRolesAssociation.setSecurityRoles(holder.principalVsRolesMap);
                    }
                }
                catch (SecurityException e) {
                    throw new EJBAccessException(e.getMessage());
                }
                return null;
            }
        };
        this.popAction = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                holder.securityManager.pop();
                if (holder.principalVsRolesMap != null) {
                    SecurityRolesAssociation.setSecurityRoles(null);
                }
                return null;
            }
        };
        this.policyContextID = holder.policyContextID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object processInvocation(InterceptorContext context) throws Exception {
        boolean securityManager;
        String previousContextID = this.setContextID(this.policyContextID);
        boolean bl = securityManager = System.getSecurityManager() != null;
        if (securityManager) {
            AccessController.doPrivileged(this.pushAction);
        } else {
            this.pushAction.run();
        }
        try {
            Object object = context.proceed();
            return object;
        }
        finally {
            this.setContextID(previousContextID);
            if (securityManager) {
                AccessController.doPrivileged(this.popAction);
            } else {
                this.popAction.run();
            }
        }
    }

    protected String setContextID(String contextID) {
        if (System.getSecurityManager() == null) {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)contextID);
            return previousID;
        }
        SetContextIDAction action = new SetContextIDAction(contextID);
        return AccessController.doPrivileged(action);
    }

    private static class SetContextIDAction
    implements PrivilegedAction<String> {
        private String contextID;

        SetContextIDAction(String contextID) {
            this.contextID = contextID;
        }

        @Override
        public String run() {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID((String)this.contextID);
            return previousID;
        }
    }
}

