/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.cache.impl.factory.GroupAwareCacheFactoryService;
import org.jboss.as.ejb3.cache.impl.factory.NonPassivatingCacheFactoryService;
import org.jboss.as.ejb3.subsystem.CacheFactoryResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class CacheFactoryAdd
extends AbstractAddStepHandler {
    private final AttributeDefinition[] attributes;

    CacheFactoryAdd(AttributeDefinition ... attributes) {
        this.attributes = attributes;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> serviceControllers) throws OperationFailedException {
        serviceControllers.addAll(this.installRuntimeServices(context, operation, model, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        ServiceBuilder builder;
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ModelNode passivationStoreModel = CacheFactoryResourceDefinition.PASSIVATION_STORE.resolveModelAttribute(context, model);
        String passivationStore = passivationStoreModel.isDefined() ? passivationStoreModel.asString() : null;
        List unwrappedAliasValues = CacheFactoryResourceDefinition.ALIASES.unwrap(context, model);
        Set aliases = unwrappedAliasValues != null ? new HashSet(unwrappedAliasValues) : Collections.EMPTY_SET;
        ServiceTarget target = context.getServiceTarget();
        ServiceBuilder serviceBuilder = builder = passivationStore != null ? new GroupAwareCacheFactoryService(name, aliases).build(target, passivationStore) : new NonPassivatingCacheFactoryService(name, aliases).build(target);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        if (passivationStore != null) {
            InjectedValue clusterName = new InjectedValue();
            ServiceBuilder passivationBuilder = target.addService(ClusteredBackingCacheEntryStoreSourceService.getCacheFactoryClusterNameServiceName(name), (Service)new ValueService((Value)clusterName)).addDependency(ClusteredBackingCacheEntryStoreSourceService.getPassivationStoreClusterNameServiceName(passivationStore), String.class, (Injector)clusterName).setInitialMode(ServiceController.Mode.ON_DEMAND);
            if (verificationHandler != null) {
                passivationBuilder.addListener((ServiceListener)verificationHandler);
            }
            ServiceController clusterNameController = passivationBuilder.install();
            return Arrays.asList(controller, clusterNameController);
        }
        return Collections.singleton(controller);
    }
}

