/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.SaslAuthenticator;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.PropUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class IMAPSaslAuthenticator
implements SaslAuthenticator {
    private IMAPProtocol pr;
    private String name;
    private Properties props;
    private boolean debug;
    private PrintStream out;
    private String host;

    public IMAPSaslAuthenticator(IMAPProtocol pr, String name, Properties props, boolean debug, PrintStream out, String host) {
        this.pr = pr;
        this.name = name;
        this.props = props;
        this.debug = debug;
        this.out = out;
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(String[] mechs, final String realm, String authzid, final String u, final String p) throws ProtocolException {
        IMAPProtocol iMAPProtocol = this.pr;
        synchronized (iMAPProtocol) {
            String qop;
            boolean isXGWTRUSTEDAPP;
            SaslClient sc;
            Vector<Response> v = new Vector<Response>();
            String tag = null;
            Response r = null;
            boolean done = false;
            if (this.debug) {
                this.out.print("IMAP SASL DEBUG: Mechanisms:");
                for (int i = 0; i < mechs.length; ++i) {
                    this.out.print(" " + mechs[i]);
                }
                this.out.println();
            }
            CallbackHandler cbh = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) {
                    if (IMAPSaslAuthenticator.this.debug) {
                        IMAPSaslAuthenticator.this.out.println("IMAP SASL DEBUG: callback length: " + callbacks.length);
                    }
                    block0: for (int i = 0; i < callbacks.length; ++i) {
                        Callback rcb;
                        if (IMAPSaslAuthenticator.this.debug) {
                            IMAPSaslAuthenticator.this.out.println("IMAP SASL DEBUG: callback " + i + ": " + callbacks[i]);
                        }
                        if (callbacks[i] instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)callbacks[i];
                            ncb.setName(u);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)callbacks[i];
                            pcb.setPassword(p.toCharArray());
                            continue;
                        }
                        if (callbacks[i] instanceof RealmCallback) {
                            rcb = (RealmCallback)callbacks[i];
                            ((TextInputCallback)rcb).setText(realm != null ? realm : ((TextInputCallback)rcb).getDefaultText());
                            continue;
                        }
                        if (!(callbacks[i] instanceof RealmChoiceCallback)) continue;
                        rcb = (RealmChoiceCallback)callbacks[i];
                        if (realm == null) {
                            ((ChoiceCallback)rcb).setSelectedIndex(((ChoiceCallback)rcb).getDefaultChoice());
                            continue;
                        }
                        String[] choices = ((ChoiceCallback)rcb).getChoices();
                        for (int k = 0; k < choices.length; ++k) {
                            if (!choices[k].equals(realm)) continue;
                            ((ChoiceCallback)rcb).setSelectedIndex(k);
                            continue block0;
                        }
                    }
                }
            };
            try {
                sc = Sasl.createSaslClient(mechs, authzid, this.name, this.host, this.props, cbh);
            }
            catch (SaslException sex) {
                if (this.debug) {
                    this.out.println("IMAP SASL DEBUG: Failed to create SASL client: " + sex);
                }
                return false;
            }
            if (sc == null) {
                if (this.debug) {
                    this.out.println("IMAP SASL DEBUG: No SASL support");
                }
                return false;
            }
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: SASL client " + sc.getMechanismName());
            }
            try {
                tag = this.pr.writeCommand("AUTHENTICATE " + sc.getMechanismName(), null);
            }
            catch (Exception ex) {
                if (this.debug) {
                    this.out.println("IMAP SASL DEBUG: AUTHENTICATE Exception: " + ex);
                }
                return false;
            }
            OutputStream os = this.pr.getIMAPOutputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] CRLF = new byte[]{13, 10};
            boolean bl = isXGWTRUSTEDAPP = sc.getMechanismName().equals("XGWTRUSTEDAPP") && PropUtil.getBooleanProperty(this.props, "mail." + this.name + ".sasl.xgwtrustedapphack.enable", true);
            while (!done) {
                try {
                    r = this.pr.readResponse();
                    if (r.isContinuation()) {
                        byte[] ba = null;
                        if (!sc.isComplete()) {
                            ba = r.readByteArray().getNewBytes();
                            if (ba.length > 0) {
                                ba = BASE64DecoderStream.decode(ba);
                            }
                            if (this.debug) {
                                this.out.println("IMAP SASL DEBUG: challenge: " + ASCIIUtility.toString(ba, 0, ba.length) + " :");
                            }
                            ba = sc.evaluateChallenge(ba);
                        }
                        if (ba == null) {
                            if (this.debug) {
                                this.out.println("IMAP SASL DEBUG: no response");
                            }
                            os.write(CRLF);
                            os.flush();
                            bos.reset();
                            continue;
                        }
                        if (this.debug) {
                            this.out.println("IMAP SASL DEBUG: response: " + ASCIIUtility.toString(ba, 0, ba.length) + " :");
                        }
                        ba = BASE64EncoderStream.encode(ba);
                        if (isXGWTRUSTEDAPP) {
                            bos.write(ASCIIUtility.getBytes("XGWTRUSTEDAPP "));
                        }
                        bos.write(ba);
                        bos.write(CRLF);
                        os.write(bos.toByteArray());
                        os.flush();
                        bos.reset();
                        continue;
                    }
                    if (r.isTagged() && r.getTag().equals(tag)) {
                        done = true;
                        continue;
                    }
                    if (r.isBYE()) {
                        done = true;
                        continue;
                    }
                    v.addElement(r);
                }
                catch (Exception ioex) {
                    if (this.debug) {
                        ioex.printStackTrace();
                    }
                    r = Response.byeResponse(ioex);
                    done = true;
                }
            }
            if (sc.isComplete() && (qop = (String)sc.getNegotiatedProperty("javax.security.sasl.qop")) != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
                if (this.debug) {
                    this.out.println("IMAP SASL DEBUG: Mechanism requires integrity or confidentiality");
                }
                return false;
            }
            Object[] responses = new Response[v.size()];
            v.copyInto(responses);
            this.pr.notifyResponseHandlers((Response[])responses);
            this.pr.handleResult(r);
            this.pr.setCapabilities(r);
            if (isXGWTRUSTEDAPP) {
                Argument args = new Argument();
                args.writeString(authzid != null ? authzid : u);
                responses = this.pr.command("LOGIN", args);
                this.pr.notifyResponseHandlers((Response[])responses);
                this.pr.handleResult((Response)responses[responses.length - 1]);
                this.pr.setCapabilities((Response)responses[responses.length - 1]);
            }
            return true;
        }
    }
}

