/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.spi.LoginModule;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.GSSUtil;
import org.jboss.security.negotiation.KerberosLoginModule;

class SecurityActions {
    private static final Logger log = Logger.getLogger(SecurityActions.class);
    private static final String SUN_GSSUTIL = "com.sun.security.jgss.GSSUtil";
    private static final String CREATE_SUBJECT = "createSubject";

    SecurityActions() {
    }

    static Class<LoginModule> loadLoginModuleClass(String className) {
        return SecurityActions.loginModuleActions().loadLoginModuleClass(className);
    }

    static LoginModule newInstance(Class<LoginModule> moduleClass) {
        return SecurityActions.loginModuleActions().newInstance(moduleClass);
    }

    static void addPrivateCredential(Subject subject, Object credential) {
        SecurityActions.loginModuleActions().addPrivateCredential(subject, credential);
    }

    static void removePrivateCredential(Subject subject, Object credential) {
        SecurityActions.loginModuleActions().removePrivateCredential(subject, credential);
    }

    static Method getCreateSubjectMethod() {
        return SecurityActions.loginModuleActions().getCreateSubjectMethod();
    }

    static Subject invokeCreateSubject(Method createSubjectMethod, GSSName gssName, GSSCredential gssCredential) throws GSSException {
        return SecurityActions.loginModuleActions().invokeCreateSubject(createSubjectMethod, gssName, gssCredential);
    }

    static void copySubjectContents(Subject from, Subject to) {
        SecurityActions.loginModuleActions().copySubjectContents(from, to);
    }

    static void removeSubjectContents(Subject toSubtract, Subject from) {
        SecurityActions.loginModuleActions().removeSubjectContents(toSubtract, from);
    }

    private static LoginModuleActions loginModuleActions() {
        return System.getSecurityManager() != null ? LoginModuleActions.PRIVILEGED : LoginModuleActions.NON_PRIVILEGED;
    }

    private static interface LoginModuleActions {
        public static final LoginModuleActions NON_PRIVILEGED = new LoginModuleActions(){

            @Override
            public Class<LoginModule> loadLoginModuleClass(String className) {
                try {
                    return KerberosLoginModule.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    log.debug((Object)e);
                    return null;
                }
                catch (ClassCastException e) {
                    log.debug((Object)e);
                    return null;
                }
            }

            @Override
            public LoginModule newInstance(Class<LoginModule> moduleClass) {
                try {
                    return moduleClass.newInstance();
                }
                catch (InstantiationException e) {
                    log.debug((Object)e);
                    return null;
                }
                catch (IllegalAccessException e) {
                    log.debug((Object)e);
                    return null;
                }
            }

            @Override
            public void addPrivateCredential(Subject subject, Object credential) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                privateCredentials.add(credential);
            }

            @Override
            public void removePrivateCredential(Subject subject, Object credential) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                privateCredentials.remove(credential);
            }

            @Override
            public Method getCreateSubjectMethod() {
                try {
                    Class<?> sunGssUtil = GSSUtil.class.getClassLoader().loadClass(SecurityActions.SUN_GSSUTIL);
                    return sunGssUtil.getMethod(SecurityActions.CREATE_SUBJECT, GSSName.class, GSSCredential.class);
                }
                catch (ClassNotFoundException e) {
                    log.debug((Object)e);
                    return null;
                }
                catch (NoSuchMethodException e) {
                    log.debug((Object)e);
                    return null;
                }
                catch (SecurityException e) {
                    log.debug((Object)e);
                    return null;
                }
            }

            @Override
            public Subject invokeCreateSubject(Method createSubjectMethod, GSSName gssName, GSSCredential gssCredential) throws GSSException {
                try {
                    return (Subject)createSubjectMethod.invoke(null, gssName, gssCredential);
                }
                catch (IllegalAccessException e) {
                    log.debug((Object)e);
                    return null;
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)e);
                    return null;
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof GSSException) {
                        throw (GSSException)cause;
                    }
                    log.debug((Object)e);
                    return null;
                }
            }

            @Override
            public void copySubjectContents(Subject from, Subject to) {
                to.getPrincipals().addAll(from.getPrincipals());
                to.getPublicCredentials().addAll(from.getPublicCredentials());
                to.getPrivateCredentials().addAll(from.getPrivateCredentials());
            }

            @Override
            public void removeSubjectContents(Subject toSubtract, Subject from) {
                from.getPrincipals().removeAll(toSubtract.getPrincipals());
                from.getPublicCredentials().removeAll(toSubtract.getPublicCredentials());
                from.getPrivateCredentials().removeAll(toSubtract.getPrivateCredentials());
            }
        };
        public static final LoginModuleActions PRIVILEGED = new LoginModuleActions(){
            private PrivilegedAction<Method> GET_CREATE_SUBJECT_METHOD_ACTION = new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    return NON_PRIVILEGED.getCreateSubjectMethod();
                }
            };

            @Override
            public Class<LoginModule> loadLoginModuleClass(final String className) {
                return AccessController.doPrivileged(new PrivilegedAction<Class<LoginModule>>(){

                    @Override
                    public Class<LoginModule> run() {
                        return NON_PRIVILEGED.loadLoginModuleClass(className);
                    }
                });
            }

            @Override
            public LoginModule newInstance(final Class<LoginModule> moduleClass) {
                return AccessController.doPrivileged(new PrivilegedAction<LoginModule>(){

                    @Override
                    public LoginModule run() {
                        return NON_PRIVILEGED.newInstance(moduleClass);
                    }
                });
            }

            @Override
            public void addPrivateCredential(final Subject subject, final Object credential) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.addPrivateCredential(subject, credential);
                        return null;
                    }
                });
            }

            @Override
            public void removePrivateCredential(final Subject subject, final Object credential) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.removePrivateCredential(subject, credential);
                        return null;
                    }
                });
            }

            @Override
            public Method getCreateSubjectMethod() {
                return AccessController.doPrivileged(this.GET_CREATE_SUBJECT_METHOD_ACTION);
            }

            @Override
            public Subject invokeCreateSubject(final Method createSubjectMethod, final GSSName gssName, final GSSCredential gssCredential) throws GSSException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Subject>(){

                        @Override
                        public Subject run() throws Exception {
                            return NON_PRIVILEGED.invokeCreateSubject(createSubjectMethod, gssName, gssCredential);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (GSSException)e.getCause();
                }
            }

            @Override
            public void copySubjectContents(final Subject from, final Subject to) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.copySubjectContents(from, to);
                        return null;
                    }
                });
            }

            @Override
            public void removeSubjectContents(final Subject toSubtract, final Subject from) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        NON_PRIVILEGED.removeSubjectContents(toSubtract, from);
                        return null;
                    }
                });
            }
        };

        public Class<LoginModule> loadLoginModuleClass(String var1);

        public LoginModule newInstance(Class<LoginModule> var1);

        public void addPrivateCredential(Subject var1, Object var2);

        public void removePrivateCredential(Subject var1, Object var2);

        public Method getCreateSubjectMethod();

        public Subject invokeCreateSubject(Method var1, GSSName var2, GSSCredential var3) throws GSSException;

        public void copySubjectContents(Subject var1, Subject var2);

        public void removeSubjectContents(Subject var1, Subject var2);
    }
}

