/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.security.ExternalPasswordCache;
import org.jboss.security.PasswordCache;
import org.jboss.security.PicketBoxLogger;
import org.jboss.security.PicketBoxMessages;

public class Util {
    private static PasswordCache externalPasswordCache;

    public static char[] loadPassword(String passwordCmd) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission(Util.class.getName() + ".loadPassword"));
        }
        char[] password = null;
        String passwordCmdType = null;
        if (passwordCmd.charAt(0) == '{') {
            StringTokenizer tokenizer = new StringTokenizer(passwordCmd, "{}");
            passwordCmdType = tokenizer.nextToken();
            passwordCmd = tokenizer.nextToken();
        } else {
            password = passwordCmd.toCharArray();
        }
        if (password == null) {
            if (passwordCmdType.startsWith("EXTC") || passwordCmdType.startsWith("CMDC")) {
                long timeOut = 0L;
                if (passwordCmdType.indexOf(58) > -1) {
                    try {
                        String[] token = passwordCmdType.split(":");
                        timeOut = Long.parseLong(token[1]);
                    }
                    catch (Throwable e) {
                        PicketBoxLogger.LOGGER.errorParsingTimeoutNumber();
                    }
                }
                if (externalPasswordCache == null) {
                    externalPasswordCache = ExternalPasswordCache.getExternalPasswordCacheInstance();
                }
                if (externalPasswordCache.contains(passwordCmd, timeOut)) {
                    password = externalPasswordCache.getPassword(passwordCmd);
                } else {
                    password = Util.switchCommandExecution(passwordCmdType, passwordCmd);
                    if (password != null) {
                        externalPasswordCache.storePassword(passwordCmd, password);
                    }
                }
            } else if (passwordCmdType.startsWith("EXT") || passwordCmdType.startsWith("CMD")) {
                password = Util.switchCommandExecution(passwordCmdType, passwordCmd);
            } else if (passwordCmdType.startsWith("CLASS")) {
                String module = null;
                if (passwordCmdType.indexOf(64) > -1) {
                    module = passwordCmdType.split("@")[1];
                }
                password = Util.invokePasswordClass(passwordCmd, module);
            } else {
                throw PicketBoxMessages.MESSAGES.invalidPasswordCommandType(passwordCmdType);
            }
        }
        return password;
    }

    private static char[] switchCommandExecution(String passwordCmdType, String passwordCmd) throws Exception {
        if (passwordCmdType.startsWith("EXT")) {
            return Util.execPasswordCmd(passwordCmd);
        }
        if (passwordCmdType.startsWith("CMD")) {
            return Util.execPBBasedPasswordCommand(passwordCmd);
        }
        throw PicketBoxMessages.MESSAGES.invalidPasswordCommandType(passwordCmdType);
    }

    private static char[] execPasswordCmd(String passwordCmd) throws Exception {
        PicketBoxLogger.LOGGER.traceBeginExecPasswordCmd(passwordCmd);
        String password = Util.execCmd(passwordCmd);
        return password.toCharArray();
    }

    private static char[] invokePasswordClass(String passwordCmd, String moduleSpec) throws Exception {
        char[] password;
        block6: {
            password = null;
            String classname = passwordCmd;
            String ctorArgs = null;
            int colon = passwordCmd.indexOf(58);
            if (colon > 0) {
                classname = passwordCmd.substring(0, colon);
                ctorArgs = passwordCmd.substring(colon + 1);
            }
            Class<?> c = Util.loadClass(classname, moduleSpec);
            Object instance = null;
            if (ctorArgs != null) {
                Object[] args = ctorArgs.split(",");
                Class[] sig = new Class[args.length];
                ArrayList<Class<String>> sigl = new ArrayList<Class<String>>();
                for (int n = 0; n < args.length; ++n) {
                    sigl.add(String.class);
                }
                sigl.toArray(sig);
                Constructor<?> ctor = c.getConstructor(sig);
                instance = ctor.newInstance(args);
            } else {
                instance = c.newInstance();
            }
            try {
                Class[] sig = new Class[]{};
                Method toCharArray = c.getMethod("toCharArray", sig);
                Object[] args = new Object[]{};
                password = (char[])toCharArray.invoke(instance, args);
            }
            catch (NoSuchMethodException e) {
                String tmp = instance.toString();
                if (tmp == null) break block6;
                password = tmp.toCharArray();
            }
        }
        return password;
    }

    private static Class<?> loadClass(final String fqn, final String module) {
        try {
            Class passwdClass = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    if (fqn == null || fqn.isEmpty()) {
                        throw PicketBoxMessages.MESSAGES.loadingNullorEmptyClass();
                    }
                    if (module == null) {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        return cl.loadClass(fqn);
                    }
                    ModuleLoader loader = Module.getCallerModuleLoader();
                    Module pwdClassModule = loader.loadModule(ModuleIdentifier.fromString((String)module));
                    return pwdClassModule.getClassLoader().loadClass(fqn);
                }
            });
            return passwdClass;
        }
        catch (PrivilegedActionException e) {
            throw PicketBoxMessages.MESSAGES.unableToLoadPasswordClass(e.getCause(), fqn);
        }
    }

    private static String execCmd(String cmd) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        String line = sm != null ? RuntimeActions.PRIVILEGED.execCmd(cmd) : RuntimeActions.NON_PRIVILEGED.execCmd(cmd);
        return line;
    }

    private static char[] execPBBasedPasswordCommand(String passwordCmd) throws Exception {
        PicketBoxLogger.LOGGER.traceBeginExecPasswordCmd(passwordCmd);
        SecurityManager sm = System.getSecurityManager();
        String password = sm != null ? RuntimeActions.PB_BASED_PRIVILEGED.execCmd(passwordCmd) : RuntimeActions.PB_BASED_NON_PRIVILEGED.execCmd(passwordCmd);
        return password.toCharArray();
    }

    public static boolean isPasswordCommand(String passwordCmd) {
        return passwordCmd != null && (passwordCmd.startsWith("{EXT}") || passwordCmd.startsWith("{EXTC") || passwordCmd.startsWith("{CMD}") || passwordCmd.startsWith("{CMDC") || passwordCmd.startsWith("{CLASS"));
    }

    public static boolean isPasswordCommand(char[] passwordCmd) {
        return passwordCmd != null && Util.isPasswordCommand(new String(passwordCmd));
    }

    static interface RuntimeActions {
        public static final RuntimeActions PRIVILEGED = new RuntimeActions(){

            @Override
            public String execCmd(final String cmd) throws Exception {
                try {
                    String line = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            return NON_PRIVILEGED.execCmd(cmd);
                        }
                    });
                    return line;
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        };
        public static final RuntimeActions NON_PRIVILEGED = new RuntimeActions(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String execCmd(String cmd) throws Exception {
                String line;
                Runtime rt = Runtime.getRuntime();
                Process p = rt.exec(cmd);
                InputStream stdin = null;
                BufferedReader reader = null;
                try {
                    stdin = p.getInputStream();
                    reader = new BufferedReader(new InputStreamReader(stdin));
                    line = reader.readLine();
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                    if (stdin != null) {
                        stdin.close();
                    }
                }
                int exitCode = p.waitFor();
                PicketBoxLogger.LOGGER.traceEndExecPasswordCmd(exitCode);
                return line;
            }
        };
        public static final RuntimeActions PB_BASED_PRIVILEGED = new RuntimeActions(){

            @Override
            public String execCmd(final String command) throws Exception {
                try {
                    String password = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                        @Override
                        public String run() throws Exception {
                            return PB_BASED_NON_PRIVILEGED.execCmd(command);
                        }
                    });
                    return password;
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
            }
        };
        public static final RuntimeActions PB_BASED_NON_PRIVILEGED = new RuntimeActions(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String execCmd(String command) throws Exception {
                String line;
                String[] parsedCommand = this.parseCommand(command);
                ProcessBuilder builder = new ProcessBuilder(parsedCommand);
                Process process = builder.start();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    line = reader.readLine();
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                int exitCode = process.waitFor();
                PicketBoxLogger.LOGGER.traceEndExecPasswordCmd(exitCode);
                return line;
            }

            protected String[] parseCommand(String command) {
                String[] parsedCommand = command.split("(?<!\\\\),");
                for (int k = 0; k < parsedCommand.length; ++k) {
                    if (parsedCommand[k].indexOf(92) == -1) continue;
                    parsedCommand[k] = parsedCommand[k].replaceAll("\\\\,", ",");
                }
                return parsedCommand;
            }
        };

        public String execCmd(String var1) throws Exception;
    }
}

