/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.CommonGramsFilter;
import org.apache.solr.analysis.CommonGramsQueryFilter;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class CommonGramsQueryFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet commonWords;
    private boolean ignoreCase;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.assureMatchVersion();
    }

    @Override
    public void inform(ResourceLoader loader) {
        String commonWordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        if (commonWordFiles != null) {
            try {
                if ("snowball".equalsIgnoreCase((String)this.args.get("format"))) {
                    this.commonWords = this.getSnowballWordSet(loader, commonWordFiles, this.ignoreCase);
                }
                this.commonWords = this.getWordSet(loader, commonWordFiles, this.ignoreCase);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commonWords = (CharArraySet)StopAnalyzer.ENGLISH_STOP_WORDS_SET;
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Set<?> getCommonWords() {
        return this.commonWords;
    }

    public CommonGramsQueryFilter create(TokenStream input) {
        CommonGramsFilter commonGrams = new CommonGramsFilter(this.luceneMatchVersion, input, (Set<?>)this.commonWords, this.ignoreCase);
        CommonGramsQueryFilter commonGramsQuery = new CommonGramsQueryFilter(commonGrams);
        return commonGramsQuery;
    }
}

