/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.ElisionFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class ElisionFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet articles;

    @Override
    public void inform(ResourceLoader loader) {
        String articlesFile = (String)this.args.get("articles");
        boolean ignoreCase = this.getBoolean("ignoreCase", false);
        if (articlesFile != null) {
            try {
                this.articles = this.getWordSet(loader, articlesFile, ignoreCase);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ElisionFilter create(TokenStream input) {
        this.assureMatchVersion();
        return this.articles == null ? new ElisionFilter(this.luceneMatchVersion, input) : new ElisionFilter(this.luceneMatchVersion, input, (Set)this.articles);
    }
}

