/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.SolrException;

public class JapaneseKatakanaStemFilterFactory
extends BaseTokenFilterFactory {
    private static final String MINIMUM_LENGTH_PARAM = "minimumLength";
    private int minimumLength;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.minimumLength = this.getInt(MINIMUM_LENGTH_PARAM, 4);
        if (this.minimumLength < 2) {
            throw new SolrException(SolrException.ErrorCode.UNKNOWN, "Illegal minimumLength " + this.minimumLength + " (must be 2 or greater)");
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new JapaneseKatakanaStemFilter(input, this.minimumLength);
    }
}

