/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.analysis.KeepWordFilter;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class KeepWordFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet words;
    private boolean ignoreCase;
    private boolean enablePositionIncrements;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.assureMatchVersion();
    }

    @Override
    public void inform(ResourceLoader loader) {
        String wordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        if (wordFiles != null) {
            try {
                this.words = this.getWordSet(loader, wordFiles, this.ignoreCase);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setWords(Set<String> words) {
        this.words = new CharArraySet(this.luceneMatchVersion, words, this.ignoreCase);
    }

    public void setIgnoreCase(boolean ignoreCase) {
        if (this.words != null && this.ignoreCase != ignoreCase) {
            this.words = new CharArraySet(this.luceneMatchVersion, (Collection)this.words, ignoreCase);
        }
        this.ignoreCase = ignoreCase;
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getWords() {
        return this.words;
    }

    public KeepWordFilter create(TokenStream input) {
        return new KeepWordFilter(this.enablePositionIncrements, input, this.words);
    }
}

