/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.Encoder;
import org.apache.commons.codec.language.Caverphone;
import org.apache.commons.codec.language.ColognePhonetic;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.phonetic.PhoneticFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.SolrException;

public class PhoneticFilterFactory
extends BaseTokenFilterFactory {
    public static final String ENCODER = "encoder";
    public static final String INJECT = "inject";
    private static final String PACKAGE_CONTAINING_ENCODERS = "org.apache.commons.codec.language.";
    private static final Map<String, Class<? extends Encoder>> registry = new HashMap<String, Class<? extends Encoder>>(){
        {
            this.put("DoubleMetaphone".toUpperCase(Locale.ENGLISH), DoubleMetaphone.class);
            this.put("Metaphone".toUpperCase(Locale.ENGLISH), Metaphone.class);
            this.put("Soundex".toUpperCase(Locale.ENGLISH), Soundex.class);
            this.put("RefinedSoundex".toUpperCase(Locale.ENGLISH), RefinedSoundex.class);
            this.put("Caverphone".toUpperCase(Locale.ENGLISH), Caverphone.class);
            this.put("ColognePhonetic".toUpperCase(Locale.ENGLISH), ColognePhonetic.class);
        }
    };
    private static final Lock lock = new ReentrantLock();
    protected boolean inject = true;
    protected String name = null;
    protected Encoder encoder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.inject = this.getBoolean(INJECT, true);
        String name = args.get(ENCODER);
        if (name == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter: encoder [" + registry.keySet() + "]");
        }
        Class<? extends Encoder> clazz = registry.get(name.toUpperCase(Locale.ENGLISH));
        if (clazz == null) {
            lock.lock();
            try {
                clazz = this.resolveEncoder(name);
            }
            finally {
                lock.unlock();
            }
        }
        try {
            this.encoder = clazz.newInstance();
            String v = args.get("maxCodeLength");
            if (v != null) {
                Method setter = this.encoder.getClass().getMethod("setMaxCodeLen", Integer.TYPE);
                setter.invoke((Object)this.encoder, Integer.parseInt(v));
            }
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error initializing: " + name + "/" + clazz, (Throwable)e, false);
        }
    }

    private Class<? extends Encoder> resolveEncoder(String name) {
        Class<? extends Encoder> clazz = null;
        try {
            clazz = this.lookupEncoder(PACKAGE_CONTAINING_ENCODERS + name);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = this.lookupEncoder(name);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown encoder: " + name + " [" + registry.keySet() + "]");
            }
        }
        catch (ClassCastException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Not an encoder: " + name + " [" + registry.keySet() + "]");
        }
        return clazz;
    }

    private Class<? extends Encoder> lookupEncoder(String name) throws ClassNotFoundException {
        Class<Encoder> clazz = Class.forName(name).asSubclass(Encoder.class);
        registry.put(name.toUpperCase(Locale.ENGLISH), clazz);
        return clazz;
    }

    public TokenFilter create(TokenStream input) {
        return new PhoneticFilter(input, this.encoder, this.inject);
    }
}

