/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class StopFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet stopWords;
    private boolean ignoreCase;
    private boolean enablePositionIncrements;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.assureMatchVersion();
    }

    @Override
    public void inform(ResourceLoader loader) {
        String stopWordFiles = (String)this.args.get("words");
        this.ignoreCase = this.getBoolean("ignoreCase", false);
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        if (stopWordFiles != null) {
            try {
                if ("snowball".equalsIgnoreCase((String)this.args.get("format"))) {
                    this.stopWords = this.getSnowballWordSet(loader, stopWordFiles, this.ignoreCase);
                }
                this.stopWords = this.getWordSet(loader, stopWordFiles, this.ignoreCase);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.stopWords = new CharArraySet(this.luceneMatchVersion, (Collection)StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase);
        }
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Set<?> getStopWords() {
        return this.stopWords;
    }

    public StopFilter create(TokenStream input) {
        StopFilter stopFilter = new StopFilter(this.luceneMatchVersion, input, (Set)this.stopWords, this.ignoreCase);
        stopFilter.setEnablePositionIncrements(this.enablePositionIncrements);
        return stopFilter;
    }
}

