/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TypeTokenFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.util.plugin.ResourceLoaderAware;

public class TypeTokenFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private boolean useWhitelist;
    private Set<String> stopTypes;
    private boolean enablePositionIncrements;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void inform(ResourceLoader loader) {
        String stopTypesFiles = (String)this.args.get("types");
        this.enablePositionIncrements = this.getBoolean("enablePositionIncrements", false);
        this.useWhitelist = this.getBoolean("useWhitelist", false);
        if (stopTypesFiles == null) throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter: types.");
        try {
            List files = StrUtils.splitFileNames((String)stopTypesFiles);
            if (files.size() <= 0) return;
            this.stopTypes = new HashSet<String>();
            for (String file : files) {
                List typesLines = loader.getLines(file.trim());
                this.stopTypes.addAll(typesLines);
            }
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public Set<String> getStopTypes() {
        return this.stopTypes;
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new TypeTokenFilter(this.enablePositionIncrements, input, this.stopTypes, this.useWhitelist);
    }
}

