/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.util.Version;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.SystemIdResolver;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Config {
    public static final Logger log = LoggerFactory.getLogger(Config.class);
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    static final XPathFactory xpathFactory = XPathFactory.newInstance();
    private final Document doc;
    private final String prefix;
    private final String name;
    private final SolrResourceLoader loader;
    private static final AtomicBoolean versionWarningAlreadyLogged = new AtomicBoolean(false);

    @Deprecated
    public Config(String name, InputStream is, String prefix) throws ParserConfigurationException, IOException, SAXException {
        this(null, name, new InputSource(is), prefix);
    }

    public Config(SolrResourceLoader loader, String name) throws ParserConfigurationException, IOException, SAXException {
        this(loader, name, (InputSource)null, null);
    }

    @Deprecated
    public Config(SolrResourceLoader loader, String name, InputStream is, String prefix) throws ParserConfigurationException, IOException, SAXException {
        this(loader, name, is == null ? null : new InputSource(is), prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config(SolrResourceLoader loader, String name, InputSource is, String prefix) throws ParserConfigurationException, IOException, SAXException {
        if (loader == null) {
            loader = new SolrResourceLoader(null);
        }
        this.loader = loader;
        this.name = name;
        this.prefix = prefix != null && !prefix.endsWith("/") ? prefix + '/' : prefix;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            if (is == null) {
                is = new InputSource(loader.openConfig(name));
                is.setSystemId(SystemIdResolver.createSystemIdFromResourceName((String)name));
            }
            if (is.getSystemId() != null) {
                try {
                    dbf.setXIncludeAware(true);
                    dbf.setNamespaceAware(true);
                }
                catch (UnsupportedOperationException e) {
                    log.warn(name + " XML parser doesn't support XInclude option");
                }
            }
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver((EntityResolver)new SystemIdResolver((ResourceLoader)loader));
            db.setErrorHandler((ErrorHandler)xmllog);
            try {
                this.doc = db.parse(is);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is.getByteStream());
            }
            DOMUtil.substituteProperties((Node)this.doc, (Properties)loader.getCoreProperties());
        }
        catch (ParserConfigurationException e) {
            SolrException.log((Logger)log, (String)("Exception during parsing file: " + name), (Throwable)e);
            throw e;
        }
        catch (SAXException e) {
            SolrException.log((Logger)log, (String)("Exception during parsing file: " + name), (Throwable)e);
            throw e;
        }
        catch (SolrException e) {
            SolrException.log((Logger)log, (String)("Error in " + name), (Throwable)e);
            throw e;
        }
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public String getResourceName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Document getDocument() {
        return this.doc;
    }

    public XPath getXPath() {
        return xpathFactory.newXPath();
    }

    private String normalize(String path) {
        return this.prefix == null || path.startsWith("/") ? path : this.prefix + path;
    }

    public Object evaluate(String path, QName type) {
        XPath xpath = xpathFactory.newXPath();
        try {
            String xstr = this.normalize(path);
            Object o = xpath.evaluate(xstr, this.doc, type);
            return o;
        }
        catch (XPathExpressionException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + path + " for " + this.name, (Throwable)e, false);
        }
    }

    public Node getNode(String path, boolean errIfMissing) {
        XPath xpath = xpathFactory.newXPath();
        Node nd = null;
        String xstr = this.normalize(path);
        try {
            nd = (Node)xpath.evaluate(xstr, this.doc, XPathConstants.NODE);
            if (nd == null) {
                if (errIfMissing) {
                    throw new RuntimeException(this.name + " missing " + path);
                }
                log.debug(this.name + " missing optional " + path);
                return null;
            }
            log.trace(this.name + ":" + path + "=" + nd);
            return nd;
        }
        catch (XPathExpressionException e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, (Throwable)e, false);
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, (String)"Error in xpath", (Throwable)e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error in xpath:" + xstr + " for " + this.name, e, false);
        }
    }

    public String getVal(String path, boolean errIfMissing) {
        Node nd = this.getNode(path, errIfMissing);
        if (nd == null) {
            return null;
        }
        String txt = DOMUtil.getText((Node)nd);
        log.debug(this.name + ' ' + path + '=' + txt);
        return txt;
    }

    public String get(String path) {
        return this.getVal(path, true);
    }

    public String get(String path, String def) {
        String val = this.getVal(path, false);
        return val != null ? val : def;
    }

    public int getInt(String path) {
        return Integer.parseInt(this.getVal(path, true));
    }

    public int getInt(String path, int def) {
        String val = this.getVal(path, false);
        return val != null ? Integer.parseInt(val) : def;
    }

    public boolean getBool(String path) {
        return Boolean.parseBoolean(this.getVal(path, true));
    }

    public boolean getBool(String path, boolean def) {
        String val = this.getVal(path, false);
        return val != null ? Boolean.parseBoolean(val) : def;
    }

    public float getFloat(String path) {
        return Float.parseFloat(this.getVal(path, true));
    }

    public float getFloat(String path, float def) {
        String val = this.getVal(path, false);
        return val != null ? Float.parseFloat(val) : def;
    }

    public double getDouble(String path) {
        return Double.parseDouble(this.getVal(path, true));
    }

    public double getDouble(String path, double def) {
        String val = this.getVal(path, false);
        return val != null ? Double.parseDouble(val) : def;
    }

    public Version getLuceneVersion(String path) {
        return Config.parseLuceneVersionString(this.getVal(path, true));
    }

    public Version getLuceneVersion(String path, Version def) {
        String val = this.getVal(path, false);
        if (val == null) {
            if (!versionWarningAlreadyLogged.getAndSet(true)) {
                log.warn("the luceneMatchVersion is not specified, defaulting to " + def + " emulation. You should at some point declare and reindex to at least 3.0, " + "because 2.4 emulation is deprecated and will be removed in 4.0. " + "This parameter will be mandatory in 4.0.");
            }
            return def;
        }
        return Config.parseLuceneVersionString(val);
    }

    public static final Version parseLuceneVersionString(String matchVersion) {
        Version version;
        String parsedMatchVersion = matchVersion.toUpperCase(Locale.ENGLISH);
        parsedMatchVersion = parsedMatchVersion.replaceFirst("^(\\d)\\.(\\d)$", "LUCENE_$1$2");
        try {
            version = Version.valueOf((String)parsedMatchVersion);
        }
        catch (IllegalArgumentException iae) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid luceneMatchVersion '" + matchVersion + "', valid values are: " + Arrays.toString(Version.values()) + " or a string in format 'V.V'", (Throwable)iae, false);
        }
        if (version == Version.LUCENE_CURRENT && !versionWarningAlreadyLogged.getAndSet(true)) {
            log.warn("You should not use LUCENE_CURRENT as luceneMatchVersion property: if you use this setting, and then Solr upgrades to a newer release of Lucene, sizable changes may happen. If precise back compatibility is important then you should instead explicitly specify an actual Lucene version.");
        }
        return version;
    }

    @Deprecated
    public String getConfigDir() {
        return this.loader.getConfigDir();
    }

    @Deprecated
    public InputStream openResource(String resource) {
        return this.loader.openResource(resource);
    }

    @Deprecated
    public List<String> getLines(String resource) throws IOException {
        return this.loader.getLines(resource);
    }

    @Deprecated
    public Class findClass(String cname, String ... subpackages) {
        return this.loader.findClass(cname, subpackages);
    }

    @Deprecated
    public Object newInstance(String cname, String ... subpackages) {
        return this.loader.newInstance(cname, subpackages);
    }

    @Deprecated
    public String getInstanceDir() {
        return this.loader.getInstanceDir();
    }
}

