/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.noggit.JSONParser;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JsonLoader
extends ContentStreamLoader {
    static final Logger log = LoggerFactory.getLogger(JsonLoader.class);
    protected final UpdateRequestProcessor processor;
    protected final SolrQueryRequest req;
    protected JSONParser parser;
    protected final int commitWithin;
    protected final boolean overwrite;

    public JsonLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        this.processor = processor;
        this.req = req;
        this.commitWithin = req.getParams().getInt("commitWithin", -1);
        this.overwrite = req.getParams().getBool("overwrite", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream) throws Exception {
        this.errHeader = "JSONLoader: " + stream.getSourceInfo();
        Reader reader = null;
        try {
            reader = stream.getReader();
            if (log.isTraceEnabled()) {
                String body = IOUtils.toString((Reader)reader);
                log.trace("body", (Object)body);
                reader = new StringReader(body);
            }
            this.parser = new JSONParser(reader);
            this.processUpdate();
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    void processUpdate() throws IOException {
        int ev = this.parser.nextEvent();
        while (ev != 11) {
            switch (ev) {
                case 9: {
                    this.handleAdds();
                    break;
                }
                case 1: {
                    if (this.parser.wasKey()) {
                        String v = this.parser.getString();
                        if (v.equals("add")) {
                            int ev2 = this.parser.nextEvent();
                            if (ev2 == 7) {
                                this.processor.processAdd(this.parseAdd());
                                break;
                            }
                            if (ev2 == 9) {
                                this.handleAdds();
                                break;
                            }
                            this.assertEvent(ev2, 7);
                            break;
                        }
                        if (v.equals("commit")) {
                            CommitUpdateCommand cmd = new CommitUpdateCommand(false);
                            cmd.waitSearcher = true;
                            cmd.waitFlush = true;
                            this.parseCommitOptions(cmd);
                            this.processor.processCommit(cmd);
                            break;
                        }
                        if (v.equals("optimize")) {
                            CommitUpdateCommand cmd = new CommitUpdateCommand(true);
                            cmd.waitSearcher = true;
                            cmd.waitFlush = true;
                            this.parseCommitOptions(cmd);
                            this.processor.processCommit(cmd);
                            break;
                        }
                        if (v.equals("delete")) {
                            this.processor.processDelete(this.parseDelete());
                            break;
                        }
                        if (v.equals("rollback")) {
                            this.processor.processRollback(this.parseRollback());
                            break;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown command: " + v + " [" + this.parser.getPosition() + "]");
                    }
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    log.info("can't have a value here! " + JSONParser.getEventString((int)ev) + " " + this.parser.getPosition());
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    log.info("Noggit UNKNOWN_EVENT_ID:" + ev);
                }
            }
            ev = this.parser.nextEvent();
        }
    }

    DeleteUpdateCommand parseDelete() throws IOException {
        int ev;
        this.assertNextEvent(7);
        DeleteUpdateCommand cmd = new DeleteUpdateCommand();
        cmd.fromPending = true;
        cmd.fromCommitted = true;
        cmd.commitWithin = this.commitWithin;
        while ((ev = this.parser.nextEvent()) == 1) {
            String key = this.parser.getString();
            if (this.parser.wasKey()) {
                if ("id".equals(key)) {
                    cmd.id = this.parser.getString();
                    continue;
                }
                if ("query".equals(key)) {
                    cmd.query = this.parser.getString();
                    continue;
                }
                if ("commitWithin".equals(key)) {
                    cmd.commitWithin = Integer.parseInt(this.parser.getString());
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown key: " + key + " [" + this.parser.getPosition() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid string: " + key + " at [" + this.parser.getPosition() + "]");
        }
        if (ev == 8) {
            if (cmd.id == null && cmd.query == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing id or query for delete [" + this.parser.getPosition() + "]");
            }
            return cmd;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Got: " + JSONParser.getEventString((int)ev) + " at [" + this.parser.getPosition() + "]");
    }

    RollbackUpdateCommand parseRollback() throws IOException {
        this.assertNextEvent(7);
        this.assertNextEvent(8);
        return new RollbackUpdateCommand();
    }

    void parseCommitOptions(CommitUpdateCommand cmd) throws IOException {
        int ev;
        this.assertNextEvent(7);
        while ((ev = this.parser.nextEvent()) == 1) {
            String key = this.parser.getString();
            if (this.parser.wasKey()) {
                if ("waitSearcher".equals(key)) {
                    cmd.waitSearcher = this.parser.getBoolean();
                    continue;
                }
                if ("waitFlush".equals(key)) {
                    cmd.waitFlush = this.parser.getBoolean();
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown key: " + key + " [" + this.parser.getPosition() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid string: " + key + " at [" + this.parser.getPosition() + "]");
        }
        if (ev == 8) {
            return;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Got: " + JSONParser.getEventString((int)ev) + " at [" + this.parser.getPosition() + "]");
    }

    AddUpdateCommand parseAdd() throws IOException {
        int ev;
        AddUpdateCommand cmd = new AddUpdateCommand();
        cmd.commitWithin = this.commitWithin;
        cmd.overwriteCommitted = cmd.overwritePending = this.overwrite;
        cmd.allowDups = !this.overwrite;
        float boost = 1.0f;
        while ((ev = this.parser.nextEvent()) == 1) {
            if (this.parser.wasKey()) {
                String key = this.parser.getString();
                if ("doc".equals(key)) {
                    if (cmd.solrDoc != null) {
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "multiple docs in same add command");
                    }
                    ev = this.assertNextEvent(7);
                    cmd.solrDoc = this.parseDoc(ev);
                    continue;
                }
                if ("overwrite".equals(key)) {
                    cmd.allowDups = !this.parser.getBoolean();
                    cmd.overwritePending = !cmd.allowDups;
                    cmd.overwriteCommitted = cmd.overwritePending;
                    continue;
                }
                if ("commitWithin".equals(key)) {
                    cmd.commitWithin = (int)this.parser.getLong();
                    continue;
                }
                if ("boost".equals(key)) {
                    boost = Float.parseFloat(this.parser.getNumberChars().toString());
                    continue;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown key: " + key + " [" + this.parser.getPosition() + "]");
            }
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Should be a key  at [" + this.parser.getPosition() + "]");
        }
        if (ev == 8) {
            if (cmd.solrDoc == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing solr document. " + this.parser.getPosition());
            }
            cmd.solrDoc.setDocumentBoost(boost);
            return cmd;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Got: " + JSONParser.getEventString((int)ev) + " at [" + this.parser.getPosition() + "]");
    }

    void handleAdds() throws IOException {
        while (true) {
            AddUpdateCommand cmd = new AddUpdateCommand();
            cmd.commitWithin = this.commitWithin;
            cmd.overwriteCommitted = cmd.overwritePending = this.overwrite;
            cmd.allowDups = !this.overwrite;
            int ev = this.parser.nextEvent();
            if (ev == 10) break;
            this.assertEvent(ev, 7);
            cmd.solrDoc = this.parseDoc(ev);
            this.processor.processAdd(cmd);
        }
    }

    int assertNextEvent(int expected) throws IOException {
        int got = this.parser.nextEvent();
        this.assertEvent(got, expected);
        return got;
    }

    void assertEvent(int ev, int expected) {
        if (ev != expected) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Expected: " + JSONParser.getEventString((int)expected) + " but got " + JSONParser.getEventString((int)ev) + " at [" + this.parser.getPosition() + "]");
        }
    }

    SolrInputDocument parseDoc(int ev) throws IOException {
        Stack<Object> stack = new Stack<Object>();
        Object obj = null;
        boolean inArray = false;
        if (ev != 7) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "object should already be started");
        }
        block10: do {
            switch (ev) {
                case 1: {
                    if (this.parser.wasKey()) {
                        obj = stack.peek();
                        String v = this.parser.getString();
                        if (obj instanceof SolrInputField) {
                            SolrInputField field = obj;
                            if ("boost".equals(v)) {
                                ev = this.parser.nextEvent();
                                if (ev != 3 && ev != 2 && ev != 4) {
                                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "boost should have number! " + JSONParser.getEventString((int)ev));
                                }
                                field.setBoost((float)this.parser.getDouble());
                                break;
                            }
                            if ("value".equals(v)) {
                                stack.push(field);
                                break;
                            }
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid key: " + v + " [" + this.parser.getPosition() + "]");
                        }
                        if (obj instanceof SolrInputDocument) {
                            SolrInputDocument doc = obj;
                            SolrInputField f = doc.get((Object)v);
                            if (f == null) {
                                f = new SolrInputField(v);
                                doc.put(f.getName(), f);
                            }
                            stack.push(f);
                            break;
                        }
                        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hymmm [" + this.parser.getPosition() + "]");
                    }
                    JsonLoader.addValToField(stack, this.parser.getString(), inArray, this.parser);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    JsonLoader.addValToField(stack, this.parser.getNumberChars().toString(), inArray, this.parser);
                    break;
                }
                case 5: {
                    JsonLoader.addValToField(stack, this.parser.getBoolean(), inArray, this.parser);
                    break;
                }
                case 6: {
                    this.parser.getNull();
                    JsonLoader.addValToField(stack, null, inArray, this.parser);
                    break;
                }
                case 7: {
                    if (stack.isEmpty()) {
                        stack.push(new SolrInputDocument());
                        break;
                    }
                    obj = stack.peek();
                    if (obj instanceof SolrInputField) continue block10;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "should not start new object with: " + obj + " [" + this.parser.getPosition() + "]");
                }
                case 8: {
                    obj = stack.pop();
                    if (obj instanceof SolrInputDocument) {
                        return obj;
                    }
                    if (obj instanceof SolrInputField) continue block10;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "should not start new object with: " + obj + " [" + this.parser.getPosition() + "]");
                }
                case 9: {
                    inArray = true;
                    break;
                }
                case 10: {
                    inArray = false;
                    stack.pop();
                    break;
                }
                default: {
                    System.out.println("UNKNOWN_EVENT_ID:" + ev);
                }
            }
        } while ((ev = this.parser.nextEvent()) != 11);
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "should finish doc first!");
    }

    static void addValToField(Stack stack, Object val, boolean inArray, JSONParser parser) throws IOException {
        SolrInputField f;
        Object obj = stack.peek();
        if (!(obj instanceof SolrInputField)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hymmm [" + parser.getPosition() + "]");
        }
        SolrInputField solrInputField = f = inArray ? (SolrInputField)obj : (SolrInputField)stack.pop();
        if (val == null) {
            return;
        }
        float boost = f.getValue() == null ? f.getBoost() : 1.0f;
        f.addValue(val, boost);
    }
}

