/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.ContentStreamLoader;
import org.apache.solr.handler.XsltXMLLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.EmptyEntityResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltUpdateRequestHandler
extends ContentStreamHandlerBase {
    public static Logger log = LoggerFactory.getLogger(XsltUpdateRequestHandler.class);
    public static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    public static final String UPDATE_PROCESSOR = "update.processor";
    public static final int XSLT_CACHE_DEFAULT = 60;
    private static final String XSLT_CACHE_PARAM = "xsltCacheLifetimeSeconds";
    XMLInputFactory inputFactory;
    SAXParserFactory saxFactory;
    private Integer xsltCacheLifetimeSeconds;

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.inputFactory = XMLInputFactory.newInstance();
        this.inputFactory.setXMLReporter((XMLReporter)xmllog);
        EmptyEntityResolver.configureXMLInputFactory(this.inputFactory);
        try {
            this.inputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException ex) {
            log.debug("Unable to set the 'reuse-instance' property for the input chain: " + this.inputFactory);
        }
        this.saxFactory = SAXParserFactory.newInstance();
        this.saxFactory.setNamespaceAware(true);
        EmptyEntityResolver.configureSAXParserFactory(this.saxFactory);
        SolrParams p = SolrParams.toSolrParams((NamedList)args);
        this.xsltCacheLifetimeSeconds = p.getInt(XSLT_CACHE_PARAM, 60);
        log.info("xsltCacheLifetimeSeconds=" + this.xsltCacheLifetimeSeconds);
    }

    @Override
    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return new XsltXMLLoader(processor, this.inputFactory, this.saxFactory, this.xsltCacheLifetimeSeconds);
    }

    @Override
    public String getDescription() {
        return "Add documents with XML, transforming with XSLT first";
    }

    @Override
    public String getVersion() {
        return "$Revision$";
    }

    @Override
    public String getSourceId() {
        return "$Id$";
    }

    @Override
    public String getSource() {
        return "$URL$";
    }
}

