/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.handler.XMLLoader;
import org.apache.solr.handler.XsltUpdateRequestHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.EmptyEntityResolver;
import org.apache.solr.util.xslt.TransformerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

class XsltXMLLoader
extends XMLLoader {
    public static Logger log = LoggerFactory.getLogger(XsltXMLLoader.class);
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    public static final String TRANSFORM_PARAM = "tr";
    public static final String CONTEXT_TRANSFORMER_KEY = "xsltupdater.transformer";
    private final SAXParserFactory saxFactory;
    private final Integer xsltCacheLifetimeSeconds;

    public XsltXMLLoader(UpdateRequestProcessor processor, XMLInputFactory inputFactory, SAXParserFactory saxFactory, Integer xsltCacheLifetimeSeconds) {
        super(processor, inputFactory);
        this.saxFactory = saxFactory;
        this.xsltCacheLifetimeSeconds = xsltCacheLifetimeSeconds;
    }

    @Override
    public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream) throws Exception {
        DOMResult result = new DOMResult();
        Transformer t = this.getTransformer(req);
        InputStream is = null;
        XMLStreamReader parser = null;
        try {
            is = stream.getStream();
            String charset = ContentStreamBase.getCharsetFromContentType((String)stream.getContentType());
            InputSource isrc = new InputSource(is);
            isrc.setEncoding(charset);
            XMLReader xmlr = this.saxFactory.newSAXParser().getXMLReader();
            xmlr.setErrorHandler((ErrorHandler)xmllog);
            xmlr.setEntityResolver(EmptyEntityResolver.SAX_INSTANCE);
            SAXSource source = new SAXSource(xmlr, isrc);
            t.transform(source, result);
        }
        catch (TransformerException te) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, te.getMessage(), (Throwable)te);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            parser = this.inputFactory.createXMLStreamReader(new DOMSource(result.getNode()));
            this.processUpdate(this.processor, parser);
        }
        catch (XMLStreamException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, e.getMessage(), (Throwable)e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    protected Transformer getTransformer(SolrQueryRequest request) throws IOException {
        String xslt = request.getParams().get(TRANSFORM_PARAM, null);
        if (xslt == null) {
            throw new IOException("'tr' request parameter is required to use the XSLTResponseWriter");
        }
        SolrConfig solrConfig = request.getCore().getSolrConfig();
        Map<Object, Object> ctx = request.getContext();
        Transformer result = (Transformer)ctx.get(CONTEXT_TRANSFORMER_KEY);
        if (result == null) {
            result = TransformerProvider.instance.getTransformer(solrConfig, xslt, this.xsltCacheLifetimeSeconds);
            result.setErrorListener((ErrorListener)XsltUpdateRequestHandler.xmllog);
            ctx.put(CONTEXT_TRANSFORMER_KEY, result);
        }
        return result;
    }
}

