/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class SolrInfoMBeanHandler
extends RequestHandlerBase {
    private Set<String> arrayToSet(Object[] arr) {
        HashSet<String> r = new HashSet<String>();
        if (null == arr) {
            return r;
        }
        for (Object o : arr) {
            if (null == o) continue;
            r.add(o.toString());
        }
        return r;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        SolrCore core = req.getCore();
        NamedList cats = new NamedList();
        rsp.add("solr-mbeans", cats);
        String[] requestedCats = req.getParams().getParams("cat");
        if (null == requestedCats || 0 == requestedCats.length) {
            for (SolrInfoMBean.Category category : SolrInfoMBean.Category.values()) {
                cats.add(category.name(), (Object)new SimpleOrderedMap());
            }
        } else {
            for (String string : requestedCats) {
                cats.add(string, (Object)new SimpleOrderedMap());
            }
        }
        Set<String> set = this.arrayToSet(req.getParams().getParams("key"));
        Map<String, SolrInfoMBean> reg = core.getInfoRegistry();
        for (Map.Entry<String, SolrInfoMBean> entry : reg.entrySet()) {
            NamedList catInfo;
            String key = entry.getKey();
            SolrInfoMBean m = entry.getValue();
            if (!set.isEmpty() && !set.contains(key) || null == (catInfo = (NamedList)cats.get(m.getCategory().name()))) continue;
            SimpleOrderedMap mBeanInfo = new SimpleOrderedMap();
            mBeanInfo.add("class", (Object)m.getName());
            mBeanInfo.add("version", (Object)m.getVersion());
            mBeanInfo.add("description", (Object)m.getDescription());
            mBeanInfo.add("srcId", (Object)m.getSourceId());
            mBeanInfo.add("src", (Object)m.getSource());
            mBeanInfo.add("docs", (Object)m.getDocs());
            if (req.getParams().getFieldBool(key, "stats", false)) {
                mBeanInfo.add("stats", (Object)m.getStatistics());
            }
            catInfo.add(key, (Object)mBeanInfo);
        }
        rsp.setHttpCaching(false);
    }

    @Override
    public String getDescription() {
        return "Get Info (and statistics) about all registered SolrInfoMBeans";
    }

    @Override
    public String getSourceId() {
        return "$Id$";
    }

    @Override
    public String getSource() {
        return "$URL$";
    }

    @Override
    public String getVersion() {
        return "$Revision$";
    }
}

