/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.text.ParseException;
import java.util.Date;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.schema.DateField;
import org.apache.solr.schema.FieldType;

class DateStatsValues
extends AbstractStatsValues<Date> {
    private static final DateField DATE_FIELD = new DateField();
    private long sum;

    public DateStatsValues(FieldType fieldType) {
        super(fieldType);
    }

    @Override
    protected void updateTypeSpecificStats(NamedList stv) {
        this.sum += ((Date)stv.get("sum")).getTime();
    }

    @Override
    public void updateTypeSpecificStats(Date value) {
        this.sum += value.getTime();
    }

    @Override
    public void updateTypeSpecificStats(Date value, int count) {
        this.sum += value.getTime() * (long)count;
    }

    @Override
    protected void updateMinMax(Date min, Date max) {
        if (this.min == null || ((Date)this.min).after(min)) {
            this.min = min;
        }
        if (this.max == null || ((Date)this.max).before(min)) {
            this.max = max;
        }
    }

    @Override
    protected Date toTypedValue(String value) {
        if (value.endsWith("Z")) {
            value = value.substring(0, value.length() - 1);
        }
        try {
            return DATE_FIELD.toObject(value);
        }
        catch (ParseException pe) {
            throw new IllegalStateException("Date " + value + " could not be parsed", pe);
        }
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
        res.add("sum", (Object)new Date(this.sum));
        if (this.count > 0L) {
            res.add("mean", (Object)new Date(this.sum / this.count));
        }
    }
}

