/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.handler.component.HttpShardHandlerFactory;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;

public class HttpShardHandler
extends ShardHandler {
    private HttpShardHandlerFactory httpShardHandlerFactory;
    private CompletionService<ShardResponse> completionService;
    private Set<Future<ShardResponse>> pending;
    private Map<String, List<String>> shardToURLs;

    public HttpShardHandler(HttpShardHandlerFactory httpShardHandlerFactory) {
        this.httpShardHandlerFactory = httpShardHandlerFactory;
        this.completionService = new ExecutorCompletionService<ShardResponse>(httpShardHandlerFactory.commExecutor);
        this.pending = new HashSet<Future<ShardResponse>>();
        this.shardToURLs = new HashMap<String, List<String>>();
    }

    private List<String> getURLs(String shard) {
        List urls = this.shardToURLs.get(shard);
        if (urls == null) {
            urls = StrUtils.splitSmart((String)shard, (String)"|", (boolean)true);
            for (int i = 0; i < urls.size(); ++i) {
                urls.set(i, this.httpShardHandlerFactory.scheme + (String)urls.get(i));
            }
            if (urls.size() > 1) {
                Collections.shuffle(urls, this.httpShardHandlerFactory.r);
            }
            this.shardToURLs.put(shard, urls);
        }
        return urls;
    }

    @Override
    public void submit(final ShardRequest sreq, final String shard, final ModifiableSolrParams params) {
        List<String> urls = this.getURLs(shard);
        Callable<ShardResponse> task = new Callable<ShardResponse>(){

            @Override
            public ShardResponse call() throws Exception {
                ShardResponse srsp = new ShardResponse();
                srsp.setShardRequest(sreq);
                srsp.setShard(shard);
                SimpleSolrResponse ssr = new SimpleSolrResponse();
                srsp.setSolrResponse(ssr);
                long startTime = System.currentTimeMillis();
                try {
                    String url = "http://" + shard;
                    params.remove("wt");
                    params.remove("version");
                    CommonsHttpSolrServer server = new CommonsHttpSolrServer(url, ((HttpShardHandler)HttpShardHandler.this).httpShardHandlerFactory.client);
                    QueryRequest req = new QueryRequest((SolrParams)params);
                    req.setMethod(SolrRequest.METHOD.POST);
                    ssr.nl = server.request((SolrRequest)req);
                }
                catch (Throwable th) {
                    srsp.setException(th);
                    if (th instanceof SolrException) {
                        srsp.setResponseCode(((SolrException)th).code());
                    }
                    srsp.setResponseCode(-1);
                }
                ssr.elapsedTime = System.currentTimeMillis() - startTime;
                return srsp;
            }
        };
        this.pending.add(this.completionService.submit(task));
    }

    @Override
    public ShardResponse takeCompletedOrError() {
        while (this.pending.size() > 0) {
            try {
                Future<ShardResponse> future = this.completionService.take();
                this.pending.remove(future);
                ShardResponse rsp = future.get();
                if (rsp.getException() != null) {
                    return rsp;
                }
                rsp.getShardRequest().responses.add(rsp);
                if (rsp.getShardRequest().responses.size() != rsp.getShardRequest().actualShards.length) continue;
                return rsp;
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Impossible Exception", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void cancelAll() {
        for (Future<ShardResponse> future : this.pending) {
            future.cancel(true);
        }
    }

    @Override
    public void checkDistributed(ResponseBuilder rb) {
        String shards_start;
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        String shards_rows = params.get("shards.rows");
        if (shards_rows != null) {
            rb.shards_rows = Integer.parseInt(shards_rows);
        }
        if ((shards_start = params.get("shards.start")) != null) {
            rb.shards_start = Integer.parseInt(shards_start);
        }
    }

    private static class SimpleSolrResponse
    extends SolrResponse {
        long elapsedTime;
        NamedList<Object> nl;

        private SimpleSolrResponse() {
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }

        public NamedList<Object> getResponse() {
            return this.nl;
        }

        public void setResponse(NamedList<Object> rsp) {
            this.nl = rsp;
        }
    }
}

