/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.handler.component.HttpShardHandler;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpShardHandlerFactory
extends ShardHandlerFactory
implements PluginInfoInitialized {
    protected static Logger log = LoggerFactory.getLogger(HttpShardHandlerFactory.class);
    Executor commExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    HttpClient client;
    Random r = new Random();
    int soTimeout = 0;
    int connectionTimeout = 0;
    int maxConnectionsPerHost = 20;
    int corePoolSize = 0;
    int maximumPoolSize = 10;
    int keepAliveTime = 5;
    int queueSize = 1;
    boolean accessPolicy = true;
    public String scheme = "http://";
    static final String INIT_SO_TIMEOUT = "socketTimeout";
    static final String INIT_CONNECTION_TIMEOUT = "connTimeout";
    static final String INIT_URL_SCHEME = "urlScheme";
    static final String INIT_MAX_CONNECTION_PER_HOST = "maxConnectionsPerHost";
    static final String INIT_CORE_POOL_SIZE = "corePoolSize";
    static final String INIT_MAX_POOL_SIZE = "maximumPoolSize";
    static final String MAX_THREAD_IDLE_TIME = "maxThreadIdleTime";
    static final String INIT_SIZE_OF_QUEUE = "sizeOfQueue";
    static final String INIT_FAIRNESS_POLICY = "fairnessPolicy";

    @Override
    public ShardHandler getShardHandler() {
        return new HttpShardHandler(this);
    }

    @Override
    public void init(PluginInfo info) {
        NamedList args = info.initArgs;
        this.soTimeout = this.getParameter(args, INIT_SO_TIMEOUT, 0);
        this.scheme = this.getParameter(args, INIT_URL_SCHEME, "http://");
        this.scheme = this.scheme.endsWith("://") ? this.scheme : this.scheme + "://";
        this.connectionTimeout = this.getParameter(args, INIT_CONNECTION_TIMEOUT, 0);
        this.maxConnectionsPerHost = this.getParameter(args, INIT_MAX_CONNECTION_PER_HOST, 20);
        this.corePoolSize = this.getParameter(args, INIT_CORE_POOL_SIZE, 0);
        this.maximumPoolSize = this.getParameter(args, INIT_MAX_POOL_SIZE, Integer.MAX_VALUE);
        this.keepAliveTime = this.getParameter(args, MAX_THREAD_IDLE_TIME, 5);
        this.queueSize = this.getParameter(args, INIT_SIZE_OF_QUEUE, -1);
        this.accessPolicy = this.getParameter(args, INIT_FAIRNESS_POLICY, false);
        this.commExecutor = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, this.keepAliveTime, TimeUnit.SECONDS, (BlockingQueue)((Object)(this.queueSize == -1 ? new SynchronousQueue(this.accessPolicy) : new ArrayBlockingQueue(this.queueSize, this.accessPolicy))));
        MultiThreadedHttpConnectionManager mgr = new MultiThreadedHttpConnectionManager();
        mgr.getParams().setDefaultMaxConnectionsPerHost(this.maxConnectionsPerHost);
        mgr.getParams().setMaxTotalConnections(10000);
        mgr.getParams().setConnectionTimeout(this.connectionTimeout);
        mgr.getParams().setSoTimeout(this.soTimeout);
        this.client = new HttpClient((HttpConnectionManager)mgr);
        DefaultHttpMethodRetryHandler retryhandler = new DefaultHttpMethodRetryHandler(0, false);
        this.client.getParams().setParameter("http.method.retry-handler", (Object)retryhandler);
    }

    private <T> T getParameter(NamedList initArgs, String configKey, T defaultValue) {
        Object toReturn = defaultValue;
        if (initArgs != null) {
            Object temp = initArgs.get(configKey);
            toReturn = temp != null ? temp : defaultValue;
        }
        log.info("Setting {} to: {}", (Object)configKey, toReturn);
        return toReturn;
    }
}

