/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.request;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.RefCounted;

public abstract class SolrQueryRequestBase
implements SolrQueryRequest {
    @Deprecated
    public static final String QUERY_NAME = "q";
    @Deprecated
    public static final String START_NAME = "start";
    @Deprecated
    public static final String ROWS_NAME = "rows";
    @Deprecated
    public static final String XSL_NAME = "xsl";
    @Deprecated
    public static final String QUERYTYPE_NAME = "qt";
    protected final SolrCore core;
    protected final SolrParams origParams;
    protected SolrParams params;
    protected Map<Object, Object> context;
    protected Iterable<ContentStream> streams;
    protected final long startTime = System.currentTimeMillis();
    protected RefCounted<SolrIndexSearcher> searcherHolder;

    public SolrQueryRequestBase(SolrCore core, SolrParams params) {
        this.core = core;
        this.params = this.origParams = params;
    }

    @Override
    public Map<Object, Object> getContext() {
        if (this.context == null) {
            this.context = new HashMap<Object, Object>();
        }
        return this.context;
    }

    @Override
    public SolrParams getParams() {
        return this.params;
    }

    @Override
    public SolrParams getOriginalParams() {
        return this.origParams;
    }

    @Override
    public void setParams(SolrParams params) {
        this.params = params;
    }

    @Override
    @Deprecated
    public String getParam(String name) {
        return this.params.get(name);
    }

    @Override
    @Deprecated
    public String[] getParams(String name) {
        return this.params.getParams(name);
    }

    @Deprecated
    public int getIntParam(String name) {
        String s = this.getParam(name);
        if (s == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter '" + name + "' from " + this);
        }
        return Integer.parseInt(s);
    }

    @Deprecated
    public int getIntParam(String name, int defval) {
        String s = this.getParam(name);
        return s == null ? defval : Integer.parseInt(s);
    }

    @Deprecated
    public String getStrParam(String name) {
        String s = this.getParam(name);
        if (s == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter '" + name + "' from " + this);
        }
        return s;
    }

    @Deprecated
    public String getStrParam(String name, String defval) {
        String s = this.getParam(name);
        return s == null ? defval : s;
    }

    @Override
    @Deprecated
    public String getQueryString() {
        return this.params.get(QUERY_NAME);
    }

    @Override
    @Deprecated
    public String getQueryType() {
        return this.params.get(QUERYTYPE_NAME);
    }

    @Override
    @Deprecated
    public int getStart() {
        return this.params.getInt(START_NAME, 0);
    }

    @Override
    @Deprecated
    public int getLimit() {
        return this.params.getInt(ROWS_NAME, 10);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public SolrIndexSearcher getSearcher() {
        if (this.core == null) {
            return null;
        }
        if (this.searcherHolder == null) {
            this.searcherHolder = this.core.getSearcher();
        }
        return this.searcherHolder.get();
    }

    @Override
    public SolrCore getCore() {
        return this.core;
    }

    @Override
    public IndexSchema getSchema() {
        return this.core == null ? null : this.core.getSchema();
    }

    @Override
    public void close() {
        if (this.searcherHolder != null) {
            this.searcherHolder.decref();
            this.searcherHolder = null;
        }
    }

    @Override
    public Iterable<ContentStream> getContentStreams() {
        return this.streams;
    }

    public void setContentStreams(Iterable<ContentStream> s) {
        this.streams = s;
    }

    @Override
    public String getParamString() {
        return this.origParams.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + this.params + '}';
    }
}

