/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.JSONWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;

class PHPSerializedWriter
extends JSONWriter {
    final UnicodeUtil.UTF8Result utf8 = new UnicodeUtil.UTF8Result();

    public PHPSerializedWriter(Writer writer, SolrQueryRequest req, SolrQueryResponse rsp) {
        super(writer, req, rsp);
        this.doIndent = false;
    }

    @Override
    public void writeResponse() throws IOException {
        Boolean omitHeader = this.req.getParams().getBool("omitHeader");
        if (omitHeader != null && omitHeader.booleanValue()) {
            this.rsp.getValues().remove("responseHeader");
        }
        this.writeNamedList(null, this.rsp.getValues());
    }

    @Override
    public void writeNamedList(String name, NamedList val) throws IOException {
        this.writeNamedListAsMapMangled(name, val);
    }

    @Override
    public void writeDoc(String name, Collection<Fieldable> fields, Set<String> returnFields, Map pseudoFields) throws IOException {
        ArrayList<Fieldable> single = new ArrayList<Fieldable>();
        LinkedHashMap<String, JSONWriter.MultiValueField> multi = new LinkedHashMap<String, JSONWriter.MultiValueField>();
        for (Fieldable ff : fields) {
            String fname = ff.name();
            if (returnFields != null && !returnFields.contains(fname)) continue;
            SchemaField sf = this.schema.getField(fname);
            if (sf.multiValued()) {
                JSONWriter.MultiValueField mf = (JSONWriter.MultiValueField)multi.get(fname);
                if (mf == null) {
                    mf = new JSONWriter.MultiValueField(sf, ff);
                    multi.put(fname, mf);
                    continue;
                }
                mf.fields.add(ff);
                continue;
            }
            single.add(ff);
        }
        this.writeArrayOpener(single.size() + multi.size() + (pseudoFields != null ? pseudoFields.size() : 0));
        for (Fieldable ff : single) {
            SchemaField sf = this.schema.getField(ff.name());
            this.writeKey(ff.name(), true);
            sf.write(this, ff.name(), ff);
        }
        for (JSONWriter.MultiValueField mvf : multi.values()) {
            this.writeKey(mvf.sfield.getName(), true);
            this.writeArrayOpener(mvf.fields.size());
            int i = 0;
            for (Fieldable ff : mvf.fields) {
                this.writeKey(i++, false);
                mvf.sfield.write(this, null, ff);
            }
            this.writeArrayCloser();
        }
        if (pseudoFields != null && pseudoFields.size() > 0) {
            this.writeMap(null, pseudoFields, true, false);
        }
        this.writeArrayCloser();
    }

    @Override
    public void writeDocList(String name, DocList ids, Set<String> fields, Map otherFields) throws IOException {
        boolean includeScore = false;
        if (fields != null) {
            includeScore = fields.contains("score");
            if (fields.size() == 0 || fields.size() == 1 && includeScore || fields.contains("*")) {
                fields = null;
            }
        }
        int sz = ids.size();
        this.writeMapOpener(includeScore ? 4 : 3);
        this.writeKey("numFound", false);
        this.writeInt(null, ids.matches());
        this.writeKey("start", false);
        this.writeInt(null, ids.offset());
        if (includeScore) {
            this.writeKey("maxScore", false);
            this.writeFloat(null, ids.maxScore());
        }
        this.writeKey("docs", false);
        this.writeArrayOpener(sz);
        SolrIndexSearcher searcher = this.req.getSearcher();
        DocIterator iterator = ids.iterator();
        for (int i = 0; i < sz; ++i) {
            int id = iterator.nextDoc();
            Document doc = searcher.doc(id, fields);
            this.writeKey(i, false);
            this.writeDoc(null, doc, fields, includeScore ? iterator.score() : 0.0f, includeScore);
        }
        this.writeMapCloser();
        if (otherFields != null) {
            this.writeMap(null, otherFields, true, false);
        }
        this.writeMapCloser();
    }

    @Override
    public void writeSolrDocument(String name, SolrDocument doc, Set<String> returnFields, Map pseudoFields) throws IOException {
        Object val;
        LinkedHashMap<String, Object> single = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> multi = new LinkedHashMap<String, Object>();
        int pseudoSize = pseudoFields != null ? pseudoFields.size() : 0;
        for (String fname : doc.getFieldNames()) {
            if (returnFields != null && !returnFields.contains(fname)) continue;
            val = doc.getFieldValue(fname);
            SchemaField sf = this.schema.getFieldOrNull(fname);
            if (sf != null && sf.multiValued()) {
                multi.put(fname, val);
                continue;
            }
            single.put(fname, val);
        }
        this.writeMapOpener(single.size() + multi.size() + pseudoSize);
        for (String fname : single.keySet()) {
            val = single.get(fname);
            this.writeKey(fname, true);
            this.writeVal(fname, val);
        }
        for (String fname : multi.keySet()) {
            this.writeKey(fname, true);
            val = multi.get(fname);
            if (!(val instanceof Collection)) {
                this.writeArrayOpener(1);
                this.writeVal(fname, val);
                this.writeArrayCloser();
                continue;
            }
            this.writeVal(fname, val);
        }
        if (pseudoSize > 0) {
            this.writeMap(null, pseudoFields, true, false);
        }
        this.writeMapCloser();
    }

    @Override
    public void writeSolrDocumentList(String name, SolrDocumentList docs, Set<String> fields, Map otherFields) throws IOException {
        boolean includeScore = false;
        if (fields != null) {
            includeScore = fields.contains("score");
            if (fields.size() == 0 || fields.size() == 1 && includeScore || fields.contains("*")) {
                fields = null;
            }
        }
        int sz = docs.size();
        this.writeMapOpener(includeScore ? 4 : 3);
        this.writeKey("numFound", false);
        this.writeLong(null, docs.getNumFound());
        this.writeKey("start", false);
        this.writeLong(null, docs.getStart());
        if (includeScore && docs.getMaxScore() != null) {
            this.writeKey("maxScore", false);
            this.writeFloat(null, docs.getMaxScore().floatValue());
        }
        this.writeKey("docs", false);
        this.writeArrayOpener(sz);
        for (int i = 0; i < sz; ++i) {
            this.writeKey(i, false);
            this.writeSolrDocument(null, (SolrDocument)docs.get(i), fields, otherFields);
        }
        this.writeArrayCloser();
        if (otherFields != null) {
            this.writeMap(null, otherFields, true, false);
        }
        this.writeMapCloser();
    }

    @Override
    public void writeArray(String name, Object[] val) throws IOException {
        this.writeMapOpener(val.length);
        for (int i = 0; i < val.length; ++i) {
            this.writeKey(i, false);
            this.writeVal(String.valueOf(i), val[i]);
        }
        this.writeMapCloser();
    }

    @Override
    public void writeArray(String name, Iterator val) throws IOException {
        ArrayList vals = new ArrayList();
        while (val.hasNext()) {
            vals.add(val.next());
        }
        this.writeArray(name, vals.toArray());
    }

    @Override
    public void writeMapOpener(int size) throws IOException, IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Map size must not be negative");
        }
        this.writer.write("a:" + size + ":{");
    }

    @Override
    public void writeMapSeparator() throws IOException {
    }

    @Override
    public void writeMapCloser() throws IOException {
        this.writer.write('}');
    }

    @Override
    public void writeArrayOpener(int size) throws IOException, IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException("Array size must not be negative");
        }
        this.writer.write("a:" + size + ":{");
    }

    @Override
    public void writeArraySeparator() throws IOException {
    }

    @Override
    public void writeArrayCloser() throws IOException {
        this.writer.write('}');
    }

    @Override
    public void writeNull(String name) throws IOException {
        this.writer.write("N;");
    }

    @Override
    protected void writeKey(String fname, boolean needsEscaping) throws IOException {
        this.writeStr(null, fname, needsEscaping);
    }

    void writeKey(int val, boolean needsEscaping) throws IOException {
        this.writeInt(null, String.valueOf(val));
    }

    @Override
    public void writeBool(String name, boolean val) throws IOException {
        this.writer.write(val ? "b:1;" : "b:0;");
    }

    @Override
    public void writeBool(String name, String val) throws IOException {
        this.writeBool(name, val.charAt(0) == 't');
    }

    @Override
    public void writeInt(String name, String val) throws IOException {
        this.writer.write("i:" + val + ";");
    }

    @Override
    public void writeLong(String name, String val) throws IOException {
        this.writeInt(name, val);
    }

    @Override
    public void writeFloat(String name, String val) throws IOException {
        this.writeDouble(name, val);
    }

    @Override
    public void writeDouble(String name, String val) throws IOException {
        this.writer.write("d:" + val + ";");
    }

    @Override
    public void writeStr(String name, String val, boolean needsEscaping) throws IOException {
        UnicodeUtil.UTF16toUTF8((String)val, (int)0, (int)val.length(), (UnicodeUtil.UTF8Result)this.utf8);
        int nBytes = this.utf8.length;
        this.writer.write("s:");
        this.writer.write(Integer.toString(nBytes));
        this.writer.write(":\"");
        this.writer.write(val);
        this.writer.write("\";");
    }
}

