/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.util.Base64;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;

public class BinaryField
extends FieldType {
    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeStr(name, this.toBase64String(this.toObject(f)));
    }

    private String toBase64String(ByteBuffer buf) {
        return Base64.byteArrayToBase64((byte[])buf.array(), (int)buf.position(), (int)(buf.limit() - buf.position()));
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeStr(name, this.toBase64String(this.toObject(f)), false);
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new RuntimeException("Cannot sort on a Binary field");
    }

    @Override
    public String toExternal(Fieldable f) {
        return this.toBase64String(this.toObject(f));
    }

    @Override
    public ByteBuffer toObject(Fieldable f) {
        return ByteBuffer.wrap(f.getBinaryValue(), f.getBinaryOffset(), f.getBinaryLength());
    }

    public Field createField(SchemaField field, Object val, float boost) {
        if (val == null) {
            return null;
        }
        if (!field.stored()) {
            log.trace("Ignoring unstored binary field: " + field);
            return null;
        }
        byte[] buf = null;
        int offset = 0;
        int len = 0;
        if (val instanceof byte[]) {
            buf = (byte[])val;
            len = buf.length;
        } else if (val instanceof ByteBuffer && ((ByteBuffer)val).hasArray()) {
            ByteBuffer byteBuf = (ByteBuffer)val;
            buf = byteBuf.array();
            offset = byteBuf.position();
            len = byteBuf.limit() - byteBuf.position();
        } else {
            String strVal = val.toString();
            buf = Base64.base64ToByteArray((String)strVal);
            offset = 0;
            len = buf.length;
        }
        Field f = new Field(field.getName(), buf, offset, len);
        f.setBoost(boost);
        return f;
    }
}

