/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.analysis.SolrAnalyzer;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.PrimitiveFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.OrdFieldSource;
import org.apache.solr.search.function.ValueSource;

public class BoolField
extends PrimitiveFieldType {
    protected static final char[] TRUE_TOKEN = new char[]{'T'};
    protected static final char[] FALSE_TOKEN = new char[]{'F'};
    protected static final Analyzer boolAnalyzer = new SolrAnalyzer(){

        @Override
        public SolrAnalyzer.TokenStreamInfo getStream(String fieldName, Reader reader) {
            Tokenizer tokenizer = new Tokenizer(reader){
                final CharTermAttribute termAtt;
                boolean done;
                {
                    this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                    this.done = false;
                }

                public void reset(Reader input) throws IOException {
                    this.done = false;
                    super.reset(input);
                }

                public boolean incrementToken() throws IOException {
                    this.clearAttributes();
                    if (this.done) {
                        return false;
                    }
                    this.done = true;
                    int ch = this.input.read();
                    if (ch == -1) {
                        return false;
                    }
                    this.termAtt.copyBuffer(ch == 116 || ch == 84 || ch == 49 ? TRUE_TOKEN : FALSE_TOKEN, 0, 1);
                    return true;
                }
            };
            return new SolrAnalyzer.TokenStreamInfo(tokenizer, (TokenStream)tokenizer);
        }
    };

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        field.checkSortability();
        return this.getStringSort(field, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new OrdFieldSource(field.name);
    }

    @Override
    public Analyzer getAnalyzer() {
        return boolAnalyzer;
    }

    @Override
    public Analyzer getQueryAnalyzer() {
        return boolAnalyzer;
    }

    @Override
    public String toInternal(String val) {
        int ch = val != null && val.length() > 0 ? (int)val.charAt(0) : 0;
        return ch == 49 || ch == 116 || ch == 84 ? "T" : "F";
    }

    @Override
    public String toExternal(Fieldable f) {
        return this.indexedToReadable(f.stringValue());
    }

    @Override
    public Boolean toObject(Fieldable f) {
        return Boolean.valueOf(this.toExternal(f));
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        char ch = indexedForm.charAt(0);
        return ch == 'T' ? "true" : "false";
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        xmlWriter.writeBool(name, f.stringValue().charAt(0) == 'T');
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        writer.writeBool(name, f.stringValue().charAt(0) == 'T');
    }
}

