/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;
import org.apache.solr.analysis.CharFilterFactory;
import org.apache.solr.analysis.KeywordTokenizerFactory;
import org.apache.solr.analysis.MultiTermAwareComponent;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SystemIdResolver;
import org.apache.solr.core.Config;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SimilarityFactory;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.util.plugin.AbstractPluginLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class IndexSchema {
    public static final String DEFAULT_SCHEMA_FILE = "schema.xml";
    public static final String LUCENE_MATCH_VERSION_PARAM = "luceneMatchVersion";
    static final Logger log = LoggerFactory.getLogger(IndexSchema.class);
    private final SolrConfig solrConfig;
    private final String resourceName;
    private String name;
    private float version;
    private final SolrResourceLoader loader;
    private final HashMap<String, SchemaField> fields = new HashMap();
    private final HashMap<String, FieldType> fieldTypes = new HashMap();
    private final List<SchemaField> fieldsWithDefaultValue = new ArrayList<SchemaField>();
    private final Collection<SchemaField> requiredFields = new HashSet<SchemaField>();
    private DynamicField[] dynamicFields;
    private Analyzer analyzer;
    private Analyzer queryAnalyzer;
    private String defaultSearchFieldName = null;
    private String queryParserDefaultOperator = "OR";
    private final Map<String, List<CopyField>> copyFieldsMap = new HashMap<String, List<CopyField>>();
    private DynamicCopy[] dynamicCopyFields;
    private Map<SchemaField, Integer> copyFieldTargetCounts = new HashMap<SchemaField, Integer>();
    private SimilarityFactory similarityFactory;
    private SchemaField uniqueKeyField;
    private String uniqueKeyFieldName;
    private FieldType uniqueKeyFieldType;

    @Deprecated
    public IndexSchema(SolrConfig solrConfig, String name) {
        this(solrConfig, name, null);
    }

    public IndexSchema(SolrConfig solrConfig, String name, InputSource is) {
        this.solrConfig = solrConfig;
        if (name == null) {
            name = DEFAULT_SCHEMA_FILE;
        }
        this.resourceName = name;
        this.loader = solrConfig.getResourceLoader();
        if (is == null) {
            is = new InputSource(this.loader.openSchema(name));
            is.setSystemId(SystemIdResolver.createSystemIdFromResourceName((String)name));
        }
        this.readSchema(is);
        this.loader.inform(this.loader);
    }

    @Deprecated
    public SolrConfig getSolrConfig() {
        return this.solrConfig;
    }

    public SolrResourceLoader getResourceLoader() {
        return this.loader;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getSchemaName() {
        return this.name;
    }

    float getVersion() {
        return this.version;
    }

    @Deprecated
    public InputStream getInputStream() {
        return this.loader.openResource(this.resourceName);
    }

    @Deprecated
    public String getSchemaFile() {
        return this.resourceName;
    }

    @Deprecated
    public String getName() {
        return this.name;
    }

    public Map<String, SchemaField> getFields() {
        return this.fields;
    }

    public Map<String, FieldType> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<SchemaField> getFieldsWithDefaultValue() {
        return this.fieldsWithDefaultValue;
    }

    public Collection<SchemaField> getRequiredFields() {
        return this.requiredFields;
    }

    public Similarity getSimilarity() {
        return this.similarityFactory.getSimilarity();
    }

    public SimilarityFactory getSimilarityFactory() {
        return this.similarityFactory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    @Deprecated
    public SolrQueryParser getSolrQueryParser(String defaultField) {
        SolrQueryParser qp = new SolrQueryParser(this, defaultField);
        String operator = this.getQueryParserDefaultOperator();
        qp.setDefaultOperator("AND".equals(operator) ? QueryParser.Operator.AND : QueryParser.Operator.OR);
        return qp;
    }

    public String getDefaultSearchFieldName() {
        return this.defaultSearchFieldName;
    }

    @Deprecated
    public String getQueryParserDefaultOperator() {
        return this.queryParserDefaultOperator;
    }

    public SchemaField getUniqueKeyField() {
        return this.uniqueKeyField;
    }

    public Fieldable getUniqueKeyField(org.apache.lucene.document.Document doc) {
        return doc.getFieldable(this.uniqueKeyFieldName);
    }

    public String printableUniqueKey(org.apache.lucene.document.Document doc) {
        Fieldable f = doc.getFieldable(this.uniqueKeyFieldName);
        return f == null ? null : this.uniqueKeyFieldType.toExternal(f);
    }

    private SchemaField getIndexedField(String fname) {
        SchemaField f = this.getFields().get(fname);
        if (f == null) {
            throw new RuntimeException("unknown field '" + fname + "'");
        }
        if (!f.indexed()) {
            throw new RuntimeException("'" + fname + "' is not an indexed field:" + f);
        }
        return f;
    }

    public void refreshAnalyzers() {
        this.analyzer = new SolrIndexAnalyzer();
        this.queryAnalyzer = new SolrQueryAnalyzer();
    }

    private void readSchema(InputSource is) {
        log.info("Reading Solr Schema");
        try {
            NamedNodeMap attrs;
            Config schemaConf = new Config(this.loader, "schema", is, "/schema/");
            Document document = schemaConf.getDocument();
            final XPath xpath = schemaConf.getXPath();
            final ArrayList<SchemaAware> schemaAware = new ArrayList<SchemaAware>();
            Node nd = (Node)xpath.evaluate("/schema/@name", document, XPathConstants.NODE);
            if (nd == null) {
                log.warn("schema has no name!");
            } else {
                this.name = nd.getNodeValue();
                log.info("Schema name=" + this.name);
            }
            this.version = schemaConf.getFloat("/schema/@version", 1.0f);
            final IndexSchema schema = this;
            AbstractPluginLoader<FieldType> fieldLoader = new AbstractPluginLoader<FieldType>("[schema.xml] fieldType", true, true){

                @Override
                protected FieldType create(ResourceLoader loader, String name, String className, Node node) throws Exception {
                    FieldType ft = (FieldType)loader.newInstance(className, new String[0]);
                    ft.setTypeName(name);
                    String expression = "./analyzer[@type='query']";
                    Node anode = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
                    Analyzer queryAnalyzer = IndexSchema.this.readAnalyzer(anode);
                    expression = "./analyzer[@type='multiterm']";
                    anode = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
                    Analyzer multiAnalyzer = IndexSchema.this.readAnalyzer(anode);
                    expression = "./analyzer[not(@type)] | ./analyzer[@type='index']";
                    anode = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
                    Analyzer analyzer = IndexSchema.this.readAnalyzer(anode);
                    if (queryAnalyzer == null) {
                        queryAnalyzer = analyzer;
                    }
                    if (analyzer == null) {
                        analyzer = queryAnalyzer;
                    }
                    if (multiAnalyzer == null) {
                        multiAnalyzer = IndexSchema.this.constructMultiTermAnalyzer(queryAnalyzer);
                    }
                    if (analyzer != null) {
                        ft.setAnalyzer(analyzer);
                        ft.setQueryAnalyzer(queryAnalyzer);
                        if (ft instanceof TextField) {
                            ((TextField)ft).setMultiTermAnalyzer(multiAnalyzer);
                        }
                    }
                    if (ft instanceof SchemaAware) {
                        schemaAware.add((SchemaAware)((Object)ft));
                    }
                    return ft;
                }

                @Override
                protected void init(FieldType plugin, Node node) throws Exception {
                    Map params = DOMUtil.toMapExcept((NamedNodeMap)node.getAttributes(), (String[])new String[]{"name", "class"});
                    plugin.setArgs(schema, params);
                }

                @Override
                protected FieldType register(String name, FieldType plugin) throws Exception {
                    log.trace("fieldtype defined: " + plugin);
                    return IndexSchema.this.fieldTypes.put(name, plugin);
                }
            };
            String expression = "/schema/types/fieldtype | /schema/types/fieldType";
            NodeList nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
            fieldLoader.load(this.loader, nodes);
            HashMap<String, Boolean> explicitRequiredProp = new HashMap<String, Boolean>();
            ArrayList<DynamicField> dFields = new ArrayList<DynamicField>();
            expression = "/schema/fields/field | /schema/fields/dynamicField";
            nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                attrs = node.getAttributes();
                String name = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"name", (String)"field definition");
                log.trace("reading field def " + name);
                String type = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"type", (String)("field " + name));
                FieldType ft = this.fieldTypes.get(type);
                if (ft == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unknown fieldtype '" + type + "' specified on field " + name, false);
                }
                Map args = DOMUtil.toMapExcept((NamedNodeMap)attrs, (String[])new String[]{"name", "type"});
                if (args.get("required") != null) {
                    explicitRequiredProp.put(name, Boolean.valueOf((String)args.get("required")));
                }
                SchemaField f = SchemaField.create(name, ft, args);
                if (node.getNodeName().equals("field")) {
                    SchemaField old = this.fields.put(f.getName(), f);
                    if (old != null) {
                        String msg = "[schema.xml] Duplicate field definition for '" + f.getName() + "' ignoring: " + old.toString();
                        SolrException t = new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                        SolrException.logOnce((Logger)log, null, (Throwable)t);
                        SolrConfig.severeErrors.add(t);
                    }
                    log.debug("field defined: " + f);
                    if (f.getDefaultValue() != null) {
                        log.debug(name + " contains default value: " + f.getDefaultValue());
                        this.fieldsWithDefaultValue.add(f);
                    }
                    if (!f.isRequired()) continue;
                    log.debug(name + " is required in this schema");
                    this.requiredFields.add(f);
                    continue;
                }
                if (node.getNodeName().equals("dynamicField")) {
                    this.addDynamicField(dFields, f);
                    continue;
                }
                throw new RuntimeException("Unknown field type");
            }
            this.requiredFields.addAll(this.getFieldsWithDefaultValue());
            Collections.sort(dFields);
            log.trace("Dynamic Field Ordering:" + dFields);
            this.dynamicFields = dFields.toArray(new DynamicField[dFields.size()]);
            Node node = (Node)xpath.evaluate("/schema/similarity", document, XPathConstants.NODE);
            if (node == null) {
                this.similarityFactory = new SimilarityFactory(){

                    @Override
                    public Similarity getSimilarity() {
                        return Similarity.getDefault();
                    }
                };
                log.debug("using default similarity");
            } else {
                final Object obj = this.loader.newInstance(((Element)node).getAttribute("class"), new String[0]);
                if (obj instanceof SimilarityFactory) {
                    SolrParams params = SolrParams.toSolrParams((NamedList)DOMUtil.childNodesToNamedList((Node)node));
                    this.similarityFactory = (SimilarityFactory)obj;
                    this.similarityFactory.init(params);
                } else {
                    this.similarityFactory = new SimilarityFactory(){

                        @Override
                        public Similarity getSimilarity() {
                            return (Similarity)obj;
                        }
                    };
                }
                if (this.similarityFactory instanceof SchemaAware) {
                    schemaAware.add((SchemaAware)((Object)this.similarityFactory));
                }
                log.debug("using similarity factory" + this.similarityFactory.getClass().getName());
            }
            node = (Node)xpath.evaluate("/schema/defaultSearchField/text()", document, XPathConstants.NODE);
            if (node == null) {
                log.debug("no default search field specified in schema.");
            } else {
                SchemaField defaultSearchField;
                this.defaultSearchFieldName = node.getNodeValue().trim();
                if (!(this.defaultSearchFieldName == null || (defaultSearchField = this.getFields().get(this.defaultSearchFieldName)) != null && defaultSearchField.indexed())) {
                    String msg = "default search field '" + this.defaultSearchFieldName + "' not defined or not indexed";
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
                }
                log.info("default search field in schema is " + this.defaultSearchFieldName);
            }
            node = (Node)xpath.evaluate("/schema/solrQueryParser/@defaultOperator", document, XPathConstants.NODE);
            if (node == null) {
                log.debug("using default query parser operator (OR)");
            } else {
                this.queryParserDefaultOperator = node.getNodeValue().trim();
                log.info("query parser default operator is " + this.queryParserDefaultOperator);
            }
            node = (Node)xpath.evaluate("/schema/uniqueKey/text()", document, XPathConstants.NODE);
            if (node == null) {
                log.warn("no uniqueKey specified in schema.");
            } else {
                this.uniqueKeyField = this.getIndexedField(node.getNodeValue().trim());
                if (!this.uniqueKeyField.stored()) {
                    log.error("uniqueKey is not stored - distributed search will not work");
                }
                if (this.uniqueKeyField.multiValued()) {
                    log.error("uniqueKey should not be multivalued");
                }
                this.uniqueKeyFieldName = this.uniqueKeyField.getName();
                this.uniqueKeyFieldType = this.uniqueKeyField.getType();
                log.info("unique key field: " + this.uniqueKeyFieldName);
                if (Boolean.FALSE != explicitRequiredProp.get(this.uniqueKeyFieldName)) {
                    this.uniqueKeyField.required = true;
                    this.requiredFields.add(this.uniqueKeyField);
                }
            }
            this.dynamicCopyFields = new DynamicCopy[0];
            expression = "//copyField";
            nodes = (NodeList)xpath.evaluate(expression, document, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                attrs = node.getAttributes();
                String source = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"source", (String)"copyField definition");
                String dest = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"dest", (String)"copyField definition");
                String maxChars = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"maxChars");
                int maxCharsInt = 0;
                if (maxChars != null) {
                    try {
                        maxCharsInt = Integer.parseInt(maxChars);
                    }
                    catch (NumberFormatException e) {
                        log.warn("Couldn't parse maxChars attribute for copyField from " + source + " to " + dest + " as integer. The whole field will be copied.");
                    }
                }
                this.registerCopyField(source, dest, maxCharsInt);
            }
            for (Map.Entry<SchemaField, Integer> entry : this.copyFieldTargetCounts.entrySet()) {
                if (entry.getValue() <= 1 || entry.getKey().multiValued()) continue;
                log.warn("Field " + entry.getKey().name + " is not multivalued " + "and destination for multiple copyFields (" + entry.getValue() + ")");
            }
            for (SchemaAware aware : schemaAware) {
                aware.inform(this);
            }
        }
        catch (SolrException e) {
            SolrConfig.severeErrors.add(e);
            throw e;
        }
        catch (Exception e) {
            SolrConfig.severeErrors.add(e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Schema Parsing Failed: " + e.getMessage(), (Throwable)e, false);
        }
        this.refreshAnalyzers();
    }

    private void addDynamicField(List<DynamicField> dFields, SchemaField f) {
        boolean dup = this.isDuplicateDynField(dFields, f);
        if (!dup) {
            this.addDynamicFieldNoDupCheck(dFields, f);
        } else {
            String msg = "[schema.xml] Duplicate DynamicField definition for '" + f.getName() + "' ignoring: " + f.toString();
            SolrException t = new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            SolrException.logOnce((Logger)log, null, (Throwable)t);
            SolrConfig.severeErrors.add(t);
        }
    }

    private Analyzer constructMultiTermAnalyzer(Analyzer queryAnalyzer) {
        if (queryAnalyzer == null) {
            return null;
        }
        if (!(queryAnalyzer instanceof TokenizerChain)) {
            return new KeywordAnalyzer();
        }
        TokenizerChain tc = (TokenizerChain)queryAnalyzer;
        MultiTermChainBuilder builder = new MultiTermChainBuilder();
        CharFilterFactory[] charFactories = tc.getCharFilterFactories();
        if (charFactories != null) {
            for (CharFilterFactory charFilterFactory : charFactories) {
                builder.add(charFilterFactory);
            }
        }
        builder.add(tc.getTokenizerFactory());
        for (TokenFilterFactory tokenFilterFactory : tc.getTokenFilterFactories()) {
            builder.add(tokenFilterFactory);
        }
        return builder.build();
    }

    public void registerDynamicField(SchemaField ... f) {
        ArrayList<DynamicField> dynFields = new ArrayList<DynamicField>(Arrays.asList(this.dynamicFields));
        for (SchemaField field : f) {
            if (!this.isDuplicateDynField(dynFields, field)) {
                log.debug("dynamic field creation for schema field: " + field.getName());
                this.addDynamicFieldNoDupCheck(dynFields, field);
                continue;
            }
            log.debug("dynamic field already exists: dynamic field: [" + field.getName() + "]");
        }
        Collections.sort(dynFields);
        this.dynamicFields = dynFields.toArray(new DynamicField[dynFields.size()]);
    }

    private void addDynamicFieldNoDupCheck(List<DynamicField> dFields, SchemaField f) {
        dFields.add(new DynamicField(f));
        log.debug("dynamic field defined: " + f);
    }

    private boolean isDuplicateDynField(List<DynamicField> dFields, SchemaField f) {
        for (DynamicField df : dFields) {
            if (!df.regex.equals(f.name)) continue;
            return true;
        }
        return false;
    }

    public void registerCopyField(String source, String dest) {
        this.registerCopyField(source, dest, 0);
    }

    public void registerCopyField(String source, String dest, int maxChars) {
        boolean sourceIsPattern = IndexSchema.isWildCard(source);
        boolean destIsPattern = IndexSchema.isWildCard(dest);
        log.debug("copyField source='" + source + "' dest='" + dest + "' maxChars='" + maxChars);
        SchemaField d = this.getFieldOrNull(dest);
        if (d == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "copyField destination :'" + dest + "' does not exist");
        }
        if (sourceIsPattern) {
            if (destIsPattern) {
                DynamicField df = null;
                for (DynamicField dd : this.dynamicFields) {
                    if (!dd.regex.equals(dest)) continue;
                    df = dd;
                    break;
                }
                if (df == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "copyField dynamic destination must match a dynamicField.");
                }
                this.registerDynamicCopyField(new DynamicDestCopy(source, df, maxChars));
            } else {
                this.registerDynamicCopyField(new DynamicCopy(source, d, maxChars));
            }
        } else {
            if (destIsPattern) {
                String msg = "copyField only supports a dynamic destination if the source is also dynamic";
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, msg);
            }
            SchemaField f = this.getField(source);
            List<CopyField> copyFieldList = this.copyFieldsMap.get(source);
            if (copyFieldList == null) {
                copyFieldList = new ArrayList<CopyField>();
                this.copyFieldsMap.put(source, copyFieldList);
            }
            copyFieldList.add(new CopyField(f, d, maxChars));
            this.copyFieldTargetCounts.put(d, this.copyFieldTargetCounts.containsKey(d) ? this.copyFieldTargetCounts.get(d) + 1 : 1);
        }
    }

    private void registerDynamicCopyField(DynamicCopy dcopy) {
        if (this.dynamicCopyFields == null) {
            this.dynamicCopyFields = new DynamicCopy[]{dcopy};
        } else {
            DynamicCopy[] temp = new DynamicCopy[this.dynamicCopyFields.length + 1];
            System.arraycopy(this.dynamicCopyFields, 0, temp, 0, this.dynamicCopyFields.length);
            temp[temp.length - 1] = dcopy;
            this.dynamicCopyFields = temp;
        }
        log.trace("Dynamic Copy Field:" + dcopy);
    }

    private static Object[] append(Object[] orig, Object item) {
        Object[] newArr = (Object[])Array.newInstance(orig.getClass().getComponentType(), orig.length + 1);
        System.arraycopy(orig, 0, newArr, 0, orig.length);
        newArr[orig.length] = item;
        return newArr;
    }

    private Analyzer readAnalyzer(Node node) throws XPathExpressionException {
        if (node == null) {
            return null;
        }
        NamedNodeMap attrs = node.getAttributes();
        String analyzerName = DOMUtil.getAttr((NamedNodeMap)attrs, (String)"class");
        if (analyzerName != null) {
            try {
                Class<Analyzer> clazz = this.loader.findClass(analyzerName, new String[0]).asSubclass(Analyzer.class);
                try {
                    Version luceneMatchVersion;
                    Constructor<Analyzer> cnstr = clazz.getConstructor(Version.class);
                    String matchVersionStr = DOMUtil.getAttr((NamedNodeMap)attrs, (String)LUCENE_MATCH_VERSION_PARAM);
                    Version version = luceneMatchVersion = matchVersionStr == null ? this.solrConfig.luceneMatchVersion : Config.parseLuceneVersionString(matchVersionStr);
                    if (luceneMatchVersion == null) {
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Configuration Error: Analyzer '" + clazz.getName() + "' needs a 'luceneMatchVersion' parameter");
                    }
                    return cnstr.newInstance(luceneMatchVersion);
                }
                catch (NoSuchMethodException nsme) {
                    return clazz.newInstance();
                }
            }
            catch (Exception e) {
                log.error("Cannot load analyzer: " + analyzerName, (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Cannot load analyzer: " + analyzerName, (Throwable)e);
            }
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        final ArrayList charFilters = new ArrayList();
        AbstractPluginLoader<CharFilterFactory> charFilterLoader = new AbstractPluginLoader<CharFilterFactory>("[schema.xml] analyzer/charFilter", false, false){

            @Override
            protected void init(CharFilterFactory plugin, Node node) throws Exception {
                if (plugin != null) {
                    Map params = DOMUtil.toMapExcept((NamedNodeMap)node.getAttributes(), (String[])new String[]{"class"});
                    if (!params.containsKey(IndexSchema.LUCENE_MATCH_VERSION_PARAM)) {
                        params.put(IndexSchema.LUCENE_MATCH_VERSION_PARAM, ((IndexSchema)IndexSchema.this).solrConfig.luceneMatchVersion.toString());
                    }
                    plugin.init(params);
                    charFilters.add(plugin);
                }
            }

            @Override
            protected CharFilterFactory register(String name, CharFilterFactory plugin) throws Exception {
                return null;
            }
        };
        charFilterLoader.load(this.solrConfig.getResourceLoader(), (NodeList)xpath.evaluate("./charFilter", node, XPathConstants.NODESET));
        final ArrayList tokenizers = new ArrayList(1);
        AbstractPluginLoader<TokenizerFactory> tokenizerLoader = new AbstractPluginLoader<TokenizerFactory>("[schema.xml] analyzer/tokenizer", false, false){

            @Override
            protected void init(TokenizerFactory plugin, Node node) throws Exception {
                if (!tokenizers.isEmpty()) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The schema defines multiple tokenizers for: " + node);
                }
                Map params = DOMUtil.toMapExcept((NamedNodeMap)node.getAttributes(), (String[])new String[]{"class"});
                if (!params.containsKey(IndexSchema.LUCENE_MATCH_VERSION_PARAM)) {
                    params.put(IndexSchema.LUCENE_MATCH_VERSION_PARAM, ((IndexSchema)IndexSchema.this).solrConfig.luceneMatchVersion.toString());
                }
                plugin.init(params);
                tokenizers.add(plugin);
            }

            @Override
            protected TokenizerFactory register(String name, TokenizerFactory plugin) throws Exception {
                return null;
            }
        };
        tokenizerLoader.load(this.loader, (NodeList)xpath.evaluate("./tokenizer", node, XPathConstants.NODESET));
        if (tokenizers.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "analyzer without class or tokenizer & filter list");
        }
        final ArrayList filters = new ArrayList();
        AbstractPluginLoader<TokenFilterFactory> filterLoader = new AbstractPluginLoader<TokenFilterFactory>("[schema.xml] analyzer/filter", false, false){

            @Override
            protected void init(TokenFilterFactory plugin, Node node) throws Exception {
                if (plugin != null) {
                    Map params = DOMUtil.toMapExcept((NamedNodeMap)node.getAttributes(), (String[])new String[]{"class"});
                    if (!params.containsKey(IndexSchema.LUCENE_MATCH_VERSION_PARAM)) {
                        params.put(IndexSchema.LUCENE_MATCH_VERSION_PARAM, ((IndexSchema)IndexSchema.this).solrConfig.luceneMatchVersion.toString());
                    }
                    plugin.init(params);
                    filters.add(plugin);
                }
            }

            @Override
            protected TokenFilterFactory register(String name, TokenFilterFactory plugin) throws Exception {
                return null;
            }
        };
        filterLoader.load(this.loader, (NodeList)xpath.evaluate("./filter", node, XPathConstants.NODESET));
        return new TokenizerChain(charFilters.toArray(new CharFilterFactory[charFilters.size()]), (TokenizerFactory)tokenizers.get(0), filters.toArray(new TokenFilterFactory[filters.size()]));
    }

    public SchemaField[] getDynamicFieldPrototypes() {
        SchemaField[] df = new SchemaField[this.dynamicFields.length];
        for (int i = 0; i < this.dynamicFields.length; ++i) {
            df[i] = this.dynamicFields[i].prototype;
        }
        return df;
    }

    public String getDynamicPattern(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.regex;
        }
        return null;
    }

    public boolean hasExplicitField(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return true;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicField(String fieldName) {
        if (this.fields.containsKey(fieldName)) {
            return false;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return true;
        }
        return false;
    }

    public SchemaField getFieldOrNull(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f;
        }
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.makeSchemaField(fieldName);
        }
        return f;
    }

    public SchemaField getField(String fieldName) {
        SchemaField f = this.getFieldOrNull(fieldName);
        if (f != null) {
            return f;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field: \"" + fieldName + "\"");
    }

    public FieldType getFieldType(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f.getType();
        }
        return this.getDynamicFieldType(fieldName);
    }

    public FieldType getFieldTypeByName(String fieldTypeName) {
        return this.fieldTypes.get(fieldTypeName);
    }

    public FieldType getFieldTypeNoEx(String fieldName) {
        SchemaField f = this.fields.get(fieldName);
        if (f != null) {
            return f.getType();
        }
        return this.dynFieldType(fieldName);
    }

    public FieldType getDynamicFieldType(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.prototype.getType();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "undefined field " + fieldName);
    }

    private FieldType dynFieldType(String fieldName) {
        for (DynamicField df : this.dynamicFields) {
            if (!df.matches(fieldName)) continue;
            return df.prototype.getType();
        }
        return null;
    }

    public SchemaField[] getCopySources(String destField) {
        SchemaField f = this.getField(destField);
        if (!this.isCopyFieldTarget(f)) {
            return new SchemaField[0];
        }
        ArrayList<SchemaField> sf = new ArrayList<SchemaField>();
        for (Map.Entry<String, List<CopyField>> cfs : this.copyFieldsMap.entrySet()) {
            for (CopyField copyField : cfs.getValue()) {
                if (!copyField.getDestination().getName().equals(destField)) continue;
                sf.add(copyField.getSource());
            }
        }
        return sf.toArray(new SchemaField[sf.size()]);
    }

    @Deprecated
    public SchemaField[] getCopyFields(String sourceField) {
        ArrayList<SchemaField> matchCopyFields = new ArrayList<SchemaField>();
        for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
            if (!dynamicCopy.matches(sourceField)) continue;
            matchCopyFields.add(dynamicCopy.getTargetField(sourceField));
        }
        List<CopyField> copyFields = this.copyFieldsMap.get(sourceField);
        if (copyFields != null) {
            Iterator<CopyField> it = copyFields.iterator();
            while (it.hasNext()) {
                matchCopyFields.add(it.next().getDestination());
            }
        }
        return matchCopyFields.toArray(new SchemaField[matchCopyFields.size()]);
    }

    public List<CopyField> getCopyFieldsList(String sourceField) {
        ArrayList<CopyField> result = new ArrayList<CopyField>();
        for (DynamicCopy dynamicCopy : this.dynamicCopyFields) {
            if (!dynamicCopy.matches(sourceField)) continue;
            result.add(new CopyField(this.getField(sourceField), dynamicCopy.getTargetField(sourceField), dynamicCopy.maxChars));
        }
        List<CopyField> fixedCopyFields = this.copyFieldsMap.get(sourceField);
        if (fixedCopyFields != null) {
            result.addAll(fixedCopyFields);
        }
        return result;
    }

    public boolean isCopyFieldTarget(SchemaField f) {
        return this.copyFieldTargetCounts.containsKey(f);
    }

    private static boolean isWildCard(String name) {
        return name.startsWith("*") || name.endsWith("*");
    }

    static class DynamicDestCopy
    extends DynamicCopy {
        final DynamicField dynamic;
        final int dtype;
        final String dstr;

        DynamicDestCopy(String source, DynamicField dynamic) {
            this(source, dynamic, 0);
        }

        DynamicDestCopy(String source, DynamicField dynamic, int maxChars) {
            super(source, dynamic.prototype, maxChars);
            this.dynamic = dynamic;
            String dest = dynamic.regex;
            if (dest.startsWith("*")) {
                this.dtype = 2;
                this.dstr = dest.substring(1);
            } else if (dest.endsWith("*")) {
                this.dtype = 1;
                this.dstr = dest.substring(0, dest.length() - 1);
            } else {
                throw new RuntimeException("dynamic copyField destination name must start or end with *");
            }
        }

        @Override
        public SchemaField getTargetField(String sourceField) {
            String dyn = this.type == 1 ? sourceField.substring(this.str.length()) : sourceField.substring(0, sourceField.length() - this.str.length());
            String name = this.dtype == 1 ? this.dstr + dyn : dyn + this.dstr;
            return this.dynamic.makeSchemaField(name);
        }

        @Override
        public String toString() {
            return this.targetField.toString();
        }
    }

    static class DynamicCopy
    extends DynamicReplacement {
        final SchemaField targetField;
        final int maxChars;

        DynamicCopy(String regex, SchemaField targetField) {
            this(regex, targetField, 0);
        }

        DynamicCopy(String regex, SchemaField targetField, int maxChars) {
            super(regex);
            this.targetField = targetField;
            this.maxChars = maxChars;
        }

        public SchemaField getTargetField(String sourceField) {
            return this.targetField;
        }

        public String toString() {
            return this.targetField.toString();
        }
    }

    static final class DynamicField
    extends DynamicReplacement {
        final SchemaField prototype;

        DynamicField(SchemaField prototype) {
            super(prototype.name);
            this.prototype = prototype;
        }

        SchemaField makeSchemaField(String name) {
            return new SchemaField(this.prototype, name);
        }

        public String toString() {
            return this.prototype.toString();
        }
    }

    static abstract class DynamicReplacement
    implements Comparable<DynamicReplacement> {
        static final int STARTS_WITH = 1;
        static final int ENDS_WITH = 2;
        final String regex;
        final int type;
        final String str;

        protected DynamicReplacement(String regex) {
            this.regex = regex;
            if (regex.startsWith("*")) {
                this.type = 2;
                this.str = regex.substring(1);
            } else if (regex.endsWith("*")) {
                this.type = 1;
                this.str = regex.substring(0, regex.length() - 1);
            } else {
                throw new RuntimeException("dynamic field name must start or end with *");
            }
        }

        public boolean matches(String name) {
            if (this.type == 1 && name.startsWith(this.str)) {
                return true;
            }
            return this.type == 2 && name.endsWith(this.str);
        }

        @Override
        public int compareTo(DynamicReplacement other) {
            return other.regex.length() - this.regex.length();
        }
    }

    private static class MultiTermChainBuilder {
        static final KeywordTokenizerFactory keyFactory = new KeywordTokenizerFactory();
        ArrayList<CharFilterFactory> charFilters = null;
        ArrayList<TokenFilterFactory> filters = new ArrayList(2);
        TokenizerFactory tokenizer = keyFactory;

        private MultiTermChainBuilder() {
        }

        public void add(Object current) {
            if (!(current instanceof MultiTermAwareComponent)) {
                return;
            }
            Object newComponent = ((MultiTermAwareComponent)current).getMultiTermComponent();
            if (newComponent instanceof TokenFilterFactory) {
                if (this.filters == null) {
                    this.filters = new ArrayList(2);
                }
                this.filters.add((TokenFilterFactory)newComponent);
            } else if (newComponent instanceof TokenizerFactory) {
                this.tokenizer = (TokenizerFactory)newComponent;
            } else if (newComponent instanceof CharFilterFactory) {
                if (this.charFilters == null) {
                    this.charFilters = new ArrayList(1);
                }
                this.charFilters.add((CharFilterFactory)newComponent);
            } else {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown analysis component from MultiTermAwareComponent: " + newComponent);
            }
        }

        public TokenizerChain build() {
            CharFilterFactory[] charFilterArr = this.charFilters == null ? null : this.charFilters.toArray(new CharFilterFactory[this.charFilters.size()]);
            TokenFilterFactory[] filterArr = this.filters == null ? new TokenFilterFactory[]{} : this.filters.toArray(new TokenFilterFactory[this.filters.size()]);
            return new TokenizerChain(charFilterArr, this.tokenizer, filterArr);
        }

        static {
            keyFactory.init((Map)new HashMap());
        }
    }

    private class SolrQueryAnalyzer
    extends SolrIndexAnalyzer {
        private SolrQueryAnalyzer() {
        }

        @Override
        protected HashMap<String, Analyzer> analyzerCache() {
            HashMap<String, Analyzer> cache = new HashMap<String, Analyzer>();
            for (SchemaField f : IndexSchema.this.getFields().values()) {
                Analyzer analyzer = f.getType().getQueryAnalyzer();
                cache.put(f.getName(), analyzer);
            }
            return cache;
        }

        @Override
        protected Analyzer getAnalyzer(String fieldName) {
            Analyzer analyzer = (Analyzer)this.analyzers.get(fieldName);
            return analyzer != null ? analyzer : IndexSchema.this.getDynamicFieldType(fieldName).getQueryAnalyzer();
        }
    }

    private class SolrIndexAnalyzer
    extends Analyzer {
        protected final HashMap<String, Analyzer> analyzers = this.analyzerCache();

        SolrIndexAnalyzer() {
        }

        protected HashMap<String, Analyzer> analyzerCache() {
            HashMap<String, Analyzer> cache = new HashMap<String, Analyzer>();
            for (SchemaField f : IndexSchema.this.getFields().values()) {
                Analyzer analyzer = f.getType().getAnalyzer();
                cache.put(f.getName(), analyzer);
            }
            return cache;
        }

        protected Analyzer getAnalyzer(String fieldName) {
            Analyzer analyzer = this.analyzers.get(fieldName);
            return analyzer != null ? analyzer : IndexSchema.this.getDynamicFieldType(fieldName).getAnalyzer();
        }

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return this.getAnalyzer(fieldName).tokenStream(fieldName, reader);
        }

        public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
            return this.getAnalyzer(fieldName).reusableTokenStream(fieldName, reader);
        }

        public int getPositionIncrementGap(String fieldName) {
            return this.getAnalyzer(fieldName).getPositionIncrementGap(fieldName);
        }
    }
}

