/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class RandomSortField
extends FieldType {
    private static FieldComparatorSource randomComparatorSource = new FieldComparatorSource(){

        public FieldComparator<Integer> newComparator(final String fieldname, final int numHits, int sortPos, boolean reversed) throws IOException {
            return new FieldComparator<Integer>(){
                int seed;
                private final int[] values;
                int bottomVal;
                {
                    this.values = new int[numHits];
                }

                public int compare(int slot1, int slot2) {
                    return this.values[slot1] - this.values[slot2];
                }

                public void setBottom(int slot) {
                    this.bottomVal = this.values[slot];
                }

                public int compareBottom(int doc) throws IOException {
                    return this.bottomVal - RandomSortField.hash(doc + this.seed);
                }

                public void copy(int slot, int doc) throws IOException {
                    this.values[slot] = RandomSortField.hash(doc + this.seed);
                }

                public void setNextReader(IndexReader reader, int docBase) throws IOException {
                    this.seed = RandomSortField.getSeed(fieldname, reader);
                }

                public Integer value(int slot) {
                    return this.values[slot];
                }
            };
        }
    };

    private static int hash(int key) {
        key = ~key + (key << 15);
        key ^= key >>> 12;
        key += key << 2;
        key ^= key >>> 4;
        key *= 2057;
        key ^= key >>> 16;
        return key >>> 1;
    }

    private static int getSeed(String fieldName, IndexReader r) {
        SolrIndexReader top = (SolrIndexReader)r;
        int base = 0;
        while (top.getParent() != null) {
            base += top.getBase();
            top = top.getParent();
        }
        return fieldName.hashCode() + base + (int)top.getVersion();
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return new SortField(field.getName(), randomComparatorSource, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        return new RandomValueSource(field.getName());
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
    }

    public class RandomValueSource
    extends ValueSource {
        private final String field;

        public RandomValueSource(String field) {
            this.field = field;
        }

        @Override
        public String description() {
            return this.field;
        }

        @Override
        public DocValues getValues(Map context, final IndexReader reader) throws IOException {
            return new DocValues(){
                private final int seed;
                {
                    this.seed = RandomSortField.getSeed(RandomValueSource.this.field, reader);
                }

                @Override
                public float floatVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }

                @Override
                public int intVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }

                @Override
                public long longVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }

                @Override
                public double doubleVal(int doc) {
                    return RandomSortField.hash(doc + this.seed);
                }

                @Override
                public String strVal(int doc) {
                    return Integer.toString(RandomSortField.hash(doc + this.seed));
                }

                @Override
                public String toString(int doc) {
                    return RandomValueSource.this.description() + '=' + this.intVal(doc);
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof RandomValueSource)) {
                return false;
            }
            RandomValueSource other = (RandomValueSource)o;
            return this.field.equals(other.field);
        }

        @Override
        public int hashCode() {
            return this.field.hashCode();
        }
    }
}

