/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.StringIndexDocValues;
import org.apache.solr.util.NumberUtils;

class SortableDoubleFieldSource
extends FieldCacheSource {
    protected double defVal;
    private static int hcode = SortableDoubleFieldSource.class.hashCode();

    public SortableDoubleFieldSource(String field) {
        this(field, 0.0);
    }

    public SortableDoubleFieldSource(String field, double defVal) {
        super(field);
        this.defVal = defVal;
    }

    @Override
    public String description() {
        return "sdouble(" + this.field + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final double def = this.defVal;
        return new StringIndexDocValues(this, reader, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return NumberUtils.double2sortableStr(readableValue);
            }

            @Override
            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.doubleVal(doc);
            }

            @Override
            public long longVal(int doc) {
                return (long)this.doubleVal(doc);
            }

            @Override
            public double doubleVal(int doc) {
                int ord = this.order[doc];
                return ord == 0 ? def : NumberUtils.SortableStr2double(this.lookup[ord]);
            }

            @Override
            public String strVal(int doc) {
                return Double.toString(this.doubleVal(doc));
            }

            @Override
            public String toString(int doc) {
                return SortableDoubleFieldSource.this.description() + '=' + this.doubleVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SortableDoubleFieldSource && super.equals(o) && this.defVal == ((SortableDoubleFieldSource)o).defVal;
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.defVal);
        int ibits = (int)(bits ^ bits >>> 32);
        return hcode + super.hashCode() + ibits;
    }
}

