/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.StringIndexDocValues;
import org.apache.solr.util.NumberUtils;

class SortableLongFieldSource
extends FieldCacheSource {
    protected long defVal;
    private static int hcode = SortableLongFieldSource.class.hashCode();

    public SortableLongFieldSource(String field) {
        this(field, 0L);
    }

    public SortableLongFieldSource(String field, long defVal) {
        super(field);
        this.defVal = defVal;
    }

    @Override
    public String description() {
        return "slong(" + this.field + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        final long def = this.defVal;
        return new StringIndexDocValues(this, reader, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return NumberUtils.long2sortableStr(readableValue);
            }

            @Override
            public float floatVal(int doc) {
                return this.longVal(doc);
            }

            @Override
            public int intVal(int doc) {
                return (int)this.longVal(doc);
            }

            @Override
            public long longVal(int doc) {
                int ord = this.order[doc];
                return ord == 0 ? def : NumberUtils.SortableStr2long(this.lookup[ord], 0, 5);
            }

            @Override
            public double doubleVal(int doc) {
                return this.longVal(doc);
            }

            @Override
            public String strVal(int doc) {
                return Long.toString(this.longVal(doc));
            }

            @Override
            public String toString(int doc) {
                return SortableLongFieldSource.this.description() + '=' + this.longVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof SortableLongFieldSource && super.equals(o) && this.defVal == ((SortableLongFieldSource)o).defVal;
    }

    @Override
    public int hashCode() {
        return hcode + super.hashCode() + (int)this.defVal;
    }
}

