/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetIterator;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBase;

public class BitDocSet
extends DocSetBase {
    final OpenBitSet bits;
    int size;

    public BitDocSet() {
        this.bits = new OpenBitSet();
    }

    public BitDocSet(OpenBitSet bits) {
        this.bits = bits;
        this.size = -1;
    }

    public BitDocSet(OpenBitSet bits, int size) {
        this.bits = bits;
        this.size = size;
    }

    @Override
    public DocIterator iterator() {
        return new DocIterator(){
            private final OpenBitSetIterator iter;
            private int pos;
            {
                this.iter = new OpenBitSetIterator(BitDocSet.this.bits);
                this.pos = this.iter.nextDoc();
            }

            @Override
            public boolean hasNext() {
                return this.pos != Integer.MAX_VALUE;
            }

            @Override
            public Integer next() {
                return this.nextDoc();
            }

            @Override
            public void remove() {
                BitDocSet.this.bits.clear((long)this.pos);
            }

            @Override
            public int nextDoc() {
                int old = this.pos;
                this.pos = this.iter.nextDoc();
                return old;
            }

            @Override
            public float score() {
                return 0.0f;
            }
        };
    }

    @Override
    public OpenBitSet getBits() {
        return this.bits;
    }

    @Override
    public void add(int doc) {
        this.bits.set((long)doc);
        this.size = -1;
    }

    @Override
    public void addUnique(int doc) {
        this.bits.set((long)doc);
        this.size = -1;
    }

    @Override
    public int size() {
        if (this.size != -1) {
            return this.size;
        }
        this.size = (int)this.bits.cardinality();
        return this.size;
    }

    public void invalidateSize() {
        this.size = -1;
    }

    @Override
    public boolean exists(int doc) {
        return this.bits.get(doc);
    }

    @Override
    public int intersectionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.intersectionCount((OpenBitSet)this.bits, (OpenBitSet)((BitDocSet)other).bits);
        }
        return other.intersectionSize(this);
    }

    @Override
    public int unionSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.unionCount((OpenBitSet)this.bits, (OpenBitSet)((BitDocSet)other).bits);
        }
        return other.unionSize(this);
    }

    @Override
    public int andNotSize(DocSet other) {
        if (other instanceof BitDocSet) {
            return (int)OpenBitSet.andNotCount((OpenBitSet)this.bits, (OpenBitSet)((BitDocSet)other).bits);
        }
        return super.andNotSize(other);
    }

    @Override
    public DocSet andNot(DocSet other) {
        OpenBitSet newbits = (OpenBitSet)this.bits.clone();
        if (other instanceof BitDocSet) {
            newbits.andNot(((BitDocSet)other).bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                newbits.clear((long)iter.nextDoc());
            }
        }
        return new BitDocSet(newbits);
    }

    @Override
    public DocSet union(DocSet other) {
        OpenBitSet newbits = (OpenBitSet)this.bits.clone();
        if (other instanceof BitDocSet) {
            newbits.union(((BitDocSet)other).bits);
        } else {
            DocIterator iter = other.iterator();
            while (iter.hasNext()) {
                newbits.set((long)iter.nextDoc());
            }
        }
        return new BitDocSet(newbits);
    }

    @Override
    public long memSize() {
        return (this.bits.getBits().length << 3) + 16;
    }
}

