/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.DocSetBase;
import org.apache.solr.search.HashDocSet;
import org.apache.solr.search.SortedIntDocSet;

public class DocSlice
extends DocSetBase
implements DocList {
    final int offset;
    final int len;
    final int[] docs;
    final float[] scores;
    final int matches;
    final float maxScore;

    public DocSlice(int offset, int len, int[] docs, float[] scores, int matches, float maxScore) {
        this.offset = offset;
        this.len = len;
        this.docs = docs;
        this.scores = scores;
        this.matches = matches;
        this.maxScore = maxScore;
    }

    @Override
    public DocList subset(int offset, int len) {
        if (this.offset == offset && this.len == len) {
            return this;
        }
        int requestedEnd = offset + len;
        if (requestedEnd > this.docs.length && this.matches > this.docs.length) {
            return null;
        }
        int realEndDoc = Math.min(requestedEnd, this.docs.length);
        int realLen = Math.max(realEndDoc - offset, 0);
        if (this.offset == offset && this.len == realLen) {
            return this;
        }
        return new DocSlice(offset, realLen, this.docs, this.scores, this.matches, this.maxScore);
    }

    @Override
    public boolean hasScores() {
        return this.scores != null;
    }

    @Override
    public float maxScore() {
        return this.maxScore;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public int matches() {
        return this.matches;
    }

    @Override
    public long memSize() {
        return (this.docs.length << 2) + (this.scores == null ? 0 : this.scores.length << 2) + 24;
    }

    @Override
    public boolean exists(int doc) {
        int end = this.offset + this.len;
        for (int i = this.offset; i < end; ++i) {
            if (this.docs[i] != doc) continue;
            return true;
        }
        return false;
    }

    @Override
    public DocIterator iterator() {
        return new DocIterator(){
            int pos;
            final int end;
            {
                this.pos = DocSlice.this.offset;
                this.end = DocSlice.this.offset + DocSlice.this.len;
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.end;
            }

            @Override
            public Integer next() {
                return this.nextDoc();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The remove  operation is not supported by this Iterator.");
            }

            @Override
            public int nextDoc() {
                return DocSlice.this.docs[this.pos++];
            }

            @Override
            public float score() {
                return DocSlice.this.scores[this.pos - 1];
            }
        };
    }

    @Override
    public DocSet intersection(DocSet other) {
        if (other instanceof SortedIntDocSet || other instanceof HashDocSet) {
            return other.intersection(this);
        }
        HashDocSet h = new HashDocSet(this.docs, this.offset, this.len);
        return h.intersection(other);
    }

    @Override
    public int intersectionSize(DocSet other) {
        if (other instanceof SortedIntDocSet || other instanceof HashDocSet) {
            return other.intersectionSize(this);
        }
        HashDocSet h = new HashDocSet(this.docs, this.offset, this.len);
        return h.intersectionSize(other);
    }
}

