/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.DisMaxParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.ExtendedAnalyzer;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.QueryUtils;
import org.apache.solr.search.SolrQueryParser;
import org.apache.solr.search.function.BoostedQuery;
import org.apache.solr.search.function.FunctionQuery;
import org.apache.solr.search.function.ProductFloatFunction;
import org.apache.solr.search.function.QueryValueSource;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.util.SolrPluginUtils;

class ExtendedDismaxQParser
extends QParser {
    private static String IMPOSSIBLE_FIELD_NAME = "\ufffc\ufffc\ufffc";
    private Map<String, Float> queryFields;
    private UserFields userFields;
    private Query parsedUserQuery;
    private String[] boostParams;
    private String[] multBoosts;
    private List<Query> boostQueries;
    private Query altUserQuery;
    private QParser altQParser;
    private SolrParams solrParams;
    static final RuntimeException unknownField = new RuntimeException("UnknownField");

    public ExtendedDismaxQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Query parse() throws ParseException {
        void var14_23;
        String[] boostFuncs;
        SolrParams localParams = this.getLocalParams();
        SolrParams params = this.getParams();
        this.solrParams = SolrParams.wrapDefaults((SolrParams)localParams, (SolrParams)params);
        String minShouldMatch = this.solrParams.get("mm", "100%");
        this.userFields = new UserFields(U.parseFieldBoosts(this.solrParams.getParams("uf")));
        this.queryFields = SolrPluginUtils.parseFieldBoosts(this.solrParams.getParams("qf"));
        if (0 == this.queryFields.size()) {
            this.queryFields.put(this.req.getSchema().getDefaultSearchFieldName(), Float.valueOf(1.0f));
        }
        Map<String, Float> phraseFields = SolrPluginUtils.parseFieldBoosts(this.solrParams.getParams("pf"));
        Map<String, Float> phraseFields2 = SolrPluginUtils.parseFieldBoosts(this.solrParams.getParams("pf2"));
        Map<String, Float> phraseFields3 = SolrPluginUtils.parseFieldBoosts(this.solrParams.getParams("pf3"));
        float tiebreaker = this.solrParams.getFloat("tie", 0.0f);
        int pslop = this.solrParams.getInt("ps", 0);
        int qslop = this.solrParams.getInt("qs", 0);
        boolean stopwords = this.solrParams.getBool("stopwords", true);
        BooleanQuery query = new BooleanQuery(true);
        this.parsedUserQuery = null;
        String userQuery = this.getString();
        this.altUserQuery = null;
        if (userQuery == null || userQuery.trim().length() == 0) {
            String altQ = this.solrParams.get("q.alt");
            if (altQ == null) return null;
            this.altQParser = this.subQuery(altQ, null);
            this.altUserQuery = this.altQParser.getQuery();
            query.add(this.altUserQuery, BooleanClause.Occur.MUST);
        } else {
            String s;
            boolean lowercaseOperators = this.solrParams.getBool("lowercaseOperators", true);
            String string = userQuery;
            ExtendedSolrQueryParser up = new ExtendedSolrQueryParser(this, IMPOSSIBLE_FIELD_NAME);
            up.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, this.queryFields);
            this.addAliasesFromRequest(up, tiebreaker);
            up.setPhraseSlop(qslop);
            up.setAllowLeadingWildcard(true);
            List<Clause> clauses = null;
            int numPluses = 0;
            int numMinuses = 0;
            int numOR = 0;
            int numNOT = 0;
            clauses = this.splitIntoClauses(userQuery, false);
            for (Clause clause : clauses) {
                if (clause.must == '+') {
                    ++numPluses;
                }
                if (clause.must == '-') {
                    ++numMinuses;
                }
                if (!clause.isBareWord()) continue;
                String s2 = clause.val;
                if ("OR".equals(s2)) {
                    ++numOR;
                    continue;
                }
                if ("NOT".equals(s2)) {
                    ++numNOT;
                    continue;
                }
                if (!lowercaseOperators || !"or".equals(s2)) continue;
                ++numOR;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < clauses.size(); ++i) {
                Clause clause = clauses.get(i);
                String s3 = clause.raw;
                if (i > 0 && i + 1 < clauses.size()) {
                    if ("AND".equalsIgnoreCase(s3)) {
                        s3 = "AND";
                    } else if ("OR".equalsIgnoreCase(s3)) {
                        s3 = "OR";
                    }
                }
                sb.append(s3);
                sb.append(' ');
            }
            String string2 = sb.toString();
            boolean doMinMatched = numOR + numNOT + numPluses + numMinuses == 0;
            up.minShouldMatch = minShouldMatch;
            try {
                up.setRemoveStopFilter(!stopwords);
                up.exceptions = true;
                this.parsedUserQuery = up.parse(string2);
                if (stopwords && ExtendedDismaxQParser.isEmpty(this.parsedUserQuery)) {
                    up.setRemoveStopFilter(true);
                    this.parsedUserQuery = up.parse(string2);
                }
            }
            catch (Exception e) {
                up.exceptions = false;
            }
            if (this.parsedUserQuery != null && doMinMatched && this.parsedUserQuery instanceof BooleanQuery) {
                SolrPluginUtils.setMinShouldMatch((BooleanQuery)this.parsedUserQuery, minShouldMatch);
            }
            if (this.parsedUserQuery == null) {
                sb = new StringBuilder();
                for (Clause clause : clauses) {
                    Float boost;
                    boolean doQuote = clause.isPhrase;
                    s = clause.val;
                    if (!clause.isPhrase && ("OR".equals(s) || "AND".equals(s) || "NOT".equals(s))) {
                        doQuote = true;
                    }
                    if (clause.must != '\u0000') {
                        sb.append(clause.must);
                    }
                    if (clause.field != null) {
                        sb.append(clause.field);
                        sb.append(':');
                    }
                    if (doQuote) {
                        sb.append('\"');
                    }
                    sb.append(clause.val);
                    if (doQuote) {
                        sb.append('\"');
                    }
                    if (clause.field != null && (boost = this.userFields.getBoost(clause.field)) != null) {
                        sb.append("^").append(boost);
                    }
                    sb.append(' ');
                }
                String escapedUserQuery = sb.toString();
                this.parsedUserQuery = up.parse(escapedUserQuery);
                if (this.parsedUserQuery instanceof BooleanQuery) {
                    BooleanQuery t = new BooleanQuery();
                    SolrPluginUtils.flattenBooleanQuery(t, (BooleanQuery)this.parsedUserQuery);
                    SolrPluginUtils.setMinShouldMatch(t, minShouldMatch);
                    this.parsedUserQuery = t;
                }
            }
            query.add(this.parsedUserQuery, BooleanClause.Occur.MUST);
            if (phraseFields.size() > 0 || phraseFields2.size() > 0 || phraseFields3.size() > 0) {
                ArrayList<Clause> normalClauses = new ArrayList<Clause>(clauses.size());
                for (Clause clause : clauses) {
                    if (clause.field != null || clause.isPhrase || clause.isBareWord() && ("OR".equals(s = clause.val.toString()) || "AND".equals(s) || "NOT".equals(s) || "TO".equals(s))) continue;
                    normalClauses.add(clause);
                }
                this.addShingledPhraseQueries(query, normalClauses, phraseFields, 0, tiebreaker, pslop);
                this.addShingledPhraseQueries(query, normalClauses, phraseFields2, 2, tiebreaker, pslop);
                this.addShingledPhraseQueries(query, normalClauses, phraseFields3, 3, tiebreaker, pslop);
            }
        }
        this.boostParams = this.solrParams.getParams("bq");
        this.boostQueries = null;
        if (this.boostParams != null && this.boostParams.length > 0) {
            this.boostQueries = new ArrayList<Query>();
            for (String qs : this.boostParams) {
                if (qs.trim().length() == 0) continue;
                Query q = this.subQuery(qs, null).getQuery();
                this.boostQueries.add(q);
            }
        }
        if (null != this.boostQueries) {
            for (Query query2 : this.boostQueries) {
                query.add(query2, BooleanClause.Occur.SHOULD);
            }
        }
        if (null != (boostFuncs = this.solrParams.getParams("bf")) && 0 != boostFuncs.length) {
            for (String boostFunc : boostFuncs) {
                if (null == boostFunc || "".equals(boostFunc)) continue;
                Map<String, Float> ff = SolrPluginUtils.parseFieldBoosts(boostFunc);
                for (String f : ff.keySet()) {
                    Query fq = this.subQuery(f, FunctionQParserPlugin.NAME).getQuery();
                    Float b = ff.get(f);
                    if (null != b) {
                        fq.setBoost(b.floatValue());
                    }
                    query.add(fq, BooleanClause.Occur.SHOULD);
                }
            }
        }
        BooleanQuery booleanQuery = query;
        this.multBoosts = this.solrParams.getParams("boost");
        if (this.multBoosts == null || this.multBoosts.length <= 0) return var14_23;
        ArrayList<ValueSource> boosts = new ArrayList<ValueSource>();
        for (String boostStr : this.multBoosts) {
            if (boostStr == null || boostStr.length() == 0) continue;
            Query boost = this.subQuery(boostStr, FunctionQParserPlugin.NAME).getQuery();
            ValueSource vs = boost instanceof FunctionQuery ? ((FunctionQuery)boost).getValueSource() : new QueryValueSource(boost, 1.0f);
            boosts.add(vs);
        }
        if (boosts.size() > 1) {
            ProductFloatFunction prod = new ProductFloatFunction(boosts.toArray(new ValueSource[boosts.size()]));
            BoostedQuery boostedQuery = new BoostedQuery((Query)query, prod);
            return var14_23;
        } else {
            if (boosts.size() != 1) return var14_23;
            BoostedQuery boostedQuery = new BoostedQuery((Query)query, (ValueSource)boosts.get(0));
        }
        return var14_23;
    }

    private void addAliasesFromRequest(ExtendedSolrQueryParser up, float tiebreaker) throws ParseException {
        Iterator it = this.solrParams.getParameterNamesIterator();
        while (it.hasNext()) {
            String param = (String)it.next();
            if (!param.startsWith("f.") || !param.endsWith(".qf")) continue;
            String fname = param.substring(2, param.length() - 3);
            String qfReplacement = this.solrParams.get(param);
            Map<String, Float> parsedQf = SolrPluginUtils.parseFieldBoosts(qfReplacement);
            if (parsedQf.size() == 0) {
                return;
            }
            up.addAlias(fname, tiebreaker, parsedQf);
        }
    }

    private void addShingledPhraseQueries(BooleanQuery mainQuery, List<Clause> clauses, Map<String, Float> fields, int shingleSize, float tiebreaker, int slop) throws ParseException {
        if (null == fields || fields.isEmpty() || null == clauses || clauses.size() <= shingleSize) {
            return;
        }
        if (0 == shingleSize) {
            shingleSize = clauses.size();
        }
        int goat = shingleSize - 1;
        StringBuilder userPhraseQuery = new StringBuilder();
        for (int i = 0; i < clauses.size() - goat; ++i) {
            userPhraseQuery.append('\"');
            for (int j = 0; j <= goat; ++j) {
                userPhraseQuery.append(clauses.get((int)(i + j)).val);
                userPhraseQuery.append(' ');
            }
            userPhraseQuery.append('\"');
            userPhraseQuery.append(' ');
        }
        ExtendedSolrQueryParser pp = new ExtendedSolrQueryParser(this, IMPOSSIBLE_FIELD_NAME);
        pp.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, fields);
        pp.setPhraseSlop(slop);
        pp.setRemoveStopFilter(true);
        pp.makeDismax = true;
        pp.minClauseSize = 2;
        Query phrase = pp.parse(userPhraseQuery.toString());
        if (phrase != null) {
            mainQuery.add(phrase, BooleanClause.Occur.SHOULD);
        }
    }

    @Override
    public String[] getDefaultHighlightFields() {
        String[] highFields = this.queryFields.keySet().toArray(new String[0]);
        return highFields;
    }

    @Override
    public Query getHighlightQuery() throws ParseException {
        return this.parsedUserQuery;
    }

    @Override
    public void addDebugInfo(NamedList<Object> debugInfo) {
        super.addDebugInfo(debugInfo);
        debugInfo.add("altquerystring", (Object)this.altUserQuery);
        if (null != this.boostQueries) {
            debugInfo.add("boost_queries", (Object)this.boostParams);
            debugInfo.add("parsed_boost_queries", QueryParsing.toString(this.boostQueries, this.getReq().getSchema()));
        }
        debugInfo.add("boostfuncs", (Object)this.getReq().getParams().getParams("bf"));
    }

    public static CharSequence partialEscape(CharSequence s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ':') {
                char ch;
                if (i + 1 < len && i > 0 && !Character.isWhitespace(ch = s.charAt(i + 1)) && ch != '+' && ch != '-' && ch != ':') {
                    int start;
                    for (start = i - 1; start >= 0 && !Character.isWhitespace(ch = s.charAt(start)); --start) {
                    }
                    int pos = start + 1;
                    ch = s.charAt(pos);
                    if (ch == '+' || ch == '-') {
                        // empty if block
                    }
                    int n = ++pos;
                    ++pos;
                    ch = s.charAt(n);
                    if (Character.isJavaIdentifierPart(ch)) {
                        while (Character.isJavaIdentifierPart(ch = s.charAt(pos++)) || ch == '-' || ch == '.') {
                        }
                        if (pos <= i) {
                            sb.append(':');
                            continue;
                        }
                    }
                }
                sb.append('\\');
            } else if (c == '\\' || c == '!' || c == '(' || c == ')' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb;
    }

    public List<Clause> splitIntoClauses(String s, boolean ignoreQuote) {
        ArrayList<Clause> lst = new ArrayList<Clause>(4);
        int pos = 0;
        int end = s.length();
        char ch = '\u0000';
        while (pos < end) {
            Clause clause = new Clause();
            boolean disallowUserField = true;
            ch = s.charAt(pos);
            while (Character.isWhitespace(ch) && ++pos < end) {
                ch = s.charAt(pos);
            }
            int start = pos;
            if (ch == '+' || ch == '-') {
                clause.must = ch;
                ++pos;
            }
            clause.field = this.getFieldName(s, pos, end);
            if (clause.field != null && !this.userFields.isAllowed(clause.field)) {
                clause.field = null;
            }
            if (clause.field != null) {
                disallowUserField = false;
                pos += clause.field.length();
                ++pos;
            }
            if (pos >= end) break;
            char inString = '\u0000';
            ch = s.charAt(pos);
            if (!ignoreQuote && ch == '\"') {
                clause.isPhrase = true;
                inString = '\"';
                ++pos;
            }
            StringBuilder sb = new StringBuilder();
            while (pos < end) {
                if ((ch = s.charAt(pos++)) == '\\') {
                    sb.append(ch);
                    if (pos >= end) {
                        sb.append(ch);
                        break;
                    }
                    ch = s.charAt(pos++);
                    sb.append(ch);
                    continue;
                }
                if (inString != '\u0000' && ch == inString) {
                    inString = '\u0000';
                    break;
                }
                if (Character.isWhitespace(ch)) {
                    clause.hasWhitespace = true;
                    if (inString == '\u0000') {
                        --pos;
                        break;
                    }
                }
                if (inString == '\u0000') {
                    switch (ch) {
                        case '!': 
                        case '\"': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case ':': 
                        case '?': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '}': 
                        case '~': {
                            clause.hasSpecialSyntax = true;
                            sb.append('\\');
                        }
                    }
                } else if (ch == '\"') {
                    sb.append('\\');
                }
                sb.append(ch);
            }
            clause.val = sb.toString();
            if (clause.isPhrase) {
                if (inString != '\u0000') {
                    return this.splitIntoClauses(s, true);
                }
                clause.hasSpecialSyntax = false;
            } else if (clause.val.length() == 0) {
                clause.syntaxError = true;
                if (clause.must != '\u0000') {
                    clause.val = "\\" + clause.must;
                    clause.must = '\u0000';
                    clause.hasSpecialSyntax = true;
                } else {
                    clause = null;
                }
            }
            if (clause == null) continue;
            if (disallowUserField) {
                clause.raw = s.substring(start, pos);
                if (!"*:*".equals(clause.raw)) {
                    clause.raw = clause.raw.replaceAll(":", "\\\\:");
                }
            } else {
                Float boost;
                clause.raw = s.substring(start, pos);
                if (this.userFields.isAllowed(clause.field) && !clause.raw.contains("^") && (boost = this.userFields.getBoost(clause.field)) != null) {
                    clause.raw = clause.raw + "^" + boost;
                }
            }
            lst.add(clause);
        }
        return lst;
    }

    public String getFieldName(String s, int pos, int end) {
        char ch;
        if (pos >= end) {
            return null;
        }
        int p = pos;
        int colon = s.indexOf(58, pos);
        if (colon <= pos || colon + 1 >= end || Character.isWhitespace(s.charAt(colon + 1))) {
            return null;
        }
        if (!Character.isJavaIdentifierPart(ch = s.charAt(p++))) {
            return null;
        }
        while (p < colon) {
            if (Character.isJavaIdentifierPart(ch = s.charAt(p++)) || ch == '-' || ch == '.') continue;
            return null;
        }
        String fname = s.substring(pos, p);
        boolean isInSchema = this.getReq().getSchema().getFieldTypeNoEx(fname) != null;
        boolean isAlias = this.solrParams.get("f." + fname + ".qf") != null;
        boolean isMagic = null != SolrQueryParser.MagicFieldName.get(fname);
        return isInSchema || isAlias || isMagic ? fname : null;
    }

    public static List<String> split(String s, boolean ignoreQuote) {
        ArrayList<String> lst = new ArrayList<String>(4);
        int pos = 0;
        int start = 0;
        int end = s.length();
        char inString = '\u0000';
        char ch = '\u0000';
        while (pos < end) {
            char prevChar = ch;
            if ((ch = s.charAt(pos++)) == '\\') {
                ++pos;
                continue;
            }
            if (inString != '\u0000' && ch == inString) {
                inString = '\u0000';
                continue;
            }
            if (!ignoreQuote && ch == '\"') {
                if (Character.isLetterOrDigit(prevChar)) continue;
                inString = ch;
                continue;
            }
            if (!Character.isWhitespace(ch) || inString != '\u0000') continue;
            lst.add(s.substring(start, pos - 1));
            start = pos;
        }
        if (start < end) {
            lst.add(s.substring(start, end));
        }
        if (inString != '\u0000') {
            return ExtendedDismaxQParser.split(s, true);
        }
        return lst;
    }

    static boolean isEmpty(Query q) {
        if (q == null) {
            return true;
        }
        return q instanceof BooleanQuery && ((BooleanQuery)q).clauses().size() == 0;
    }

    static {
        unknownField.fillInStackTrace();
    }

    static class DynamicField
    implements Comparable<DynamicField> {
        static final int STARTS_WITH = 1;
        static final int ENDS_WITH = 2;
        static final int CATCHALL = 3;
        final String wildcard;
        final int type;
        final String str;

        protected DynamicField(String wildcard) {
            this.wildcard = wildcard;
            if (wildcard.equals("*")) {
                this.type = 3;
                this.str = null;
            } else if (wildcard.startsWith("*")) {
                this.type = 2;
                this.str = wildcard.substring(1);
            } else if (wildcard.endsWith("*")) {
                this.type = 1;
                this.str = wildcard.substring(0, wildcard.length() - 1);
            } else {
                throw new RuntimeException("dynamic field name must start or end with *");
            }
        }

        public boolean matches(String name) {
            if (this.type == 3) {
                return true;
            }
            if (this.type == 1 && name.startsWith(this.str)) {
                return true;
            }
            return this.type == 2 && name.endsWith(this.str);
        }

        @Override
        public int compareTo(DynamicField other) {
            return other.wildcard.length() - this.wildcard.length();
        }

        public String toString() {
            return this.wildcard;
        }
    }

    static class UserFields {
        private Map<String, Float> userFieldsMap;
        private DynamicField[] dynamicUserFields;
        private DynamicField[] negativeDynamicUserFields;

        UserFields(Map<String, Float> ufm) {
            this.userFieldsMap = ufm;
            if (0 == this.userFieldsMap.size()) {
                this.userFieldsMap.put("*", null);
            }
            ArrayList<DynamicField> dynUserFields = new ArrayList<DynamicField>();
            ArrayList<DynamicField> negDynUserFields = new ArrayList<DynamicField>();
            for (String f : this.userFieldsMap.keySet()) {
                if (!f.contains("*")) continue;
                if (f.startsWith("-")) {
                    negDynUserFields.add(new DynamicField(f.substring(1)));
                    continue;
                }
                dynUserFields.add(new DynamicField(f));
            }
            Collections.sort(dynUserFields);
            this.dynamicUserFields = dynUserFields.toArray(new DynamicField[dynUserFields.size()]);
            Collections.sort(negDynUserFields);
            this.negativeDynamicUserFields = negDynUserFields.toArray(new DynamicField[negDynUserFields.size()]);
        }

        public boolean isAllowed(String fname) {
            boolean res = (this.userFieldsMap.containsKey(fname) || this.isDynField(fname, false)) && !this.userFieldsMap.containsKey("-" + fname) && !this.isDynField(fname, true);
            return res;
        }

        private boolean isDynField(String field, boolean neg) {
            return this.getDynFieldForName(field, neg) != null;
        }

        private String getDynFieldForName(String f, boolean neg) {
            for (DynamicField df : neg ? this.negativeDynamicUserFields : this.dynamicUserFields) {
                if (!df.matches(f)) continue;
                return df.wildcard;
            }
            return null;
        }

        public Float getBoost(String field) {
            return this.userFieldsMap.containsKey(field) ? this.userFieldsMap.get(field) : this.userFieldsMap.get(this.getDynFieldForName(field, false));
        }
    }

    class ExtendedSolrQueryParser
    extends SolrQueryParser {
        boolean makeDismax;
        boolean disableCoord;
        boolean allowWildcard;
        int minClauseSize;
        boolean exceptions;
        String minShouldMatch;
        ExtendedAnalyzer analyzer;
        protected Map<String, Alias> aliases;
        QType type;
        String field;
        String val;
        String val2;
        boolean bool;
        float flt;
        int slop;

        public ExtendedSolrQueryParser(QParser parser, String defaultField) {
            super(parser, defaultField, new ExtendedAnalyzer(parser));
            this.makeDismax = true;
            this.disableCoord = true;
            this.allowWildcard = true;
            this.minClauseSize = 0;
            this.aliases = new HashMap<String, Alias>(3);
            this.analyzer = (ExtendedAnalyzer)this.getAnalyzer();
            this.setDefaultOperator(QueryParser.Operator.OR);
        }

        public void setRemoveStopFilter(boolean remove) {
            this.analyzer.removeStopFilter = remove;
        }

        protected Query getBooleanQuery(List clauses, boolean disableCoord) throws ParseException {
            Query q = super.getBooleanQuery(clauses, disableCoord);
            if (q != null) {
                q = QueryUtils.makeQueryable(q);
            }
            return q;
        }

        protected void addClause(List clauses, int conj, int mods, Query q) {
            super.addClause(clauses, conj, mods, q);
        }

        public void addAlias(String field, float tiebreaker, Map<String, Float> fieldBoosts) {
            Alias a = new Alias();
            a.tie = tiebreaker;
            a.fields = fieldBoosts;
            this.aliases.put(field, a);
        }

        public Alias getAlias(String field) {
            return this.aliases.get(field);
        }

        @Override
        protected Query getFieldQuery(String field, String val, boolean quoted) throws ParseException {
            this.type = QType.FIELD;
            this.field = field;
            this.val = val;
            this.slop = this.getPhraseSlop();
            return this.getAliasedQuery();
        }

        protected Query getFieldQuery(String field, String val, int slop) throws ParseException {
            this.type = QType.PHRASE;
            this.field = field;
            this.val = val;
            this.slop = slop;
            return this.getAliasedQuery();
        }

        @Override
        protected Query getPrefixQuery(String field, String val) throws ParseException {
            if (val.equals("") && field.equals("*")) {
                return new MatchAllDocsQuery();
            }
            this.type = QType.PREFIX;
            this.field = field;
            this.val = val;
            return this.getAliasedQuery();
        }

        @Override
        protected Query getRangeQuery(String field, String a, String b, boolean inclusive) throws ParseException {
            this.type = QType.RANGE;
            this.field = field;
            this.val = a;
            this.val2 = b;
            this.bool = inclusive;
            return this.getAliasedQuery();
        }

        @Override
        protected Query getWildcardQuery(String field, String val) throws ParseException {
            if (val.equals("*")) {
                if (field.equals("*")) {
                    return new MatchAllDocsQuery();
                }
                return this.getPrefixQuery(field, "");
            }
            this.type = QType.WILDCARD;
            this.field = field;
            this.val = val;
            return this.getAliasedQuery();
        }

        protected Query getFuzzyQuery(String field, String val, float minSimilarity) throws ParseException {
            this.type = QType.FUZZY;
            this.field = field;
            this.val = val;
            this.flt = minSimilarity;
            return this.getAliasedQuery();
        }

        protected Query getAliasedQuery() throws ParseException {
            FieldType ft;
            Alias a = this.aliases.get(this.field);
            this.validateCyclicAliasing(this.field);
            if (a != null) {
                List<Query> lst = this.getQueries(a);
                if (lst == null || lst.size() == 0) {
                    return this.getQuery();
                }
                if (this.makeDismax) {
                    DisjunctionMaxQuery q = new DisjunctionMaxQuery(lst, a.tie);
                    return q;
                }
                BooleanQuery q = new BooleanQuery(this.disableCoord);
                for (Query sub : lst) {
                    q.add(sub, BooleanClause.Occur.SHOULD);
                }
                return q;
            }
            if (this.exceptions && (ft = this.schema.getFieldTypeNoEx(this.field)) == null && null == SolrQueryParser.MagicFieldName.get(this.field)) {
                throw unknownField;
            }
            return this.getQuery();
        }

        private void validateCyclicAliasing(String field) throws ParseException {
            HashSet<String> set = new HashSet<String>();
            set.add(field);
            if (this.validateField(field, set)) {
                throw new ParseException("Field aliases lead to a cycle");
            }
        }

        private boolean validateField(String field, Set<String> set) {
            if (this.getAlias(field) == null) {
                return false;
            }
            boolean hascycle = false;
            for (String referencedField : this.getAlias((String)field).fields.keySet()) {
                if (!set.add(referencedField)) {
                    hascycle = true;
                    continue;
                }
                if (this.validateField(referencedField, set)) {
                    hascycle = true;
                }
                set.remove(referencedField);
            }
            return hascycle;
        }

        protected List<Query> getQueries(Alias a) throws ParseException {
            if (a == null) {
                return null;
            }
            if (a.fields.size() == 0) {
                return null;
            }
            ArrayList<Query> lst = new ArrayList<Query>(4);
            Iterator<String> i$ = a.fields.keySet().iterator();
            while (i$.hasNext()) {
                String f;
                this.field = f = i$.next();
                Query sub = this.getAliasedQuery();
                if (sub == null) continue;
                Float boost = a.fields.get(f);
                if (boost != null) {
                    sub.setBoost(boost.floatValue());
                }
                lst.add(sub);
            }
            return lst;
        }

        private Query getQuery() throws ParseException {
            try {
                switch (this.type) {
                    case FIELD: 
                    case PHRASE: {
                        PhraseQuery pq;
                        BooleanQuery bq;
                        Query query = super.getFieldQuery(this.field, this.val, this.type == QType.PHRASE);
                        if (query instanceof BooleanQuery && !(bq = (BooleanQuery)query).isCoordDisabled()) {
                            SolrPluginUtils.setMinShouldMatch(bq, this.minShouldMatch);
                        }
                        if (query instanceof PhraseQuery) {
                            pq = (PhraseQuery)query;
                            if (this.minClauseSize > 1 && pq.getTerms().length < this.minClauseSize) {
                                return null;
                            }
                            ((PhraseQuery)query).setSlop(this.slop);
                        } else if (query instanceof MultiPhraseQuery) {
                            pq = (MultiPhraseQuery)query;
                            if (this.minClauseSize > 1 && pq.getTermArrays().size() < this.minClauseSize) {
                                return null;
                            }
                            ((MultiPhraseQuery)query).setSlop(this.slop);
                        } else if (this.minClauseSize > 1) {
                            return null;
                        }
                        return query;
                    }
                    case PREFIX: {
                        return super.getPrefixQuery(this.field, this.val);
                    }
                    case WILDCARD: {
                        return super.getWildcardQuery(this.field, this.val);
                    }
                    case FUZZY: {
                        return super.getFuzzyQuery(this.field, this.val, this.flt);
                    }
                    case RANGE: {
                        return super.getRangeQuery(this.field, this.val, this.val2, this.bool);
                    }
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }

        protected class Alias {
            public float tie;
            public Map<String, Float> fields;

            protected Alias() {
            }
        }
    }

    static enum QType {
        FIELD,
        PHRASE,
        PREFIX,
        WILDCARD,
        FUZZY,
        RANGE;

    }

    static class Clause {
        String field;
        boolean isPhrase;
        boolean hasWhitespace;
        boolean hasSpecialSyntax;
        boolean syntaxError;
        char must;
        String val;
        String raw;

        Clause() {
        }

        boolean isBareWord() {
            return this.must == '\u0000' && !this.isPhrase;
        }
    }

    private static interface DMP
    extends DisMaxParams {
        public static final String UF = "uf";
    }

    private static class U
    extends SolrPluginUtils {
        private U() {
        }
    }
}

