/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.DocSet;

class FilterImpl
extends Filter {
    final DocSet filter;
    final Filter topFilter;
    final List<Weight> weights;

    public FilterImpl(DocSet filter, List<Weight> weights) {
        this.filter = filter;
        this.weights = weights;
        this.topFilter = filter == null ? null : filter.getTopFilter();
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        DocIdSet sub;
        DocIdSet docIdSet = sub = this.topFilter == null ? null : this.topFilter.getDocIdSet(reader);
        if (this.weights.size() == 0) {
            return sub;
        }
        return new FilterSet(sub, reader);
    }

    private static class DualFilterIterator
    extends DocIdSetIterator {
        final DocIdSetIterator a;
        final DocIdSetIterator b;

        public DualFilterIterator(DocIdSetIterator a, DocIdSetIterator b) {
            this.a = a;
            this.b = b;
        }

        public int docID() {
            return this.a.docID();
        }

        public int nextDoc() throws IOException {
            int other;
            int doc = this.a.nextDoc();
            do {
                if ((other = this.b.advance(doc)) != doc) continue;
                return doc;
            } while (other != (doc = this.a.advance(other)));
            return doc;
        }

        public int advance(int target) throws IOException {
            int other;
            int doc = this.a.advance(target);
            do {
                if ((other = this.b.advance(doc)) != doc) continue;
                return doc;
            } while (other != (doc = this.a.advance(other)));
            return doc;
        }
    }

    private static class FilterIterator
    extends DocIdSetIterator {
        final DocIdSetIterator[] iterators;
        final DocIdSetIterator first;

        public FilterIterator(DocIdSetIterator[] iterators) {
            this.iterators = iterators;
            this.first = iterators[0];
        }

        public int docID() {
            return this.first.docID();
        }

        private int doNext(int doc) throws IOException {
            int which = 0;
            int i = 1;
            while (i < this.iterators.length) {
                DocIdSetIterator iter;
                int next;
                if (i != which && (next = (iter = this.iterators[i]).advance(doc)) != doc) {
                    doc = next;
                    which = i;
                    i = 0;
                    continue;
                }
                ++i;
            }
            return doc;
        }

        public int nextDoc() throws IOException {
            return this.doNext(this.first.nextDoc());
        }

        public int advance(int target) throws IOException {
            return this.doNext(this.first.advance(target));
        }
    }

    private class FilterSet
    extends DocIdSet {
        DocIdSet docIdSet;
        IndexReader reader;

        public FilterSet(DocIdSet docIdSet, IndexReader reader) {
            this.docIdSet = docIdSet;
            this.reader = reader;
        }

        public DocIdSetIterator iterator() throws IOException {
            ArrayList<Object> iterators = new ArrayList<Object>(FilterImpl.this.weights.size() + 1);
            if (this.docIdSet != null) {
                DocIdSetIterator iter = this.docIdSet.iterator();
                if (iter == null) {
                    return null;
                }
                iterators.add(iter);
            }
            for (Weight w : FilterImpl.this.weights) {
                Scorer scorer = w.scorer(this.reader, true, false);
                if (scorer == null) {
                    return null;
                }
                iterators.add(scorer);
            }
            if (iterators.size() == 0) {
                return null;
            }
            if (iterators.size() == 1) {
                return (DocIdSetIterator)iterators.get(0);
            }
            if (iterators.size() == 2) {
                return new DualFilterIterator((DocIdSetIterator)iterators.get(0), (DocIdSetIterator)iterators.get(1));
            }
            return new FilterIterator(iterators.toArray(new DocIdSetIterator[iterators.size()]));
        }
    }
}

