/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.PostFilter;
import org.apache.solr.search.SolrConstantScoreQuery;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.search.function.ValueSourceRangeFilter;
import org.apache.solr.search.function.ValueSourceScorer;

class FunctionRangeQuery
extends SolrConstantScoreQuery
implements PostFilter {
    final ValueSourceRangeFilter rangeFilt;

    public FunctionRangeQuery(ValueSourceRangeFilter filter) {
        super(filter);
        this.rangeFilt = filter;
    }

    @Override
    public DelegatingCollector getFilterCollector(IndexSearcher searcher) {
        Map fcontext = ValueSource.newContext();
        return new FunctionRangeCollector(fcontext);
    }

    class FunctionRangeCollector
    extends DelegatingCollector {
        final Map fcontext;
        ValueSourceScorer scorer;
        int maxdoc;

        public FunctionRangeCollector(Map fcontext) {
            this.fcontext = fcontext;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (doc < this.maxdoc && this.scorer.matches(doc)) {
                this.delegate.collect(doc);
            }
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.maxdoc = reader.maxDoc();
            DocValues dv = FunctionRangeQuery.this.rangeFilt.getValueSource().getValues(this.fcontext, reader);
            this.scorer = dv.getRangeScorer(reader, FunctionRangeQuery.this.rangeFilt.getLowerVal(), FunctionRangeQuery.this.rangeFilt.getUpperVal(), FunctionRangeQuery.this.rangeFilt.isIncludeLower(), FunctionRangeQuery.this.rangeFilt.isIncludeUpper());
            super.setNextReader(reader, docBase);
        }
    }
}

