/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.function.ConstNumberSource;
import org.apache.solr.search.function.DocValues;

class LongConstValueSource
extends ConstNumberSource {
    final long constant;
    final double dv;
    final float fv;

    public LongConstValueSource(long constant) {
        this.constant = constant;
        this.dv = constant;
        this.fv = constant;
    }

    @Override
    public String description() {
        return "const(" + this.constant + ")";
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return LongConstValueSource.this.fv;
            }

            @Override
            public int intVal(int doc) {
                return (int)LongConstValueSource.this.constant;
            }

            @Override
            public long longVal(int doc) {
                return LongConstValueSource.this.constant;
            }

            @Override
            public double doubleVal(int doc) {
                return LongConstValueSource.this.dv;
            }

            @Override
            public String strVal(int doc) {
                return Long.toString(LongConstValueSource.this.constant);
            }

            @Override
            public String toString(int doc) {
                return LongConstValueSource.this.description();
            }
        };
    }

    @Override
    public int hashCode() {
        return (int)this.constant + (int)(this.constant >>> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (LongConstValueSource.class != o.getClass()) {
            return false;
        }
        LongConstValueSource other = (LongConstValueSource)o;
        return this.constant == other.constant;
    }

    @Override
    public int getInt() {
        return (int)this.constant;
    }

    @Override
    public long getLong() {
        return this.constant;
    }

    @Override
    public float getFloat() {
        return this.fv;
    }

    @Override
    public double getDouble() {
        return this.dv;
    }

    @Override
    public Number getNumber() {
        return this.constant;
    }
}

