/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.apache.solr.search.PrefixGenerator;

public class PrefixFilter
extends Filter {
    protected final Term prefix;

    PrefixFilter(Term prefix) {
        this.prefix = prefix;
    }

    Term getPrefix() {
        return this.prefix;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        final OpenBitSet bitSet = new OpenBitSet((long)reader.maxDoc());
        new PrefixGenerator(this.prefix){

            @Override
            public void handleDoc(int doc) {
                bitSet.set((long)doc);
            }
        }.generate(reader);
        return bitSet;
    }

    public boolean equals(Object o) {
        return o instanceof PrefixFilter && ((PrefixFilter)((Object)o)).prefix.equals((Object)this.prefix);
    }

    public int hashCode() {
        return -825262110 + this.prefix.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrefixFilter(");
        sb.append(this.prefix.toString());
        sb.append(")");
        return sb.toString();
    }
}

