/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.solr.common.SolrException;
import org.apache.solr.search.ExtendedQuery;
import org.apache.solr.search.SolrFilter;
import org.apache.solr.search.function.ValueSource;

public class SolrConstantScoreQuery
extends ConstantScoreQuery
implements ExtendedQuery {
    boolean cache = true;
    int cost;

    public SolrConstantScoreQuery(Filter filter) {
        super(filter);
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public void setCache(boolean cache) {
        this.cache = cache;
    }

    @Override
    public boolean getCache() {
        return this.cache;
    }

    @Override
    public void setCacheSep(boolean cacheSep) {
    }

    @Override
    public boolean getCacheSep() {
        return false;
    }

    @Override
    public void setCost(int cost) {
        this.cost = cost;
    }

    @Override
    public int getCost() {
        return this.cost;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set terms) {
    }

    public Weight createWeight(Searcher searcher) {
        try {
            return new ConstantWeight(searcher);
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public String toString(String field) {
        return "ConstantScore(" + this.filter.toString() + ((double)this.getBoost() == 1.0 ? ")" : "^" + this.getBoost());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SolrConstantScoreQuery)) {
            return false;
        }
        SolrConstantScoreQuery other = (SolrConstantScoreQuery)o;
        return this.getBoost() == other.getBoost() && this.filter.equals(other.filter);
    }

    public int hashCode() {
        return this.filter.hashCode() + Float.floatToIntBits(this.getBoost());
    }

    protected class ConstantScorer
    extends Scorer {
        final DocIdSetIterator docIdSetIterator;
        final float theScore;
        int doc;

        public ConstantScorer(Similarity similarity, IndexReader reader, ConstantWeight w) throws IOException {
            DocIdSetIterator iter;
            DocIdSet docIdSet;
            super(similarity, (Weight)w);
            this.doc = -1;
            this.theScore = w.getValue();
            DocIdSet docIdSet2 = docIdSet = SolrConstantScoreQuery.this.filter instanceof SolrFilter ? ((SolrFilter)SolrConstantScoreQuery.this.filter).getDocIdSet(w.context, reader) : SolrConstantScoreQuery.this.filter.getDocIdSet(reader);
            this.docIdSetIterator = docIdSet == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : ((iter = docIdSet.iterator()) == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : iter);
        }

        public int nextDoc() throws IOException {
            return this.docIdSetIterator.nextDoc();
        }

        public int docID() {
            return this.docIdSetIterator.docID();
        }

        public float score() throws IOException {
            return this.theScore;
        }

        public int advance(int target) throws IOException {
            return this.docIdSetIterator.advance(target);
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class ConstantWeight
    extends Weight {
        private Similarity similarity;
        private float queryNorm;
        private float queryWeight;
        private Map context;

        public ConstantWeight(Searcher searcher) throws IOException {
            this.similarity = SolrConstantScoreQuery.this.getSimilarity(searcher);
            this.context = ValueSource.newContext();
            if (SolrConstantScoreQuery.this.filter instanceof SolrFilter) {
                ((SolrFilter)SolrConstantScoreQuery.this.filter).createWeight(this.context, searcher);
            }
        }

        public Query getQuery() {
            return SolrConstantScoreQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = SolrConstantScoreQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new ConstantScorer(this.similarity, reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            ConstantScorer cs = new ConstantScorer(this.similarity, reader, this);
            boolean exists = cs.docIdSetIterator.advance(doc) == doc;
            ComplexExplanation result = new ComplexExplanation();
            if (exists) {
                result.setDescription("ConstantScoreQuery(" + SolrConstantScoreQuery.this.filter + "), product of:");
                result.setValue(this.queryWeight);
                result.setMatch(Boolean.TRUE);
                result.addDetail(new Explanation(SolrConstantScoreQuery.this.getBoost(), "boost"));
                result.addDetail(new Explanation(this.queryNorm, "queryNorm"));
            } else {
                result.setDescription("ConstantScoreQuery(" + SolrConstantScoreQuery.this.filter + ") doesn't match id " + doc);
                result.setValue(0.0f);
                result.setMatch(Boolean.FALSE);
            }
            return result;
        }
    }
}

