/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.function;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

public class TopValueSource
extends ValueSource {
    private final ValueSource vs;

    public TopValueSource(ValueSource vs) {
        this.vs = vs;
    }

    public ValueSource getValueSource() {
        return this.vs;
    }

    @Override
    public String description() {
        return "top(" + this.vs.description() + ')';
    }

    @Override
    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        int offset = 0;
        Object topReader = reader;
        if (topReader instanceof SolrIndexReader) {
            SolrIndexReader r = (SolrIndexReader)((Object)topReader);
            while (r.getParent() != null) {
                offset += r.getBase();
                r = r.getParent();
            }
            topReader = r;
        }
        final int off = offset;
        final DocValues vals = this.vs.getValues(context, (IndexReader)topReader);
        if (topReader == reader) {
            return vals;
        }
        return new DocValues(){

            @Override
            public float floatVal(int doc) {
                return vals.floatVal(doc + off);
            }

            @Override
            public int intVal(int doc) {
                return vals.intVal(doc + off);
            }

            @Override
            public long longVal(int doc) {
                return vals.longVal(doc + off);
            }

            @Override
            public double doubleVal(int doc) {
                return vals.doubleVal(doc + off);
            }

            @Override
            public String strVal(int doc) {
                return vals.strVal(doc + off);
            }

            @Override
            public String toString(int doc) {
                return vals.strVal(doc + off);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != TopValueSource.class) {
            return false;
        }
        TopValueSource other = (TopValueSource)o;
        return this.vs.equals(other.vs);
    }

    @Override
    public int hashCode() {
        int h = this.vs.hashCode();
        return h << 1 | h >>> 31;
    }

    @Override
    public String toString() {
        return "top(" + this.vs.toString() + ')';
    }
}

