/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.TermFirstPassGroupingCollector;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.Pair;

public class SearchGroupsFieldCommand
implements Command<Pair<Integer, Collection<SearchGroup<String>>>> {
    private final SchemaField field;
    private final Sort groupSort;
    private final int topNGroups;
    private final boolean includeGroupCount;
    private TermFirstPassGroupingCollector firstPassGroupingCollector;
    private TermAllGroupsCollector allGroupsCollector;

    private SearchGroupsFieldCommand(SchemaField field, Sort groupSort, int topNGroups, boolean includeGroupCount) {
        this.field = field;
        this.groupSort = groupSort;
        this.topNGroups = topNGroups;
        this.includeGroupCount = includeGroupCount;
    }

    @Override
    public List<Collector> create() throws IOException {
        ArrayList<Collector> collectors = new ArrayList<Collector>();
        if (this.topNGroups > 0) {
            this.firstPassGroupingCollector = new TermFirstPassGroupingCollector(this.field.getName(), this.groupSort, this.topNGroups);
            collectors.add((Collector)this.firstPassGroupingCollector);
        }
        if (this.includeGroupCount) {
            this.allGroupsCollector = new TermAllGroupsCollector(this.field.getName());
            collectors.add((Collector)this.allGroupsCollector);
        }
        return collectors;
    }

    @Override
    public Pair<Integer, Collection<SearchGroup<String>>> result() {
        Collection<Object> topGroups = this.topNGroups > 0 ? this.firstPassGroupingCollector.getTopGroups(0, true) : Collections.emptyList();
        Integer groupCount = this.includeGroupCount ? Integer.valueOf(this.allGroupsCollector.getGroupCount()) : null;
        return new Pair<Integer, Collection<SearchGroup<String>>>(groupCount, topGroups);
    }

    @Override
    public Sort getSortWithinGroup() {
        return null;
    }

    @Override
    public Sort getGroupSort() {
        return this.groupSort;
    }

    @Override
    public String getKey() {
        return this.field.getName();
    }

    public static class Builder {
        private SchemaField field;
        private Sort groupSort;
        private Integer topNGroups;
        private boolean includeGroupCount = false;

        public Builder setField(SchemaField field) {
            this.field = field;
            return this;
        }

        public Builder setGroupSort(Sort groupSort) {
            this.groupSort = groupSort;
            return this;
        }

        public Builder setTopNGroups(int topNGroups) {
            this.topNGroups = topNGroups;
            return this;
        }

        public Builder setIncludeGroupCount(boolean includeGroupCount) {
            this.includeGroupCount = includeGroupCount;
            return this;
        }

        public SearchGroupsFieldCommand build() {
            if (this.field == null || this.groupSort == null || this.topNGroups == null) {
                throw new IllegalStateException("All fields must be set");
            }
            return new SearchGroupsFieldCommand(this.field, this.groupSort, this.topNGroups, this.includeGroupCount);
        }
    }
}

