/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.responseprocessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.SortSpec;
import org.apache.solr.search.grouping.distributed.ShardResponseProcessor;
import org.apache.solr.search.grouping.distributed.command.Pair;
import org.apache.solr.search.grouping.distributed.shardresultserializer.SearchGroupsResultTransformer;

public class SearchGroupShardResponseProcessor
implements ShardResponseProcessor {
    @Override
    public void process(ResponseBuilder rb, ShardRequest shardRequest) {
        SortSpec ss = rb.getSortSpec();
        Sort groupSort = rb.getGroupingSpec().getGroupSort();
        String[] fields = rb.getGroupingSpec().getFields();
        HashMap commandSearchGroups = new HashMap();
        HashMap tempSearchGroupToShards = new HashMap();
        for (String field : fields) {
            commandSearchGroups.put(field, new ArrayList(shardRequest.responses.size()));
            tempSearchGroupToShards.put(field, new HashMap());
            if (rb.searchGroupToShards.containsKey(field)) continue;
            rb.searchGroupToShards.put(field, new HashMap());
        }
        SearchGroupsResultTransformer serializer = new SearchGroupsResultTransformer(rb.req.getSearcher());
        try {
            int maxElapsedTime = 0;
            int hitCountDuringFirstPhase = 0;
            for (ShardResponse srsp : shardRequest.responses) {
                maxElapsedTime = (int)Math.max((long)maxElapsedTime, srsp.getSolrResponse().getElapsedTime());
                NamedList firstPhaseResult = (NamedList)srsp.getSolrResponse().getResponse().get("firstPhase");
                Object result = serializer.transformToNative(firstPhaseResult, groupSort, (Sort)null, srsp.getShard());
                for (String field : commandSearchGroups.keySet()) {
                    Collection searchGroups;
                    Pair firstPhaseCommandResult = (Pair)result.get(field);
                    Integer groupCount = (Integer)firstPhaseCommandResult.getA();
                    if (groupCount != null) {
                        Integer existingGroupCount = rb.mergedGroupCounts.get(field);
                        rb.mergedGroupCounts.put(field, existingGroupCount != null ? existingGroupCount + groupCount : groupCount);
                    }
                    if ((searchGroups = (Collection)firstPhaseCommandResult.getB()) == null) continue;
                    ((List)commandSearchGroups.get(field)).add(searchGroups);
                    for (SearchGroup searchGroup : searchGroups) {
                        Map map = (Map)tempSearchGroupToShards.get(field);
                        HashSet<String> shards = (HashSet<String>)map.get(searchGroup);
                        if (shards == null) {
                            shards = new HashSet<String>();
                            map.put(searchGroup, shards);
                        }
                        shards.add(srsp.getShard());
                    }
                }
                hitCountDuringFirstPhase += ((Integer)srsp.getSolrResponse().getResponse().get("totalHitCount")).intValue();
            }
            rb.totalHitCount = hitCountDuringFirstPhase;
            rb.firstPhaseElapsedTime = maxElapsedTime;
            for (String groupField : commandSearchGroups.keySet()) {
                List topGroups = (List)commandSearchGroups.get(groupField);
                Collection mergedTopGroups = SearchGroup.merge((List)topGroups, (int)ss.getOffset(), (int)ss.getCount(), (Sort)groupSort);
                if (mergedTopGroups == null) continue;
                rb.mergedSearchGroups.put(groupField, mergedTopGroups);
                for (SearchGroup mergedTopGroup : mergedTopGroups) {
                    rb.searchGroupToShards.get(groupField).put((SearchGroup<String>)mergedTopGroup, (Set<String>)((Map)tempSearchGroupToShards.get(groupField)).get(mergedTopGroup));
                }
            }
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }
}

