/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.shardresultserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardDoc;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.QueryCommand;
import org.apache.solr.search.grouping.distributed.command.QueryCommandResult;
import org.apache.solr.search.grouping.distributed.command.TopGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;

public class TopGroupsResultTransformer
implements ShardResultTransformer<List<Command>, Map<String, ?>> {
    private final ResponseBuilder rb;

    public TopGroupsResultTransformer(ResponseBuilder rb) {
        this.rb = rb;
    }

    @Override
    public NamedList transform(List<Command> data) throws IOException {
        NamedList result = new NamedList();
        for (Command command : data) {
            NamedList commandResult;
            if (TopGroupsFieldCommand.class.isInstance(command)) {
                TopGroupsFieldCommand fieldCommand = (TopGroupsFieldCommand)command;
                SchemaField groupField = this.rb.req.getSearcher().getSchema().getField(fieldCommand.getKey());
                commandResult = this.serializeTopGroups(fieldCommand.result(), groupField);
            } else if (QueryCommand.class.isInstance(command)) {
                QueryCommand queryCommand = (QueryCommand)command;
                commandResult = this.serializeTopDocs(queryCommand.result());
            } else {
                commandResult = null;
            }
            result.add(command.getKey(), commandResult);
        }
        return result;
    }

    @Override
    public Map<String, ?> transformToNative(NamedList<NamedList> shardResponse, Sort groupSort, Sort sortWithinGroup, String shard) {
        HashMap<String, QueryCommandResult> result = new HashMap<String, QueryCommandResult>();
        for (Map.Entry entry : shardResponse) {
            String key = (String)entry.getKey();
            NamedList commandResult = (NamedList)entry.getValue();
            Integer totalGroupedHitCount = (Integer)commandResult.get("totalGroupedHitCount");
            Integer totalHits = (Integer)commandResult.get("totalHits");
            if (totalHits != null) {
                Integer matches = (Integer)commandResult.get("matches");
                Float maxScore = (Float)commandResult.get("maxScore");
                if (maxScore == null) {
                    maxScore = Float.valueOf(Float.NaN);
                }
                List documents = (List)commandResult.get("documents");
                ScoreDoc[] scoreDocs = new ScoreDoc[documents.size()];
                int j = 0;
                for (NamedList document : documents) {
                    String uniqueId = document.get("id").toString();
                    Float score = (Float)document.get("score");
                    if (score == null) {
                        score = Float.valueOf(Float.NaN);
                    }
                    Object[] sortValues = ((List)document.get("sortValues")).toArray();
                    scoreDocs[j++] = new ShardDoc(score.floatValue(), sortValues, uniqueId, shard);
                }
                result.put(key, new QueryCommandResult(new TopDocs(totalHits.intValue(), scoreDocs, maxScore.floatValue()), matches));
                continue;
            }
            Integer totalHitCount = (Integer)commandResult.get("totalHitCount");
            ArrayList<GroupDocs> groupDocs = new ArrayList<GroupDocs>();
            for (int i = 2; i < commandResult.size(); ++i) {
                String groupValue = commandResult.getName(i);
                NamedList groupResult = (NamedList)commandResult.getVal(i);
                Integer totalGroupHits = (Integer)groupResult.get("totalHits");
                Float maxScore = (Float)groupResult.get("maxScore");
                if (maxScore == null) {
                    maxScore = Float.valueOf(Float.NaN);
                }
                List documents = (List)groupResult.get("documents");
                ScoreDoc[] scoreDocs = new ScoreDoc[documents.size()];
                int j = 0;
                for (NamedList document : documents) {
                    String uniqueId = document.get("id").toString();
                    Float score = (Float)document.get("score");
                    if (score == null) {
                        score = Float.valueOf(Float.NaN);
                    }
                    Object[] sortValues = ((List)document.get("sortValues")).toArray();
                    scoreDocs[j++] = new ShardDoc(score.floatValue(), sortValues, uniqueId, shard);
                }
                String groupValueRef = groupValue != null ? groupValue : null;
                groupDocs.add(new GroupDocs(maxScore.floatValue(), totalGroupHits.intValue(), scoreDocs, (Object)groupValueRef, null));
            }
            GroupDocs[] groupDocsArr = groupDocs.toArray(new GroupDocs[groupDocs.size()]);
            TopGroups topGroups = new TopGroups(groupSort.getSort(), sortWithinGroup.getSort(), totalHitCount.intValue(), totalGroupedHitCount.intValue(), groupDocsArr);
            result.put(key, (QueryCommandResult)topGroups);
        }
        return result;
    }

    protected NamedList serializeTopGroups(TopGroups<String> data, SchemaField groupField) throws IOException {
        NamedList result = new NamedList();
        result.add("totalGroupedHitCount", (Object)data.totalGroupedHitCount);
        result.add("totalHitCount", (Object)data.totalHitCount);
        if (data.totalGroupCount != null) {
            result.add("totalGroupCount", (Object)data.totalGroupCount);
        }
        SchemaField uniqueField = this.rb.req.getSearcher().getSchema().getUniqueKeyField();
        for (GroupDocs searchGroup : data.groups) {
            NamedList groupResult = new NamedList();
            groupResult.add("totalHits", (Object)searchGroup.totalHits);
            if (!Float.isNaN(searchGroup.maxScore)) {
                groupResult.add("maxScore", (Object)Float.valueOf(searchGroup.maxScore));
            }
            ArrayList<NamedList> documents = new ArrayList<NamedList>();
            for (int i = 0; i < searchGroup.scoreDocs.length; ++i) {
                NamedList document = new NamedList();
                documents.add(document);
                Document doc = this.retrieveDocument(uniqueField, searchGroup.scoreDocs[i].doc);
                document.add("id", (Object)uniqueField.getType().toExternal(doc.getFieldable(uniqueField.getName())));
                if (!Float.isNaN(searchGroup.scoreDocs[i].score)) {
                    document.add("score", (Object)Float.valueOf(searchGroup.scoreDocs[i].score));
                }
                if (!(searchGroup.scoreDocs[i] instanceof FieldDoc)) continue;
                FieldDoc fieldDoc = (FieldDoc)searchGroup.scoreDocs[i];
                Object[] convertedSortValues = new Object[fieldDoc.fields.length];
                for (int j = 0; j < fieldDoc.fields.length; ++j) {
                    SchemaField field;
                    Object sortValue = fieldDoc.fields[j];
                    Sort sortWithinGroup = this.rb.getGroupingSpec().getSortWithinGroup();
                    SchemaField schemaField = field = sortWithinGroup.getSort()[j].getField() != null ? this.rb.req.getSearcher().getSchema().getFieldOrNull(sortWithinGroup.getSort()[j].getField()) : null;
                    if (field != null) {
                        FieldType fieldType = field.getType();
                        if (sortValue instanceof String) {
                            sortValue = fieldType.toObject(field.createField(fieldType.indexedToReadable((String)sortValue), 0.0f));
                        }
                    }
                    convertedSortValues[j] = sortValue;
                }
                document.add("sortValues", (Object)convertedSortValues);
            }
            groupResult.add("documents", documents);
            String groupValue = searchGroup.groupValue != null ? groupField.getType().indexedToReadable((String)searchGroup.groupValue) : null;
            result.add(groupValue, (Object)groupResult);
        }
        return result;
    }

    protected NamedList serializeTopDocs(QueryCommandResult result) throws IOException {
        NamedList queryResult = new NamedList();
        queryResult.add("matches", (Object)result.getMatches());
        queryResult.add("totalHits", (Object)result.getTopDocs().totalHits);
        if (this.rb.getGroupingSpec().isNeedScore()) {
            queryResult.add("maxScore", (Object)Float.valueOf(result.getTopDocs().getMaxScore()));
        }
        ArrayList<NamedList> documents = new ArrayList<NamedList>();
        queryResult.add("documents", documents);
        SchemaField uniqueField = this.rb.req.getSearcher().getSchema().getUniqueKeyField();
        for (ScoreDoc scoreDoc : result.getTopDocs().scoreDocs) {
            NamedList document = new NamedList();
            documents.add(document);
            Document doc = this.retrieveDocument(uniqueField, scoreDoc.doc);
            document.add("id", (Object)uniqueField.getType().toExternal(doc.getFieldable(uniqueField.getName())));
            if (this.rb.getGroupingSpec().isNeedScore()) {
                document.add("score", (Object)Float.valueOf(scoreDoc.score));
            }
            if (!FieldDoc.class.isInstance(scoreDoc)) continue;
            FieldDoc fieldDoc = (FieldDoc)scoreDoc;
            Object[] convertedSortValues = new Object[fieldDoc.fields.length];
            for (int j = 0; j < fieldDoc.fields.length; ++j) {
                SchemaField field;
                Object sortValue = fieldDoc.fields[j];
                Sort groupSort = this.rb.getGroupingSpec().getGroupSort();
                SchemaField schemaField = field = groupSort.getSort()[j].getField() != null ? this.rb.req.getSearcher().getSchema().getFieldOrNull(groupSort.getSort()[j].getField()) : null;
                if (field != null) {
                    FieldType fieldType = field.getType();
                    if (sortValue instanceof String) {
                        sortValue = fieldType.toObject(field.createField(fieldType.indexedToReadable((String)sortValue), 0.0f));
                    }
                }
                convertedSortValues[j] = sortValue;
            }
            document.add("sortValues", (Object)convertedSortValues);
        }
        return queryResult;
    }

    private Document retrieveDocument(final SchemaField uniqueField, int doc) throws IOException {
        FieldSelector fieldSelectorVisitor = new FieldSelector(){

            public FieldSelectorResult accept(String fieldName) {
                if (uniqueField.getName().equals(fieldName)) {
                    return FieldSelectorResult.LOAD_AND_BREAK;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        };
        return this.rb.req.getSearcher().doc(doc, fieldSelectorVisitor);
    }
}

