/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.FastWriter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.Config;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.SearchHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrRequestParsers;
import org.apache.solr.servlet.cache.HttpCacheHeaderUtil;
import org.apache.solr.servlet.cache.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SolrDispatchFilter
implements Filter {
    final Logger log = LoggerFactory.getLogger(SolrDispatchFilter.class);
    protected CoreContainer cores;
    protected String pathPrefix = null;
    protected String abortErrorMessage = null;
    protected String solrConfigFilename = null;
    protected final Map<SolrConfig, SolrRequestParsers> parsers = new WeakHashMap<SolrConfig, SolrRequestParsers>();
    protected final SolrRequestParsers adminRequestParser;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public SolrDispatchFilter() {
        try {
            this.adminRequestParser = new SolrRequestParsers(new Config(null, "solr", new InputSource(new ByteArrayInputStream("<root/>".getBytes("UTF-8"))), ""));
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        this.log.info("SolrDispatchFilter.init()");
        boolean abortOnConfigurationError = true;
        CoreContainer.Initializer init = this.createInitializer();
        try {
            this.pathPrefix = config.getInitParameter("path-prefix");
            init.setSolrConfigFilename(config.getInitParameter("solrconfig-filename"));
            this.cores = init.initialize();
            abortOnConfigurationError = init.isAbortOnConfigurationError();
            this.log.info("user.dir=" + System.getProperty("user.dir"));
        }
        catch (Throwable t) {
            this.log.error("Could not start Solr. Check solr/home property and the logs", t);
            SolrConfig.severeErrors.add(t);
            SolrCore.log(t);
        }
        if (abortOnConfigurationError && SolrConfig.severeErrors.size() > 0) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println("Severe errors in solr configuration.\n");
            out.println("Check your log files for more detailed information on what may be wrong.\n");
            out.println("If you want solr to continue after configuration errors, change: \n");
            out.println(" <abortOnConfigurationError>false</abortOnConfigurationError>\n");
            out.println("in " + init.getSolrConfigFilename() + "\n");
            for (Throwable t : SolrConfig.severeErrors) {
                out.println("-------------------------------------------------------------");
                t.printStackTrace(out);
            }
            out.flush();
            this.abortErrorMessage = sw.toString();
        }
        this.log.info("SolrDispatchFilter.init() done");
    }

    protected CoreContainer.Initializer createInitializer() {
        return new CoreContainer.Initializer();
    }

    public void destroy() {
        if (this.cores != null) {
            this.cores.shutdown();
            this.cores = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.abortErrorMessage != null) {
            ((HttpServletResponse)response).sendError(500, this.abortErrorMessage);
            return;
        }
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            SolrRequestHandler handler = null;
            SolrQueryRequest solrReq = null;
            SolrCore core = null;
            String corename = "";
            try {
                int idx;
                String alternate;
                req.setAttribute("org.apache.solr.CoreContainer", (Object)this.cores);
                String path = req.getServletPath();
                if (req.getPathInfo() != null) {
                    path = path + req.getPathInfo();
                }
                if (this.pathPrefix != null && path.startsWith(this.pathPrefix)) {
                    path = path.substring(this.pathPrefix.length());
                }
                if ((alternate = this.cores.getManagementPath()) != null && path.startsWith(alternate)) {
                    path = path.substring(0, alternate.length());
                }
                if ((idx = path.indexOf(58)) > 0) {
                    path = path.substring(0, idx);
                }
                if (path.equals(this.cores.getAdminPath())) {
                    handler = this.cores.getMultiCoreHandler();
                    solrReq = this.adminRequestParser.parse(null, path, req);
                    this.handleAdminRequest(req, response, handler, solrReq);
                    return;
                }
                idx = path.indexOf("/", 1);
                if (idx > 1 && (core = this.cores.getCore(corename = path.substring(1, idx))) != null) {
                    path = path.substring(idx);
                }
                if (core == null) {
                    corename = "";
                    core = this.cores.getCore("");
                }
                if (core != null) {
                    SolrConfig config = core.getSolrConfig();
                    SolrRequestParsers parser = null;
                    parser = this.parsers.get(config);
                    if (parser == null) {
                        parser = new SolrRequestParsers(config);
                        this.parsers.put(config, parser);
                    }
                    if (handler == null && path.length() > 1 && (handler = core.getRequestHandler(path)) == null && parser.isHandleSelect() && ("/select".equals(path) || "/select/".equals(path))) {
                        solrReq = parser.parse(core, path, req);
                        String qt = solrReq.getParams().get("qt");
                        handler = core.getRequestHandler(qt);
                        if (handler == null) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                        }
                        if (qt != null && qt.startsWith("/") && !(handler instanceof SearchHandler)) {
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid query type.  Do not use /select to access: " + qt);
                        }
                    }
                    if (handler != null) {
                        if (solrReq == null) {
                            solrReq = parser.parse(core, path, req);
                        }
                        Method reqMethod = Method.getMethod(req.getMethod());
                        HttpCacheHeaderUtil.setCacheControlHeader(config, resp, reqMethod);
                        if (config.getHttpCachingConfig().isNever304() || !HttpCacheHeaderUtil.doCacheHeaderValidation(solrReq, req, reqMethod, resp)) {
                            SolrQueryResponse solrRsp = new SolrQueryResponse();
                            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(solrReq, solrRsp));
                            this.execute(req, handler, solrReq, solrRsp);
                            HttpCacheHeaderUtil.checkHttpCachingVeto(solrRsp, resp, reqMethod);
                            QueryResponseWriter responseWriter = core.getQueryResponseWriter(solrReq);
                            this.writeResponse(solrRsp, response, responseWriter, solrReq, reqMethod);
                        }
                        return;
                    }
                    req.setAttribute("org.apache.solr.SolrCore", (Object)core);
                    if (path.startsWith("/admin")) {
                        req.getRequestDispatcher(this.pathPrefix == null ? path : this.pathPrefix + path).forward(request, response);
                        return;
                    }
                }
                this.log.debug("no handler or core retrieved for " + path + ", follow through...");
            }
            catch (Throwable ex) {
                this.sendError((HttpServletResponse)response, ex);
                return;
            }
            finally {
                if (solrReq != null) {
                    solrReq.close();
                }
                if (core != null) {
                    core.close();
                }
                SolrRequestInfo.clearRequestInfo();
            }
        }
        chain.doFilter(request, response);
    }

    private void handleAdminRequest(HttpServletRequest req, ServletResponse response, SolrRequestHandler handler, SolrQueryRequest solrReq) throws IOException {
        SolrQueryResponse solrResp = new SolrQueryResponse();
        SimpleOrderedMap responseHeader = new SimpleOrderedMap();
        solrResp.add("responseHeader", responseHeader);
        NamedList toLog = solrResp.getToLog();
        toLog.add("webapp", (Object)req.getContextPath());
        toLog.add("path", solrReq.getContext().get("path"));
        toLog.add("params", (Object)("{" + solrReq.getParamString() + "}"));
        handler.handleRequest(solrReq, solrResp);
        SolrCore.setResponseHeaderValues(handler, solrReq, solrResp);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toLog.size(); ++i) {
            String name = toLog.getName(i);
            Object val = toLog.getVal(i);
            sb.append(name).append("=").append(val).append(" ");
        }
        QueryResponseWriter respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get(solrReq.getParams().get("wt"));
        if (respWriter == null) {
            respWriter = SolrCore.DEFAULT_RESPONSE_WRITERS.get("standard");
        }
        this.writeResponse(solrResp, response, respWriter, solrReq, Method.getMethod(req.getMethod()));
    }

    private void writeResponse(SolrQueryResponse solrRsp, ServletResponse response, QueryResponseWriter responseWriter, SolrQueryRequest solrReq, Method reqMethod) throws IOException {
        if (solrRsp.getException() != null) {
            this.sendError((HttpServletResponse)response, solrRsp.getException());
        } else {
            String ct = responseWriter.getContentType(solrReq, solrRsp);
            if (null != ct) {
                response.setContentType(ct);
            }
            if (Method.HEAD != reqMethod) {
                if (responseWriter instanceof BinaryQueryResponseWriter) {
                    BinaryQueryResponseWriter binWriter = (BinaryQueryResponseWriter)responseWriter;
                    binWriter.write((OutputStream)response.getOutputStream(), solrReq, solrRsp);
                } else {
                    String charset = ContentStreamBase.getCharsetFromContentType((String)ct);
                    OutputStreamWriter out = charset == null || charset.equalsIgnoreCase("UTF-8") ? new OutputStreamWriter((OutputStream)response.getOutputStream(), UTF8) : new OutputStreamWriter((OutputStream)response.getOutputStream(), charset);
                    out = new FastWriter((Writer)out);
                    responseWriter.write(out, solrReq, solrRsp);
                    ((Writer)out).flush();
                }
            }
        }
    }

    protected void execute(HttpServletRequest req, SolrRequestHandler handler, SolrQueryRequest sreq, SolrQueryResponse rsp) {
        sreq.getContext().put("webapp", req.getContextPath());
        sreq.getCore().execute(handler, sreq, rsp);
    }

    protected void sendError(HttpServletResponse res, Throwable ex) throws IOException {
        int code = 500;
        String trace = "";
        if (ex instanceof SolrException) {
            code = ((SolrException)ex).code();
        }
        if (code == 500 || code < 100) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            trace = "\n\n" + sw.toString();
            SolrException.logOnce((Logger)this.log, null, (Throwable)ex);
            if (code < 100) {
                this.log.warn("invalid return code: " + code);
                code = 500;
            }
        }
        res.sendError(code, ex.getMessage() + trace);
    }

    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }
}

