/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsr77.managedobject;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.jboss.as.jsr77.JSR77Messages;
import org.jboss.as.jsr77.managedobject.Handler;
import org.jboss.as.jsr77.managedobject.J2EEDeployedObjectHandler;
import org.jboss.as.jsr77.managedobject.JVMHandler;
import org.jboss.as.jsr77.managedobject.ModelReader;
import org.jboss.as.jsr77.managedobject.ObjectNameBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class J2EEDeployedObjectHandlers
extends Handler {
    static final J2EEDeployedObjectHandlers INSTANCE = new J2EEDeployedObjectHandlers();
    static final String J2EE_TYPE_J2EE_APPLICATION = "J2EEApplication";
    static final String J2EE_TYPE_EJB_MODULE = "EjbModule";
    static final String J2EE_TYPE_WEB_MODULE = "WebModule";
    static final String J2EE_TYPE_RA_MODULE = "ResourceAdapterModule";
    static final String J2EE_TYPE_APP_CLIENT_MODULE = "AppClientModule";

    private J2EEDeployedObjectHandlers() {
    }

    @Override
    Set<ObjectName> queryObjectNames(ModelReader reader, ObjectName name, QueryExp query) {
        ModelNode deployments = reader.getDeploymentModel();
        if (!deployments.isDefined()) {
            return Collections.emptySet();
        }
        HashSet<ObjectName> names = new HashSet<ObjectName>();
        for (ModelNode deployment : deployments.asList()) {
            String deploymentName = (deployment = deployment.get("result")).get("name").asString();
            String objName = this.createObjectName(null, deploymentName, deployment.hasDefined("subsystem") ? deployment.get("subsystem").asString() : null);
            if (objName == null) continue;
            this.addMatchingObjectName(names, name, objName);
            if (!deploymentName.endsWith(".ear") || !deployment.hasDefined("subdeployment")) continue;
            for (Property prop : deployment.get("subdeployment").asPropertyList()) {
                ModelNode subDep = prop.getValue();
                String subObjName = this.createObjectName(deploymentName, prop.getName(), subDep.hasDefined("subsystem") ? subDep.get("subsystem").asString() : null);
                this.addMatchingObjectName(names, name, subObjName);
            }
        }
        return names;
    }

    private void addMatchingObjectName(Set<ObjectName> names, ObjectName name, String objName) {
        ObjectName objectName;
        if (objName != null && (objectName = ObjectNameBuilder.createObjectName(objName)) != null && (name == null || name.apply(objectName))) {
            names.add(objectName);
        }
    }

    private String createObjectName(String appName, String deploymentName, String subsystem) {
        String type = null;
        if (deploymentName.endsWith(".ear")) {
            type = J2EE_TYPE_J2EE_APPLICATION;
        } else if (deploymentName.endsWith(".war")) {
            type = J2EE_TYPE_WEB_MODULE;
        } else if (deploymentName.endsWith(".jar")) {
            if (deploymentName.endsWith("client.jar")) {
                type = J2EE_TYPE_APP_CLIENT_MODULE;
            } else if (subsystem != null && subsystem.equals("ejb3")) {
                type = J2EE_TYPE_EJB_MODULE;
            }
        } else if (deploymentName.endsWith(".rar")) {
            type = J2EE_TYPE_RA_MODULE;
        }
        if (type == null) {
            return null;
        }
        ObjectNameBuilder builder = ObjectNameBuilder.createServerChild(type, deploymentName);
        if (appName != null) {
            builder.append(J2EE_TYPE_J2EE_APPLICATION, appName);
        }
        return builder.toString();
    }

    @Override
    Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException {
        return this.findHandler(reader, name).getAttribute(reader, name, attribute);
    }

    @Override
    MBeanInfo getMBeanInfo(ModelReader reader, ObjectName name) throws InstanceNotFoundException {
        return this.findHandler(reader, name).getMBeanInfo(reader, name);
    }

    Handler findHandler(ModelReader reader, ObjectName name) throws InstanceNotFoundException {
        String subDeployment;
        String mainDeployment;
        String j2eeType = name.getKeyProperty("j2eeType");
        String namePart = name.getKeyProperty("name");
        String appName = name.getKeyProperty(J2EE_TYPE_J2EE_APPLICATION);
        if (appName == null) {
            mainDeployment = namePart;
            subDeployment = null;
        } else {
            mainDeployment = appName;
            subDeployment = namePart;
        }
        if (mainDeployment != null) {
            ModelNode deploymentNode = null;
            ModelNode deployments = reader.getDeploymentModel();
            if (deployments.isDefined()) {
                for (ModelNode deployment : deployments.asList()) {
                    J2EEDeployedObjectHandler handler;
                    if (!mainDeployment.equals((deployment = deployment.get("result")).get("name").asString())) continue;
                    String actualDeployment = mainDeployment;
                    deploymentNode = deployment;
                    if (!deploymentNode.isDefined()) break;
                    if (subDeployment != null) {
                        actualDeployment = subDeployment;
                        if (!(deploymentNode = deploymentNode.get(new String[]{"subdeployment", subDeployment})).isDefined()) break;
                    }
                    if (j2eeType.equals(J2EE_TYPE_J2EE_APPLICATION) && actualDeployment.endsWith(".ear")) {
                        handler = J2EEApplicationHandler.INSTANCE;
                    } else if (j2eeType.equals(J2EE_TYPE_APP_CLIENT_MODULE) && actualDeployment.endsWith(".jar")) {
                        handler = AppClientModuleHandler.INSTANCE;
                    } else if (j2eeType.equals(J2EE_TYPE_EJB_MODULE) && actualDeployment.endsWith(".jar") && deploymentNode.hasDefined("subsystem") && deploymentNode.get("subsystem").asString().equals("ejb3")) {
                        handler = EJBModuleHandler.INSTANCE;
                    } else {
                        if (!j2eeType.equals(J2EE_TYPE_WEB_MODULE) || !actualDeployment.endsWith(".war")) break;
                        handler = WebModuleHandler.INSTANCE;
                    }
                    reader.setDeploymentModel(deploymentNode);
                    return handler;
                }
            }
        }
        throw JSR77Messages.MESSAGES.couldNotFindJ2eeType(j2eeType);
    }

    private static class EJBModuleHandler
    extends J2EEModuleHandler {
        static final EJBModuleHandler INSTANCE = new EJBModuleHandler();
        static final String ATTR_EJBS = "ejbs";

        private EJBModuleHandler() {
        }

        @Override
        Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
            if (attribute.equals(ATTR_EJBS)) {
                return new String[0];
            }
            return super.getAttribute(reader, name, attribute);
        }

        @Override
        Set<MBeanAttributeInfo> getAttributeInfos() {
            Set<MBeanAttributeInfo> attributes = super.getAttributeInfos();
            attributes.add(this.createRoMBeanAttributeInfo(ATTR_EJBS, String[].class.getName(), "The ejbs"));
            return attributes;
        }
    }

    private static class WebModuleHandler
    extends J2EEModuleHandler {
        static final WebModuleHandler INSTANCE = new WebModuleHandler();
        static final String ATTR_SERVLETS = "servlets";

        private WebModuleHandler() {
        }

        @Override
        Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
            if (attribute.equals(ATTR_SERVLETS)) {
                return new String[0];
            }
            return super.getAttribute(reader, name, attribute);
        }

        @Override
        Set<MBeanAttributeInfo> getAttributeInfos() {
            Set<MBeanAttributeInfo> attributes = super.getAttributeInfos();
            attributes.add(this.createRoMBeanAttributeInfo(ATTR_SERVLETS, String[].class.getName(), "The servlets"));
            return attributes;
        }
    }

    private static class AppClientModuleHandler
    extends J2EEModuleHandler {
        static final AppClientModuleHandler INSTANCE = new AppClientModuleHandler();

        private AppClientModuleHandler() {
        }

        @Override
        Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
            return super.getAttribute(reader, name, attribute);
        }
    }

    private static abstract class J2EEModuleHandler
    extends J2EEDeployedObjectHandler {
        static final String ATTR_JAVA_VMS = "javaVMs";

        private J2EEModuleHandler() {
        }

        @Override
        Set<ObjectName> queryObjectNames(ModelReader reader, ObjectName name, QueryExp query) {
            return Collections.singleton(name);
        }

        @Override
        Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
            if (attribute.equals(ATTR_JAVA_VMS)) {
                return new String[]{JVMHandler.INSTANCE.getObjectName()};
            }
            return super.getAttribute(reader, name, attribute);
        }

        @Override
        Set<MBeanAttributeInfo> getAttributeInfos() {
            Set<MBeanAttributeInfo> attributes = super.getAttributeInfos();
            attributes.add(this.createRoMBeanAttributeInfo(ATTR_JAVA_VMS, String[].class.getName(), "The jvms"));
            return attributes;
        }
    }

    private static class J2EEApplicationHandler
    extends J2EEDeployedObjectHandler {
        private static final J2EEApplicationHandler INSTANCE = new J2EEApplicationHandler();
        static final String ATTR_MODULES = "modules";

        private J2EEApplicationHandler() {
        }

        @Override
        Set<ObjectName> queryObjectNames(ModelReader reader, ObjectName name, QueryExp query) {
            return Collections.singleton(name);
        }

        @Override
        Object getAttribute(ModelReader reader, ObjectName name, String attribute) throws AttributeNotFoundException {
            if (attribute.equals(ATTR_MODULES)) {
                return new String[0];
            }
            return super.getAttribute(reader, name, attribute);
        }

        @Override
        Set<MBeanAttributeInfo> getAttributeInfos() {
            Set<MBeanAttributeInfo> attributes = super.getAttributeInfos();
            attributes.add(this.createRoMBeanAttributeInfo(ATTR_MODULES, String[].class.getName(), "The modules in this application"));
            return attributes;
        }
    }
}

