/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.log;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.felix.log.Log;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

final class LogReaderServiceImpl
implements LogReaderService {
    private final Log m_log;
    private final List m_listeners = new Vector();

    LogReaderServiceImpl(Log log) {
        this.m_log = log;
    }

    @Override
    public synchronized void addLogListener(LogListener listener) {
        this.m_listeners.add(listener);
        this.m_log.addListener(listener);
    }

    @Override
    public synchronized void removeLogListener(LogListener listener) {
        this.m_listeners.remove(listener);
        this.m_log.removeListener(listener);
    }

    @Override
    public Enumeration getLog() {
        return this.m_log.getEntries();
    }

    synchronized void removeAllLogListeners() {
        for (LogListener listener : this.m_listeners) {
            this.m_log.removeListener(listener);
        }
    }
}

