/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.coyote.ajp.AjpAprProtocol;
import org.apache.coyote.ajp.AjpProtocol;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.WebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class WebConnectorService
implements Service<Connector> {
    private volatile String protocol = "HTTP/1.1";
    private volatile String scheme = "http";
    private Boolean enableLookups = null;
    private String proxyName = null;
    private Integer proxyPort = null;
    private Integer redirectPort = null;
    private Boolean secure = null;
    private Integer maxPostSize = null;
    private Integer maxSavePostSize = null;
    private Integer maxConnections = null;
    private ModelNode ssl;
    private List<String> virtualServers;
    private static List<WaitedHostContext> waited = null;
    private Connector connector;
    private final InjectedValue<Executor> executor = new InjectedValue();
    private final InjectedValue<SocketBinding> binding = new InjectedValue();
    private final InjectedValue<OutboundSocketBinding> proxy = new InjectedValue();
    private final InjectedValue<SocketBinding> redirect = new InjectedValue();
    private final InjectedValue<WebServer> server = new InjectedValue();

    public WebConnectorService(String protocol, String scheme) {
        String list;
        if (protocol != null) {
            this.protocol = protocol;
        }
        if (scheme != null) {
            this.scheme = scheme;
        }
        if (waited == null && (list = System.getProperty("org.apache.catalina.connector.WAIT_FOR_BEFORE_START")) != null) {
            waited = new ArrayList<WaitedHostContext>();
            String[] results = list.split(",");
            for (int i = 0; i < results.length; ++i) {
                int index = results[i].indexOf("/");
                if (index > 0) {
                    waited.add(new WaitedHostContext(results[i].substring(0, index), results[i].substring(index)));
                    continue;
                }
                if (index != 0) continue;
                waited.add(new WaitedHostContext(null, results[i].substring(index)));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void start(StartContext context) throws StartException {
        binding = (SocketBinding)this.binding.getValue();
        address = binding.getSocketAddress();
        executor = (Executor)this.executor.getOptionalValue();
        try {
            connector = new Connector(this.protocol);
            connector.setPort(address.getPort());
            connector.setScheme(this.scheme);
            if (this.enableLookups != null) {
                connector.setEnableLookups(this.enableLookups.booleanValue());
            }
            if (this.maxPostSize != null) {
                connector.setMaxPostSize(this.maxPostSize.intValue());
            }
            if (this.maxSavePostSize != null) {
                connector.setMaxSavePostSize(this.maxSavePostSize.intValue());
            }
            if ((proxySocket = (OutboundSocketBinding)this.proxy.getOptionalValue()) != null) {
                connector.setProxyName(proxySocket.getDestinationAddress().getHostName());
                connector.setProxyPort(proxySocket.getDestinationPort());
            } else {
                if (this.proxyName != null) {
                    connector.setProxyName(this.proxyName);
                }
                if (this.proxyPort != null) {
                    connector.setProxyPort(this.proxyPort.intValue());
                }
            }
            redirectSocket = (SocketBinding)this.redirect.getOptionalValue();
            if (redirectSocket != null) {
                connector.setRedirectPort(redirectSocket.getAbsolutePort());
            } else if (this.redirectPort != null) {
                connector.setRedirectPort(this.redirectPort.intValue());
            }
            if (this.secure != null) {
                connector.setSecure(this.secure.booleanValue());
            }
            nativeProtocolHandler = false;
            nioProtocolHandler = false;
            if (connector.getProtocolHandler() instanceof Http11AprProtocol || connector.getProtocolHandler() instanceof AjpAprProtocol) {
                nativeProtocolHandler = true;
            }
            if (connector.getProtocolHandler() instanceof Http11NioProtocol) {
                nioProtocolHandler = true;
            }
            if (executor != null) {
                m = connector.getProtocolHandler().getClass().getMethod("setExecutor", new Class[]{Executor.class});
                m.invoke((Object)connector.getProtocolHandler(), new Object[]{executor});
            }
            if (address != null && address.getAddress() != null) {
                m = connector.getProtocolHandler().getClass().getMethod("setAddress", new Class[]{InetAddress.class});
                m.invoke((Object)connector.getProtocolHandler(), new Object[]{address.getAddress()});
            }
            if (this.maxConnections != null) {
                try {
                    m = connector.getProtocolHandler().getClass().getMethod("setPollerSize", new Class[]{Integer.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.maxConnections});
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                if (nativeProtocolHandler || nioProtocolHandler) {
                    try {
                        m = connector.getProtocolHandler().getClass().getMethod("setSendfileSize", new Class[]{Integer.TYPE});
                        m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.maxConnections});
                    }
                    catch (NoSuchMethodException e) {}
                } else {
                    m = connector.getProtocolHandler().getClass().getMethod("setMaxThreads", new Class[]{Integer.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.maxConnections});
                }
            }
            if (this.virtualServers != null) {
                virtualServersList = new HashSet<String>();
                for (String virtualServer : this.virtualServers) {
                    virtualServersList.add(virtualServer);
                }
                connector.setAllowedHosts(virtualServersList);
            }
            if (this.ssl != null) {
                nativeSSL = false;
                if (connector.getProtocolHandler() instanceof Http11AprProtocol) {
                    nativeSSL = true;
                } else if (connector.getProtocolHandler() instanceof AjpProtocol || connector.getProtocolHandler() instanceof AjpAprProtocol) {
                    throw new StartException(WebMessages.MESSAGES.noSSLWithNonHTTPConnectors());
                }
                try {
                    m = connector.getProtocolHandler().getClass().getMethod("setSSLEnabled", new Class[]{Boolean.TYPE});
                    m.invoke((Object)connector.getProtocolHandler(), new Object[]{true});
                }
                catch (NoSuchMethodException e) {
                    throw new StartException(WebMessages.MESSAGES.failedSSLConfiguration(), (Throwable)e);
                }
                if (nativeSSL) {
                    try {
                        if (this.ssl.hasDefined("password")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLPassword", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("password").asString()});
                        }
                        if (this.ssl.hasDefined("certificate-key-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCertificateKeyFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("certificate-key-file").asString()});
                        }
                        if (this.ssl.hasDefined("cipher-suite")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCipherSuite", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("cipher-suite").asString()});
                        }
                        if (this.ssl.hasDefined("protocol")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLProtocol", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("protocol").asString()});
                        }
                        if (this.ssl.hasDefined("verify-client")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLVerifyClient", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-client").asString()});
                        }
                        if (this.ssl.hasDefined("verify-depth")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLVerifyDepth", new Class[]{Integer.TYPE});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-depth").asInt()});
                        }
                        if (this.ssl.hasDefined("certificate-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCertificateFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("certificate-file").asString()});
                        }
                        if (this.ssl.hasDefined("ca-certificate-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setSSLCACertificateFile", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("ca-certificate-file").asString()});
                        }
                        if (!this.ssl.hasDefined("ca-revocation-url")) ** GOTO lbl185
                        m = connector.getProtocolHandler().getClass().getMethod("setSSLCARevocationFile", new Class[]{String.class});
                        m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("ca-revocation-url").asString()});
                    }
                    catch (NoSuchMethodException e) {
                        throw new StartException(WebMessages.MESSAGES.failedSSLConfiguration(), (Throwable)e);
                    }
                } else {
                    try {
                        if (this.ssl.hasDefined("key-alias")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeyAlias", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("key-alias").asString()});
                        }
                        if (this.ssl.hasDefined("password")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeypass", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("password").asString()});
                        }
                        if (this.ssl.hasDefined("certificate-key-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeystore", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("certificate-key-file").asString()});
                        }
                        if (this.ssl.hasDefined("cipher-suite")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setCiphers", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("cipher-suite").asString()});
                        }
                        if (this.ssl.hasDefined("protocol")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setProtocols", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("protocol").asString()});
                        }
                        if (this.ssl.hasDefined("ssl-protocol")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"protocol", this.ssl.get("ssl-protocol").asString()});
                        }
                        if (this.ssl.hasDefined("verify-client")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setClientauth", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("verify-client").asString()});
                        }
                        if (this.ssl.hasDefined("session-cache-size")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"sessionCacheSize", this.ssl.get("session-cache-size").asString()});
                        }
                        if (this.ssl.hasDefined("session-timeout")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"sessionCacheTimeout", this.ssl.get("session-timeout").asString()});
                        }
                        if (this.ssl.hasDefined("ca-certificate-file")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"truststoreFile", this.ssl.get("ca-certificate-file").asString()});
                        }
                        if (this.ssl.hasDefined("ca-certificate-password")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"truststorePass", this.ssl.get("ca-certificate-password").asString()});
                        }
                        if (this.ssl.hasDefined("truststore-type")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"truststoreType", this.ssl.get("truststore-type").asString()});
                        }
                        if (this.ssl.hasDefined("keystore-type")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setKeytype", new Class[]{String.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{this.ssl.get("keystore-type").asString()});
                        }
                        if (this.ssl.hasDefined("ca-revocation-url")) {
                            m = connector.getProtocolHandler().getClass().getMethod("setAttribute", new Class[]{String.class, Object.class});
                            m.invoke((Object)connector.getProtocolHandler(), new Object[]{"crlFile", this.ssl.get("ca-revocation-url").asString()});
                        }
                    }
                    catch (NoSuchMethodException e) {
                        throw new StartException(WebMessages.MESSAGES.failedSSLConfiguration(), (Throwable)e);
                    }
                }
            }
lbl185:
            // 5 sources

            this.getWebServer().addConnector(connector);
            connector.init();
            webServer = this.getWebServer();
            propertyListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getSource() instanceof Context && "available".equals(event.getPropertyName()) && Boolean.FALSE.equals(event.getOldValue()) && Boolean.TRUE.equals(event.getNewValue())) {
                        Context context = (Context)event.getSource();
                        WebConnectorService.this.addStarted(context.getParent().getName(), context.getPath());
                        if (WebConnectorService.this.areAllStarted()) {
                            try {
                                connector.start();
                            }
                            catch (LifecycleException lifecycleException) {
                                // empty catch block
                            }
                        }
                    }
                }
            };
            contextListener = new ContainerListener(){

                public void containerEvent(ContainerEvent event) {
                    Object child = event.getData();
                    if (event.getContainer() instanceof Host) {
                        ((Container)child).addPropertyChangeListener(propertyListener);
                    }
                }
            };
            hostListener = new ContainerListener(){

                public void containerEvent(ContainerEvent event) {
                    Object child = event.getData();
                    if (event.getContainer() instanceof Engine && event.getType().equals("addChild") && child instanceof Host) {
                        ((Host)child).addContainerListener(contextListener);
                    }
                }
            };
            allstarted = true;
            if (WebConnectorService.waited != null) {
                engine = (Engine)webServer.getService().getContainer();
                engine.addContainerListener(hostListener);
                engine.addContainerListener(contextListener);
                containers = engine.findChildren();
                for (j = 0; j < containers.length; ++j) {
                    if (!(containers[j] instanceof Host)) continue;
                    host = (Host)containers[j];
                    containers[j].addContainerListener(contextListener);
                    contexts = host.findChildren();
                    for (i = 0; i < contexts.length; ++i) {
                        contexts[i].addPropertyChangeListener(propertyListener);
                        if (!contexts[i].isStarted()) continue;
                        cont = (Context)contexts[i];
                        this.addStarted(host.getName(), cont.getPath());
                    }
                }
                allstarted = this.areAllStarted();
            }
            if (allstarted && !connector.isAvailable()) {
                connector.start();
            }
            this.connector = connector;
        }
        catch (Exception e) {
            throw new StartException(WebMessages.MESSAGES.connectorStartError(), (Throwable)e);
        }
        binding.getSocketBindings().getNamedRegistry().registerBinding((ManagedBinding)new ConnectorBinding(binding));
    }

    private boolean areAllStarted() {
        boolean allstarted = true;
        for (WaitedHostContext wait : waited) {
            if (wait.isSeen()) continue;
            allstarted = false;
            break;
        }
        return allstarted;
    }

    private void addStarted(String host, String context) {
        for (WaitedHostContext wait : waited) {
            if (wait.host == null) {
                if (!context.equals(wait.context)) continue;
                wait.seen = true;
                break;
            }
            if (!context.equals(wait.context) || !host.equals(wait.host)) continue;
            wait.seen = true;
            break;
        }
    }

    public synchronized void stop(StopContext context) {
        SocketBinding binding = (SocketBinding)this.binding.getValue();
        binding.getSocketBindings().getNamedRegistry().unregisterBinding(binding.getName());
        Connector connector = this.connector;
        try {
            connector.pause();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            connector.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getWebServer().removeConnector(connector);
        this.connector = null;
    }

    public synchronized Connector getValue() throws IllegalStateException {
        Connector connector = this.connector;
        if (connector == null) {
            throw WebMessages.MESSAGES.nullValue();
        }
        return connector;
    }

    void setSsl(ModelNode ssl) {
        this.ssl = ssl;
    }

    void setVirtualServers(List<String> virtualServers) {
        this.virtualServers = virtualServers;
    }

    protected boolean isEnableLookups() {
        return this.enableLookups;
    }

    protected void setEnableLookups(boolean enableLookups) {
        this.enableLookups = enableLookups;
    }

    protected String getProxyName() {
        return this.proxyName;
    }

    protected void setProxyName(String proxyName) {
        this.proxyName = proxyName;
    }

    protected int getProxyPort() {
        return this.proxyPort;
    }

    protected void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    protected int getRedirectPort() {
        return this.redirectPort;
    }

    protected void setRedirectPort(int redirectPort) {
        this.redirectPort = redirectPort;
    }

    protected boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    protected int getMaxPostSize() {
        return this.maxPostSize;
    }

    protected void setMaxPostSize(int maxPostSize) {
        this.maxPostSize = maxPostSize;
    }

    protected int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    protected void setMaxSavePostSize(int maxSavePostSize) {
        this.maxSavePostSize = maxSavePostSize;
    }

    protected int getMaxConnections() {
        return this.maxConnections;
    }

    protected void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    InjectedValue<Executor> getExecutor() {
        return this.executor;
    }

    InjectedValue<SocketBinding> getBinding() {
        return this.binding;
    }

    InjectedValue<OutboundSocketBinding> getProxy() {
        return this.proxy;
    }

    InjectedValue<SocketBinding> getRedirect() {
        return this.redirect;
    }

    InjectedValue<WebServer> getServer() {
        return this.server;
    }

    private WebServer getWebServer() {
        return (WebServer)this.server.getValue();
    }

    private class WaitedHostContext {
        String host;
        String context;
        boolean seen;

        private boolean isSeen() {
            return this.seen;
        }

        public WaitedHostContext(String host, String context) {
            this.host = host;
            this.context = context.equals("/") ? "" : context;
            this.seen = false;
        }
    }

    static class ConnectorBinding
    implements ManagedBinding {
        private final SocketBinding binding;

        private ConnectorBinding(SocketBinding binding) {
            this.binding = binding;
        }

        public String getSocketBindingName() {
            return this.binding.getName();
        }

        public InetSocketAddress getBindAddress() {
            return this.binding.getSocketAddress();
        }

        public void close() throws IOException {
        }
    }
}

