/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebSSLAdd;
import org.jboss.as.web.WebSSLRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class WebSSLDefinition
extends SimpleResourceDefinition {
    protected static final WebSSLDefinition INSTANCE = new WebSSLDefinition();
    protected static final SimpleAttributeDefinition NAME = new SimpleAttributeDefinitionBuilder("name", ModelType.STRING).setXmlName("name").setAllowNull(true).build();
    protected static final SimpleAttributeDefinition KEY_ALIAS = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("key-alias", ModelType.STRING).setAllowNull(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setAllowExpression(true).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).build();
    protected static final SimpleAttributeDefinition PASSWORD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("password", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).addAccessConstraint((AccessConstraintDefinition)SensitiveTargetAccessConstraintDefinition.CREDENTIAL)).build();
    protected static final SimpleAttributeDefinition CERTIFICATE_KEY_FILE = new SimpleAttributeDefinitionBuilder("certificate-key-file", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CIPHER_SUITE = new SimpleAttributeDefinitionBuilder("cipher-suite", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setDefaultValue(new ModelNode("HIGH:!aNULL:!eNULL:!EXPORT:!DES:!RC4:!MD5")).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition PROTOCOL = new SimpleAttributeDefinitionBuilder("protocol", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition VERIFY_CLIENT = new SimpleAttributeDefinitionBuilder("verify-client", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition VERIFY_DEPTH = new SimpleAttributeDefinitionBuilder("verify-depth", ModelType.INT).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(0, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CERTIFICATE_FILE = new SimpleAttributeDefinitionBuilder("certificate-file", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CA_CERTIFICATE_FILE = new SimpleAttributeDefinitionBuilder("ca-certificate-file", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CA_CERTIFICATE_PASSWORD = new SimpleAttributeDefinitionBuilder("ca-certificate-password", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition CA_REVOCATION_URL = new SimpleAttributeDefinitionBuilder("ca-revocation-url", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition TRUSTSTORE_TYPE = new SimpleAttributeDefinitionBuilder("truststore-type", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition KEYSTORE_TYPE = new SimpleAttributeDefinitionBuilder("keystore-type", ModelType.STRING).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition SESSION_CACHE_SIZE = new SimpleAttributeDefinitionBuilder("session-cache-size", ModelType.INT).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition SESSION_TIMEOUT = new SimpleAttributeDefinitionBuilder("session-timeout", ModelType.INT).setAllowNull(true).setAllowExpression(true).setValidator((ParameterValidator)new IntRangeValidator(1, true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static final SimpleAttributeDefinition SSL_PROTOCOL = new SimpleAttributeDefinitionBuilder("ssl-protocol", ModelType.STRING).setAllowNull(true).setValidator((ParameterValidator)new StringLengthValidator(1, true)).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).build();
    protected static SimpleAttributeDefinition[] SSL_ATTRIBUTES = new SimpleAttributeDefinition[]{KEY_ALIAS, PASSWORD, CERTIFICATE_KEY_FILE, CIPHER_SUITE, PROTOCOL, VERIFY_CLIENT, VERIFY_DEPTH, CERTIFICATE_FILE, CA_CERTIFICATE_FILE, CA_REVOCATION_URL, CA_CERTIFICATE_PASSWORD, KEYSTORE_TYPE, TRUSTSTORE_TYPE, SESSION_CACHE_SIZE, SESSION_TIMEOUT, SSL_PROTOCOL};
    private List<AccessConstraintDefinition> accessConstraints;

    private WebSSLDefinition() {
        super(WebExtension.SSL_PATH, (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("connector.ssl"), (OperationStepHandler)WebSSLAdd.INSTANCE, (OperationStepHandler)WebSSLRemove.INSTANCE);
        SensitivityClassification sc = new SensitivityClassification("web", "web-ssl", false, true, true);
        this.accessConstraints = new SensitiveTargetAccessConstraintDefinition(sc).wrapAsList();
        this.setDeprecated(WebExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration ssl) {
        ssl.registerReadOnlyAttribute((AttributeDefinition)NAME, (OperationStepHandler)ReadResourceNameOperationStepHandler.INSTANCE);
        for (SimpleAttributeDefinition attr : SSL_ATTRIBUTES) {
            ssl.registerReadWriteAttribute((AttributeDefinition)attr, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{attr}));
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

