/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.as.web.WebMessages;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;

class SecurityActions {
    static final PrivilegedAction<SecurityContext> GET_SECURITY_CONTEXT = new PrivilegedAction<SecurityContext>(){

        @Override
        public SecurityContext run() {
            return SecurityContextAssociation.getSecurityContext();
        }
    };
    public static final PrivilegedAction<Void> CLEAR_SECURITY_CONTEXT = new PrivilegedAction<Void>(){

        @Override
        public Void run() {
            SecurityContextAssociation.clearSecurityContext();
            return null;
        }
    };

    private SecurityActions() {
    }

    static String getSystemProperty(final String key, final String defaultValue) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(key, defaultValue);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, defaultValue);
            }
        });
    }

    static void setSystemProperty(final String key, final String value) {
        if (System.getSecurityManager() == null) {
            System.setProperty(key, value);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.setProperty(key, value);
                    return null;
                }
            });
        }
    }

    static SecurityContext createSecurityContext(final String domain) {
        if (System.getSecurityManager() == null) {
            try {
                return SecurityContextFactory.createSecurityContext((String)domain);
            }
            catch (Exception e) {
                throw WebMessages.MESSAGES.failToCreateSecurityContext(e);
            }
        }
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                try {
                    return SecurityContextFactory.createSecurityContext((String)domain);
                }
                catch (Exception e) {
                    throw WebMessages.MESSAGES.failToCreateSecurityContext(e);
                }
            }
        });
    }

    static void setSecurityContextOnAssociation(final SecurityContext sc) {
        if (System.getSecurityManager() == null) {
            SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                    return null;
                }
            });
        }
    }

    static SecurityContext getSecurityContext() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getSecurityContext();
        }
        return AccessController.doPrivileged(GET_SECURITY_CONTEXT);
    }

    static void pushRunAsIdentity(final RunAsIdentity principal, final SecurityContext sc) {
        if (sc == null) {
            throw WebMessages.MESSAGES.noSecurityContext();
        }
        if (System.getSecurityManager() == null) {
            sc.setOutgoingRunAs((RunAs)principal);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    sc.setOutgoingRunAs((RunAs)principal);
                    return null;
                }
            });
        }
    }

    static void clearSecurityContext() {
        if (System.getSecurityManager() == null) {
            SecurityContextAssociation.clearSecurityContext();
        } else {
            AccessController.doPrivileged(CLEAR_SECURITY_CONTEXT);
        }
    }
}

