/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.ThreadBindingListener;
import org.apache.catalina.core.StandardContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.web.ThreadSetupBindingListener;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.ServletContextAttribute;
import org.jboss.as.web.deployment.WebInjectionContainer;
import org.jboss.as.web.security.JBossWebRealm;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class WebDeploymentService
implements Service<StandardContext> {
    private final boolean websockets;
    private final StandardContext context;
    private final InjectedValue<Realm> realm = new InjectedValue();
    private final WebInjectionContainer injectionContainer;
    private final List<SetupAction> setupActions;
    final List<ServletContextAttribute> attributes;
    private final InjectedValue<ExecutorService> serverExecutor = new InjectedValue();

    public WebDeploymentService(boolean websockets, StandardContext context, WebInjectionContainer injectionContainer, List<SetupAction> setupActions, List<ServletContextAttribute> attributes) {
        this.websockets = websockets;
        this.context = context;
        this.injectionContainer = injectionContainer;
        this.setupActions = setupActions;
        this.attributes = attributes;
    }

    InjectedValue<Realm> getRealm() {
        return this.realm;
    }

    public synchronized void start(final StartContext startContext) throws StartException {
        startContext.asynchronous();
        ((ExecutorService)this.serverExecutor.getValue()).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    WebDeploymentService.this.doStart();
                    startContext.complete();
                }
                catch (Throwable e) {
                    startContext.failed(new StartException(e));
                }
            }
        });
    }

    public synchronized void stop(final StopContext stopContext) {
        stopContext.asynchronous();
        ((ExecutorService)this.serverExecutor.getValue()).submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    WebDeploymentService.this.doStop();
                }
                finally {
                    stopContext.complete();
                }
            }
        });
    }

    public synchronized StandardContext getValue() throws IllegalStateException {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return this.context;
    }

    Injector<ExecutorService> getServerExecutorInjector() {
        return this.serverExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() throws StartException {
        ServletContext sc = this.context.getServletContext();
        if (this.attributes != null) {
            for (ServletContextAttribute attribute : this.attributes) {
                sc.setAttribute(attribute.getName(), attribute.getValue());
            }
        }
        this.context.setRealm((Realm)this.realm.getValue());
        WebInjectionContainer.setCurrentInjectionContainer(this.injectionContainer);
        ArrayList<SetupAction> actions = new ArrayList<SetupAction>();
        actions.addAll(this.setupActions);
        this.context.setInstanceManager((InstanceManager)this.injectionContainer);
        ThreadSetupBindingListener threadBindingListener = new ThreadSetupBindingListener(actions);
        this.context.setThreadBindingListener((ThreadBindingListener)threadBindingListener);
        if (this.websockets) {
            sc.setAttribute(ThreadBindingListener.class.getName(), (Object)threadBindingListener);
        }
        WebLogger.WEB_LOGGER.registerWebapp(this.context.getName());
        try {
            try {
                this.context.create();
            }
            catch (Exception e) {
                throw new StartException(WebMessages.MESSAGES.createContextFailed(), (Throwable)e);
            }
            try {
                this.context.start();
            }
            catch (LifecycleException e) {
                throw new StartException(WebMessages.MESSAGES.startContextFailed(), (Throwable)e);
            }
            if (this.context.getState() != 1) {
                throw new StartException(WebMessages.MESSAGES.startContextFailed());
            }
        }
        finally {
            WebInjectionContainer.setCurrentInjectionContainer(null);
        }
    }

    private void doStop() {
        WebLogger.WEB_LOGGER.unregisterWebapp(this.context.getName());
        try {
            this.context.stop();
            this.clearRealmCache();
        }
        catch (LifecycleException e) {
            WebLogger.WEB_LOGGER.stopContextFailed(e);
        }
        try {
            this.context.destroy();
        }
        catch (Exception e) {
            WebLogger.WEB_LOGGER.destroyContextFailed(e);
        }
    }

    private void clearRealmCache() {
        Realm currentRealm = (Realm)this.realm.getValue();
        if (currentRealm != null && currentRealm instanceof JBossWebRealm) {
            ((JBossWebRealm)currentRealm).clearAuthenticationCache(this.injectionContainer.getDefaultClassLoader());
        }
    }

    public static class ContextActivator {
        public static final AttachmentKey<ContextActivator> ATTACHMENT_KEY = AttachmentKey.create(ContextActivator.class);
        private final ServiceController<StandardContext> controller;

        ContextActivator(ServiceController<StandardContext> controller) {
            this.controller = controller;
        }

        public StandardContext getContext() {
            return (StandardContext)this.controller.getValue();
        }

        public synchronized void startAsync() {
            this.controller.setMode(ServiceController.Mode.ACTIVE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean start(long timeout, TimeUnit unit) throws TimeoutException {
            if (this.controller.getMode() == ServiceController.Mode.NEVER) {
                this.controller.setMode(ServiceController.Mode.ACTIVE);
                StabilityMonitor monitor = new StabilityMonitor();
                monitor.addController(this.controller);
                try {
                    if (!monitor.awaitStability(timeout, unit)) {
                        throw WebMessages.MESSAGES.timeoutContextActivation(this.controller.getName());
                    }
                }
                catch (InterruptedException e) {
                }
                finally {
                    monitor.removeController(this.controller);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean stop(long timeout, TimeUnit unit) {
            boolean result = true;
            if (this.controller.getMode() == ServiceController.Mode.ACTIVE) {
                this.controller.setMode(ServiceController.Mode.NEVER);
                StabilityMonitor monitor = new StabilityMonitor();
                monitor.addController(this.controller);
                try {
                    if (!monitor.awaitStability(timeout, unit)) {
                        WebLogger.WEB_LOGGER.debugf("Timeout stopping context: %s", this.controller.getName());
                    }
                }
                catch (InterruptedException e) {
                }
                finally {
                    monitor.removeController(this.controller);
                }
            }
            return result;
        }
    }
}

