/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.WebLogger;
import org.jboss.as.web.WebMessages;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.security.JBossGenericPrincipal;
import org.jboss.as.web.security.SecurityActions;
import org.jboss.as.web.security.SecurityContextAssociationValve;
import org.jboss.as.web.security.WebUtil;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.auth.callback.DigestCallbackHandler;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.security.authentication.JBossCachedAuthenticationManager;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.javaee.AbstractWebAuthorizationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingType;
import org.jboss.web.CatalinaMessages;

public class JBossWebRealm
extends RealmBase {
    protected static final String name = "JBossWebRealm";
    protected AuditManager auditManager = null;
    protected AuthenticationManager authenticationManager = null;
    protected AuthorizationManager authorizationManager = null;
    protected MappingManager mappingManager = null;
    protected CertificatePrincipal certMapping = new SubjectDNMapping();
    protected DeploymentUnit deploymentUnit;
    protected JBossWebMetaData metaData;
    protected Map<String, Set<String>> principalVersusRolesMap;
    protected boolean useJBossAuthorization = false;
    protected boolean disableAudit = false;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuditManager(AuditManager auditManager) {
        this.auditManager = auditManager;
    }

    public void setAuthorizationManager(AuthorizationManager authorizationManager) {
        this.authorizationManager = authorizationManager;
    }

    public void setMappingManager(MappingManager mappingManager) {
        this.mappingManager = mappingManager;
    }

    public void setDeploymentUnit(DeploymentUnit deploymentUnit) {
        this.deploymentUnit = deploymentUnit;
        this.metaData = ((WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY)).getMergedJBossWebMetaData();
        this.principalVersusRolesMap = this.metaData.getSecurityRoles().getPrincipalVersusRolesMap();
        this.useJBossAuthorization = this.metaData.isUseJBossAuthorization();
        this.disableAudit = this.metaData.isDisableAudit();
    }

    public Map<String, Set<String>> getPrincipalVersusRolesMap() {
        return this.principalVersusRolesMap;
    }

    public Principal authenticate(String username, String credentials) {
        Principal userPrincipal;
        if (username == null && credentials == null) {
            return null;
        }
        if (this.authenticationManager == null) {
            throw new IllegalStateException("Authentication Manager has not been set");
        }
        if (this.authorizationManager == null) {
            throw new IllegalStateException("Authorization Manager has not been set");
        }
        Principal incomingPrincipal = this.getPrincipal(username);
        Subject subject = new Subject();
        try {
            boolean isValid = this.authenticationManager.isValid(incomingPrincipal, (Object)credentials, subject);
            if (isValid) {
                MappingContext mc;
                WebLogger.WEB_SECURITY_LOGGER.tracef("User: " + incomingPrincipal + " is authenticated", new Object[0]);
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("No SecurityContext found!");
                }
                sc.getUtil().createSubjectInfo(incomingPrincipal, (Object)credentials, subject);
                Object userPrincipal2 = this.getPrincipal(subject);
                SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(sc);
                if (this.mappingManager != null && (mc = this.mappingManager.getMappingContext(MappingType.ROLE.name())) != null && mc.hasModules()) {
                    SecurityRolesAssociation.setSecurityRoles(this.principalVersusRolesMap);
                }
                RoleGroup roles = this.authorizationManager.getSubjectRoles(subject, (CallbackHandler)scb);
                List rolesAsList = roles.getRoles();
                List<String> rolesAsStringList = new ArrayList<String>();
                for (Role role : rolesAsList) {
                    rolesAsStringList.add(role.getRoleName());
                }
                if (this.mappingManager != null) {
                    MappingContext mc2 = this.mappingManager.getMappingContext(MappingType.ROLE.name());
                    if (mc2 == null || !mc2.hasModules()) {
                        rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                    }
                } else {
                    rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                }
                userPrincipal2 = new JBossGenericPrincipal((Realm)this, incomingPrincipal.getName(), null, rolesAsStringList, (Principal)userPrincipal2, null, credentials, this.authenticationManager, subject);
                this.successAudit((Principal)userPrincipal2, null);
                return userPrincipal2;
            }
        }
        catch (Exception e) {
            WebLogger.WEB_SECURITY_LOGGER.authenticateError(e);
            userPrincipal = null;
            this.exceptionAudit(userPrincipal, null, e);
        }
        userPrincipal = super.authenticate(username, credentials);
        if (userPrincipal != null) {
            this.successAudit(userPrincipal, null);
        } else {
            this.failureAudit(userPrincipal, null);
        }
        return userPrincipal;
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return null;
        }
        if (this.authenticationManager == null) {
            throw WebMessages.MESSAGES.noAuthenticationManager();
        }
        if (this.authorizationManager == null) {
            throw WebMessages.MESSAGES.noAuthorizationManager();
        }
        Principal incomingPrincipal = this.certMapping.toPrincipal(certs);
        Object userPrincipal = null;
        try {
            Subject subject = new Subject();
            boolean isValid = this.authenticationManager.isValid(incomingPrincipal, (Object)certs, subject);
            if (isValid) {
                MappingContext mc;
                WebLogger.WEB_SECURITY_LOGGER.tracef("User: " + incomingPrincipal + " is authenticated", new Object[0]);
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc == null) {
                    throw new IllegalStateException("No SecurityContext found!");
                }
                sc.getUtil().createSubjectInfo(incomingPrincipal, (Object)certs, subject);
                userPrincipal = this.getPrincipal(subject);
                SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(sc);
                if (this.mappingManager != null && (mc = this.mappingManager.getMappingContext(MappingType.ROLE.name())) != null && mc.hasModules()) {
                    SecurityRolesAssociation.setSecurityRoles(this.principalVersusRolesMap);
                }
                RoleGroup roles = this.authorizationManager.getSubjectRoles(subject, (CallbackHandler)scb);
                List rolesAsList = roles.getRoles();
                List<String> rolesAsStringList = new ArrayList<String>();
                for (Role role : rolesAsList) {
                    rolesAsStringList.add(role.getRoleName());
                }
                if (this.mappingManager != null) {
                    MappingContext mc2 = this.mappingManager.getMappingContext(MappingType.ROLE.name());
                    if (mc2 == null || !mc2.hasModules()) {
                        rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                    }
                } else {
                    rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                }
                userPrincipal = new JBossGenericPrincipal((Realm)this, incomingPrincipal.getName(), null, rolesAsStringList, (Principal)userPrincipal, null, certs, this.authenticationManager, subject);
            } else {
                WebLogger.WEB_SECURITY_LOGGER.tracef("User: " + userPrincipal + " is NOT authenticated", new Object[0]);
                userPrincipal = null;
            }
        }
        catch (Exception e) {
            WebLogger.WEB_SECURITY_LOGGER.authenticateErrorCert(e);
            this.exceptionAudit((Principal)userPrincipal, null, e);
        }
        if (userPrincipal != null) {
            this.successAudit((Principal)userPrincipal, null);
        }
        return userPrincipal;
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, new String(credentials));
    }

    public Principal authenticate(String username, String clientDigest, String nOnce, String nc, String cnonce, String qop, String realm, String md5a2) {
        if (this.authenticationManager == null) {
            throw WebMessages.MESSAGES.noAuthenticationManager();
        }
        if (this.authorizationManager == null) {
            throw WebMessages.MESSAGES.noAuthorizationManager();
        }
        Principal incomingPrincipal = this.getPrincipal(username);
        Object userPrincipal = null;
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            throw WebMessages.MESSAGES.noSecurityContext();
        }
        Principal caller = sc.getUtil().getUserPrincipal();
        if (caller == null && username == null && clientDigest == null) {
            return null;
        }
        try {
            DigestCallbackHandler handler = new DigestCallbackHandler(username, nOnce, nc, cnonce, qop, realm, md5a2);
            CallbackHandlerPolicyContextHandler.setCallbackHandler((CallbackHandler)handler);
            Subject subject = new Subject();
            boolean isValid = this.authenticationManager.isValid(incomingPrincipal, (Object)clientDigest, subject);
            if (isValid) {
                MappingContext mc;
                WebLogger.WEB_SECURITY_LOGGER.tracef("User: " + incomingPrincipal + " is authenticated", new Object[0]);
                sc.getUtil().createSubjectInfo(incomingPrincipal, (Object)clientDigest, subject);
                userPrincipal = this.getPrincipal(subject);
                SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(sc);
                if (this.mappingManager != null && (mc = this.mappingManager.getMappingContext(MappingType.ROLE.name())) != null && mc.hasModules()) {
                    SecurityRolesAssociation.setSecurityRoles(this.principalVersusRolesMap);
                }
                RoleGroup roles = this.authorizationManager.getSubjectRoles(subject, (CallbackHandler)scb);
                List rolesAsList = roles.getRoles();
                List<String> rolesAsStringList = new ArrayList<String>();
                for (Role role : rolesAsList) {
                    rolesAsStringList.add(role.getRoleName());
                }
                if (this.mappingManager != null) {
                    MappingContext mc2 = this.mappingManager.getMappingContext(MappingType.ROLE.name());
                    if (mc2 == null || !mc2.hasModules()) {
                        rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                    }
                } else {
                    rolesAsStringList = this.mapUserRoles(rolesAsStringList);
                }
                userPrincipal = new JBossGenericPrincipal((Realm)this, incomingPrincipal.getName(), null, rolesAsStringList, (Principal)userPrincipal, null, clientDigest, this.authenticationManager, subject);
            } else {
                WebLogger.WEB_SECURITY_LOGGER.tracef("User: " + userPrincipal + " is NOT authenticated", new Object[0]);
                userPrincipal = null;
            }
        }
        catch (Exception e) {
            WebLogger.WEB_SECURITY_LOGGER.authenticateErrorDigest(e);
        }
        if (userPrincipal != null) {
            this.successAudit((Principal)userPrincipal, null);
        } else {
            this.failureAudit((Principal)userPrincipal, null);
        }
        return userPrincipal;
    }

    protected String getName() {
        return name;
    }

    protected String getPassword(String username) {
        return null;
    }

    protected Principal getPrincipal(String username) {
        return new SimplePrincipal(username);
    }

    protected List<String> mapUserRoles(List<String> rolesList) {
        if (this.principalVersusRolesMap != null && this.principalVersusRolesMap.size() > 0) {
            ArrayList<String> mappedRoles = new ArrayList<String>();
            for (String role : rolesList) {
                Set<String> roles = this.principalVersusRolesMap.get(role);
                if (roles != null && roles.size() > 0) {
                    for (String r : roles) {
                        if (mappedRoles.contains(r)) continue;
                        mappedRoles.add(r);
                    }
                    continue;
                }
                if (mappedRoles.contains(role)) continue;
                mappedRoles.add(role);
            }
            return mappedRoles;
        }
        return rolesList;
    }

    protected Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        HashMap<String, Object> entries;
        boolean authzDecision = true;
        boolean baseDecision = super.hasResourcePermission(request, response, constraints, context);
        if (baseDecision && this.useJBossAuthorization) {
            SecurityContext sc = SecurityActions.getSecurityContext();
            Subject caller = sc.getUtil().getSubject();
            if (caller == null) {
                caller = this.getSubjectFromRequestPrincipal(request.getPrincipal());
            }
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put("resourcePermissionCheck", Boolean.TRUE);
            contextMap.put("securityConstraints", constraints);
            AbstractWebAuthorizationHelper helper = null;
            try {
                helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
            }
            catch (Exception e) {
                WebLogger.WEB_SECURITY_LOGGER.noAuthorizationHelper(e);
                return false;
            }
            authzDecision = helper.checkResourcePermission(contextMap, (ServletRequest)request, (ServletResponse)response, caller, PolicyContext.getContextID(), this.requestURI(request), this.getPrincipalRoles(request));
        }
        boolean finalDecision = baseDecision && authzDecision;
        WebLogger.WEB_SECURITY_LOGGER.tracef("hasResourcePermission:RealmBase says:" + baseDecision + "::Authz framework says:" + authzDecision + ":final=" + finalDecision, new Object[0]);
        if (!finalDecision) {
            if (!this.disableAudit) {
                entries = new HashMap<String, Object>();
                entries.put("Step", "hasResourcePermission");
                this.failureAudit(request.getUserPrincipal(), entries);
            }
            response.sendError(403, CatalinaMessages.MESSAGES.forbiddenAccess());
        } else if (!this.disableAudit) {
            entries = new HashMap();
            entries.put("Step", "hasResourcePermission");
            this.successAudit(request.getUserPrincipal(), entries);
        }
        return finalDecision;
    }

    public boolean hasRole(Principal principal, String role) {
        HashMap<String, Object> entries;
        boolean authzDecision = true;
        boolean baseDecision = super.hasRole(principal, role);
        if (baseDecision && this.useJBossAuthorization) {
            Request request = SecurityContextAssociationValve.getActiveRequest();
            String servletName = null;
            Wrapper servlet = request.getWrapper();
            if (servlet != null) {
                servletName = this.getServletName(servlet);
            }
            if (servletName == null) {
                throw new IllegalStateException("servletName is null");
            }
            String roleName = role;
            ServletMetaData servletMD = (ServletMetaData)this.metaData.getServlets().get(servletName);
            SecurityRoleRefsMetaData roleRefs = null;
            if (servletMD != null) {
                roleRefs = servletMD.getSecurityRoleRefs();
            }
            if (roleRefs != null) {
                for (SecurityRoleRefMetaData ref : roleRefs) {
                    if (!ref.getRoleLink().equals(role)) continue;
                    roleName = ref.getName();
                    break;
                }
            }
            SecurityContext sc = SecurityActions.getSecurityContext();
            AbstractWebAuthorizationHelper helper = null;
            try {
                helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
            }
            catch (Exception e) {
                WebLogger.WEB_SECURITY_LOGGER.noAuthorizationHelper(e);
            }
            Subject callerSubject = sc.getUtil().getSubject();
            if (callerSubject == null) {
                callerSubject = this.getSubjectFromRequestPrincipal(principal);
            }
            authzDecision = helper.hasRole(roleName, principal, servletName, this.getPrincipalRoles(principal), PolicyContext.getContextID(), callerSubject, this.getPrincipalRoles(request));
        }
        boolean finalDecision = baseDecision && authzDecision;
        WebLogger.WEB_SECURITY_LOGGER.tracef("hasRole:RealmBase says:" + baseDecision + "::Authz framework says:" + authzDecision + ":final=" + finalDecision, new Object[0]);
        if (finalDecision) {
            if (!this.disableAudit) {
                entries = new HashMap<String, Object>();
                entries.put("Step", "hasRole");
                this.successAudit(principal, entries);
            }
        } else if (!this.disableAudit) {
            entries = new HashMap();
            entries.put("Step", "hasRole");
            this.failureAudit(principal, entries);
        }
        return finalDecision;
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        boolean ok = super.hasUserDataPermission(request, response, constraints);
        if (ok && this.useJBossAuthorization) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("securityConstraints", constraints);
            map.put("userDataPermissionCheck", Boolean.TRUE);
            SecurityContext sc = SecurityActions.getSecurityContext();
            AbstractWebAuthorizationHelper helper = null;
            try {
                helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
            }
            catch (Exception e) {
                WebLogger.WEB_SECURITY_LOGGER.noAuthorizationHelper(e);
            }
            Subject callerSubject = sc.getUtil().getSubject();
            if (callerSubject == null) {
                callerSubject = new Subject();
            }
            ok = helper.hasUserDataPermission(map, (ServletRequest)request, (ServletResponse)response, PolicyContext.getContextID(), callerSubject, this.getPrincipalRoles(request));
        }
        if (!ok && response.getStatus() == 200) {
            response.sendError(403);
        }
        return ok;
    }

    protected Subject getSubjectFromRequestPrincipal(Principal principal) {
        Subject subject = null;
        if (principal instanceof JBossGenericPrincipal) {
            subject = ((JBossGenericPrincipal)((Object)JBossGenericPrincipal.class.cast(principal))).getSubject();
        }
        return subject;
    }

    protected Set<Principal> getPrincipalRoles(Principal principal) {
        if (!(principal instanceof GenericPrincipal)) {
            throw WebMessages.MESSAGES.illegalPrincipalType(principal.getClass());
        }
        GenericPrincipal gp = (GenericPrincipal)GenericPrincipal.class.cast(principal);
        String[] roleNames = gp.getRoles();
        HashSet<Principal> userRoles = new HashSet<Principal>();
        if (roleNames != null) {
            for (int n = 0; n < roleNames.length; ++n) {
                Principal sp = this.getPrincipal(roleNames[n]);
                userRoles.add(sp);
            }
        }
        return userRoles;
    }

    protected List<String> getPrincipalRoles(Request request) {
        List<String> roles = null;
        Principal principal = request.getPrincipal();
        if (principal != null && principal instanceof GenericPrincipal) {
            GenericPrincipal gc = (GenericPrincipal)GenericPrincipal.class.cast(principal);
            roles = Arrays.asList(gc.getRoles());
        }
        return roles;
    }

    protected String requestURI(Request request) {
        String uri = request.getMappingData().requestPath.getString();
        if (uri == null || uri.equals("/")) {
            uri = "";
        }
        return uri;
    }

    private String getServletName(Wrapper servlet) {
        String[] mappings = servlet.findMappings();
        WebLogger.WEB_SECURITY_LOGGER.tracef("[getServletName:servletmappings=" + mappings + ":servlet.getName()=" + servlet.getName() + "]", new Object[0]);
        if ("jsp".equals(servlet.getName()) && mappings != null && mappings[0].indexOf("*.jsp") > -1) {
            return "";
        }
        return servlet.getName();
    }

    private HttpServletRequest getServletRequest() {
        try {
            return (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
        }
        catch (Exception e) {
            WebLogger.WEB_SECURITY_LOGGER.tracef("Exception in getting servlet request:", e);
            return null;
        }
    }

    private void successAudit(Principal userPrincipal, Map<String, Object> entries) {
        if (userPrincipal != null && !this.disableAudit && this.auditManager != null) {
            AuditEvent auditEvent = new AuditEvent("Success");
            HashMap<String, Object> ctxMap = new HashMap<String, Object>();
            ctxMap.put("principal", userPrincipal);
            HttpServletRequest hsr = this.getServletRequest();
            if (hsr != null) {
                ctxMap.put("request", WebUtil.deriveUsefulInfo(hsr));
            }
            ctxMap.put("Source", ((Object)((Object)this)).getClass().getCanonicalName());
            if (entries != null) {
                ctxMap.putAll(entries);
            }
            auditEvent.setContextMap(ctxMap);
            this.auditManager.audit(auditEvent);
        }
    }

    private void failureAudit(Principal userPrincipal, Map<String, Object> entries) {
        if (this.auditManager != null && !this.disableAudit) {
            AuditEvent auditEvent = new AuditEvent("Failure");
            HashMap<String, Object> ctxMap = new HashMap<String, Object>();
            ctxMap.put("principal", userPrincipal);
            HttpServletRequest hsr = this.getServletRequest();
            if (hsr != null) {
                ctxMap.put("request", WebUtil.deriveUsefulInfo(hsr));
            }
            ctxMap.put("Source", ((Object)((Object)this)).getClass().getCanonicalName());
            if (entries != null) {
                ctxMap.putAll(entries);
            }
            auditEvent.setContextMap(ctxMap);
            this.auditManager.audit(auditEvent);
        }
    }

    private void exceptionAudit(Principal userPrincipal, Map<String, Object> entries, Exception e) {
        if (this.auditManager != null && !this.disableAudit) {
            AuditEvent auditEvent = new AuditEvent("Error");
            HashMap<String, Object> ctxMap = new HashMap<String, Object>();
            ctxMap.put("principal", userPrincipal);
            ctxMap.putAll(entries);
            HttpServletRequest hsr = this.getServletRequest();
            if (hsr != null) {
                ctxMap.put("request", WebUtil.deriveUsefulInfo(hsr));
            }
            ctxMap.put("source", ((Object)((Object)this)).getClass().getCanonicalName());
            if (entries != null) {
                ctxMap.putAll(entries);
            }
            auditEvent.setContextMap(ctxMap);
            auditEvent.setUnderlyingException(e);
            this.auditManager.audit(auditEvent);
        }
    }

    public void clearAuthenticationCache(ClassLoader moduleLoader) {
        if (this.authenticationManager != null && this.authenticationManager instanceof JBossCachedAuthenticationManager) {
            ((JBossCachedAuthenticationManager)this.authenticationManager).releaseModuleEntries(moduleLoader);
        }
    }
}

