/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class WebUtil {
    public static final String WEB_AUDIT_FLAG = "org.jboss.security.web.audit";
    public static final String WEB_AUDIT_FLAG_DEFAULT = "headers,parameters";
    private static final String auditFlag = WebUtil.getSystemPropertySafe("org.jboss.security.web.audit", "headers,parameters");
    public static final String WEB_AUDIT_MASK = "org.jboss.security.web.audit.mask";
    public static final String WEB_AUDIT_MASK_DEFAULT = "j_password,authorization";
    private static final String auditMask = WebUtil.getSystemPropertySafe("org.jboss.security.web.audit.mask", "j_password,authorization");

    public static String deriveUsefulInfo(HttpServletRequest httpRequest) {
        int i;
        String[] mask = auditMask.split(",");
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(httpRequest.getContextPath());
        if (auditFlag.contains("cookies")) {
            sb.append(":cookies=");
            i = 0;
            sb.append("[");
            Cookie[] cookies = httpRequest.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (WebUtil.contains(cookie.getName(), mask)) continue;
                    if (i++ > 0) {
                        sb.append(",");
                    }
                    sb.append(cookie.toString());
                }
            }
            sb.append("]");
        }
        if (auditFlag.contains("headers")) {
            sb.append(":headers=");
            i = 0;
            sb.append("[");
            Enumeration en = httpRequest.getHeaderNames();
            if (en != null) {
                while (en.hasMoreElements()) {
                    String headerName = (String)en.nextElement();
                    if (WebUtil.contains(headerName, mask)) continue;
                    if (i++ > 0) {
                        sb.append(",");
                    }
                    sb.append(headerName).append("=").append(httpRequest.getHeader(headerName));
                }
            }
            sb.append("]");
        }
        if (auditFlag.contains("parameters")) {
            sb.append(":parameters=");
            i = 0;
            sb.append("[");
            Enumeration enparam = httpRequest.getParameterNames();
            if (enparam != null) {
                while (enparam.hasMoreElements()) {
                    String paramName = (String)enparam.nextElement();
                    if (WebUtil.contains(paramName, mask)) continue;
                    if (i++ > 0) {
                        sb.append(",");
                    }
                    sb.append(paramName).append("=");
                    String[] paramValues = httpRequest.getParameterValues(paramName);
                    int j = 0;
                    for (String v : paramValues) {
                        if (j++ > 0) {
                            sb.append("::");
                        }
                        sb.append(v);
                    }
                }
            }
            sb.append("]");
        }
        if (auditFlag.contains("attributes")) {
            sb.append(":attributes=");
            i = 0;
            sb.append("[");
            Enumeration enu = httpRequest.getAttributeNames();
            if (enu != null) {
                while (enu.hasMoreElements()) {
                    String attrName = (String)enu.nextElement();
                    if (WebUtil.contains(attrName, mask)) continue;
                    if (i++ > 0) {
                        sb.append(",");
                    }
                    sb.append(attrName).append("=").append(httpRequest.getAttribute(attrName));
                }
            }
            sb.append("]");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String getSystemPropertySafe(final String key, final String def) {
        return System.getSecurityManager() == null ? System.getProperty(key, def) : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, def);
            }
        });
    }

    private static boolean contains(String name, String[] mask) {
        for (String m : mask) {
            if (!name.contains(m)) continue;
            return true;
        }
        return false;
    }
}

