/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;

public class Immutable {
    private static final Logger log = Logger.getLogger(Immutable.class);
    public final Class<?> cls;
    final List<String> names = new ArrayList<String>();
    final List<Object> values = new ArrayList<Object>();

    public Immutable(Class<?> cls) {
        this.cls = cls;
        if (log.isTraceEnabled()) {
            log.trace((Object)("created immutable container for " + cls));
        }
    }

    public void addChild(String localName, Object child) {
        if (!this.names.isEmpty() && this.names.get(this.names.size() - 1).equals(localName)) {
            throw new IllegalStateException("Attempt to add duplicate element " + localName + ": prev value=" + this.values.get(this.values.size() - 1) + ", new value=" + child);
        }
        this.names.add(localName);
        this.values.add(child);
        if (log.isTraceEnabled()) {
            log.trace((Object)("added child " + localName + " for " + this.cls + ": " + child));
        }
    }

    public Object getChild(String localName) {
        return this.names.isEmpty() ? null : (this.names.get(this.names.size() - 1).equals(localName) ? this.values.get(this.values.size() - 1) : null);
    }

    public Object newInstance() {
        Constructor<?> ctor = null;
        Constructor<?>[] ctors = this.cls.getConstructors();
        if (ctors == null || ctors.length == 0) {
            throw new JBossXBRuntimeException("The class has no declared constructors: " + this.cls);
        }
        for (int i = 0; i < ctors.length; ++i) {
            Class<?>[] types = ctors[i].getParameterTypes();
            if (types == null || types.length == 0) {
                throw new IllegalStateException("Found no-arg constructor for immutable " + this.cls);
            }
            if (types.length != this.values.size()) continue;
            ctor = ctors[i];
            int typeInd = 0;
            while (typeInd < types.length) {
                if (types[typeInd].isAssignableFrom(this.values.get(typeInd++).getClass())) continue;
                ctor = null;
                break;
            }
            if (ctor != null) break;
        }
        if (ctor == null) {
            throw new IllegalStateException("No constructor in " + this.cls + " that would take arguments " + this.values);
        }
        try {
            return ctor.newInstance(this.values.toArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create immutable instance of " + this.cls + " using arguments: " + this.values + ": " + e.getMessage());
        }
    }
}

